/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.detached;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MutablePath;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedElement;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedProperty;

public class DetachedPath
extends MutablePath
implements Attachable<Path> {
    private DetachedPath() {
    }

    @Override
    public Path get() {
        return this;
    }

    protected DetachedPath(Path path, boolean withProperties) {
        path.forEach((Object object, Set<String> labels) -> {
            if (object instanceof DetachedElement || object instanceof DetachedProperty || object instanceof DetachedPath) {
                this.objects.add(object);
            } else if (object instanceof Element) {
                this.objects.add(DetachedFactory.detach((Element)object, withProperties));
            } else if (object instanceof Property) {
                this.objects.add(DetachedFactory.detach((Property)object));
            } else if (object instanceof Path) {
                this.objects.add(DetachedFactory.detach((Path)object, withProperties));
            } else {
                this.objects.add(object);
            }
            this.labels.add(new LinkedHashSet(labels));
        });
    }

    @Override
    public Path attach(Function<Attachable<Path>, Path> method) {
        Path path = MutablePath.make();
        this.forEach((Object object, Set<String> labels) -> path.extend(object instanceof Attachable ? ((Attachable)object).attach(method) : object, (Set<String>)labels));
        return path;
    }
}

