/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.reference;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceElement;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;

public class ReferenceVertexProperty<V>
extends ReferenceElement<VertexProperty<V>>
implements VertexProperty<V> {
    private ReferenceVertex vertex;
    private String label;
    private V value;

    private ReferenceVertexProperty() {
    }

    public ReferenceVertexProperty(VertexProperty<V> vertexProperty) {
        super(vertexProperty);
        this.vertex = new ReferenceVertex(vertexProperty.element());
        this.label = vertexProperty.key();
        this.value = vertexProperty.value();
    }

    public String toString() {
        return StringFactory.propertyString(this);
    }

    @Override
    public String key() {
        return this.label;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public V value() throws NoSuchElementException {
        return this.value;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public Vertex element() {
        return this.vertex;
    }

    public <U> Property<U> property(String key, U value) {
        throw Element.Exceptions.propertyAdditionNotSupported();
    }

    @Override
    public void remove() {
        throw Property.Exceptions.propertyRemovalNotSupported();
    }

    @Override
    public <U> Iterator<Property<U>> properties(String ... propertyKeys) {
        return Collections.emptyIterator();
    }
}

