/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.config;

import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlConfiguration
extends AbstractHierarchicalFileConfiguration {
    public static final int DEFAULT_IDENT = 4;
    private final DumperOptions yamlOptions = new DumperOptions();
    private final Yaml yaml = new Yaml(this.yamlOptions);
    private boolean xmlCompatibility = true;

    public YamlConfiguration() {
        this.initialize();
    }

    private void initialize() {
        this.yamlOptions.setIndent(4);
        this.yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
    }

    public void setXmlCompatibility(boolean xmlCompatibility) {
        this.xmlCompatibility = xmlCompatibility;
    }

    @Override
    public void load(Reader in) throws ConfigurationException {
        try {
            this.loadHierarchy(this.getRootNode(), this.yaml.load(in));
        }
        catch (Throwable e) {
            throw new ConfigurationException("Failed to load configuration: " + e.getMessage(), e);
        }
    }

    @Override
    public void save(Writer out) throws ConfigurationException {
        try {
            this.yaml.dump(this.saveHierarchy(this.getRootNode()), out);
        }
        catch (Throwable e) {
            throw new ConfigurationException("Failed to save configuration: " + e.getMessage(), e);
        }
    }

    protected void loadHierarchy(ConfigurationNode parentNode, Object obj) {
        String parentName = parentNode.getName();
        if (obj instanceof Map) {
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                HierarchicalConfiguration.Node childNode = new HierarchicalConfiguration.Node((String)entry.getKey());
                if (this.xmlCompatibility && parentName != null && parentName.endsWith("s")) {
                    childNode.setName(parentName.substring(0, parentName.length() - 1));
                    childNode.addAttribute(new HierarchicalConfiguration.Node("name", entry.getKey()));
                }
                childNode.setReference(entry);
                this.loadHierarchy(childNode, entry.getValue());
                parentNode.addChild(childNode);
            }
        } else if (obj instanceof Collection) {
            for (Object child : (Collection)obj) {
                HierarchicalConfiguration.Node childNode = new HierarchicalConfiguration.Node("item");
                childNode.setReference(child);
                this.loadHierarchy(childNode, child);
                parentNode.addChild(childNode);
            }
        }
        parentNode.setValue(obj);
    }

    protected Object saveHierarchy(ConfigurationNode parentNode) {
        if (parentNode.getChildrenCount() == 0) {
            return parentNode.getValue();
        }
        if (parentNode.getChildrenCount("item") == parentNode.getChildrenCount()) {
            return parentNode.getChildren().stream().map(this::saveHierarchy).collect(Collectors.toList());
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (ConfigurationNode childNode : parentNode.getChildren()) {
            String nodeName = childNode.getName();
            if (this.xmlCompatibility && childNode.getAttributes("name").size() > 0) {
                nodeName = String.valueOf(((ConfigurationNode)childNode.getAttributes("name").get(0)).getValue());
            }
            map.put(nodeName, this.saveHierarchy(childNode));
        }
        return map;
    }
}

