/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.jackson.databind.deser.impl;

import java.io.IOException;
import java.util.Set;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonToken;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.deser.BeanDeserializerBase;
import org.apache.tinkerpop.shaded.jackson.databind.deser.SettableBeanProperty;
import org.apache.tinkerpop.shaded.jackson.databind.deser.impl.BeanPropertyMap;
import org.apache.tinkerpop.shaded.jackson.databind.deser.impl.ObjectIdReader;
import org.apache.tinkerpop.shaded.jackson.databind.deser.impl.PropertyBasedCreator;
import org.apache.tinkerpop.shaded.jackson.databind.deser.impl.PropertyValueBuffer;
import org.apache.tinkerpop.shaded.jackson.databind.introspect.AnnotatedMethod;
import org.apache.tinkerpop.shaded.jackson.databind.util.NameTransformer;

public class BeanAsArrayBuilderDeserializer
extends BeanDeserializerBase {
    private static final long serialVersionUID = 1L;
    protected final BeanDeserializerBase _delegate;
    protected final SettableBeanProperty[] _orderedProperties;
    protected final AnnotatedMethod _buildMethod;

    public BeanAsArrayBuilderDeserializer(BeanDeserializerBase delegate, SettableBeanProperty[] ordered, AnnotatedMethod buildMethod) {
        super(delegate);
        this._delegate = delegate;
        this._orderedProperties = ordered;
        this._buildMethod = buildMethod;
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer unwrapper) {
        return this._delegate.unwrappingDeserializer(unwrapper);
    }

    @Override
    public BeanDeserializerBase withObjectIdReader(ObjectIdReader oir) {
        return new BeanAsArrayBuilderDeserializer(this._delegate.withObjectIdReader(oir), this._orderedProperties, this._buildMethod);
    }

    @Override
    public BeanDeserializerBase withIgnorableProperties(Set<String> ignorableProps) {
        return new BeanAsArrayBuilderDeserializer(this._delegate.withIgnorableProperties(ignorableProps), this._orderedProperties, this._buildMethod);
    }

    @Override
    public BeanDeserializerBase withBeanProperties(BeanPropertyMap props2) {
        return new BeanAsArrayBuilderDeserializer(this._delegate.withBeanProperties(props2), this._orderedProperties, this._buildMethod);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        return this;
    }

    protected final Object finishBuild(DeserializationContext ctxt, Object builder) throws IOException {
        try {
            return this._buildMethod.getMember().invoke(builder, new Object[0]);
        }
        catch (Exception e) {
            return this.wrapInstantiationProblem(e, ctxt);
        }
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (!p.isExpectedStartArrayToken()) {
            return this.finishBuild(ctxt, this._deserializeFromNonArray(p, ctxt));
        }
        if (!this._vanillaProcessing) {
            return this.finishBuild(ctxt, this._deserializeNonVanilla(p, ctxt));
        }
        Object builder = this._valueInstantiator.createUsingDefault(ctxt);
        SettableBeanProperty[] props2 = this._orderedProperties;
        int i = 0;
        int propCount = props2.length;
        while (true) {
            if (p.nextToken() == JsonToken.END_ARRAY) {
                return this.finishBuild(ctxt, builder);
            }
            if (i == propCount) break;
            SettableBeanProperty prop = props2[i];
            if (prop != null) {
                try {
                    builder = prop.deserializeSetAndReturn(p, ctxt, builder);
                }
                catch (Exception e) {
                    this.wrapAndThrow((Throwable)e, builder, prop.getName(), ctxt);
                }
            } else {
                p.skipChildren();
            }
            ++i;
        }
        if (!this._ignoreAllUnknown) {
            ctxt.reportMappingException("Unexpected JSON values; expected at most %d properties (in JSON Array)", propCount);
        }
        while (p.nextToken() != JsonToken.END_ARRAY) {
            p.skipChildren();
        }
        return this.finishBuild(ctxt, builder);
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt, Object builder) throws IOException {
        if (this._injectables != null) {
            this.injectValues(ctxt, builder);
        }
        SettableBeanProperty[] props2 = this._orderedProperties;
        int i = 0;
        int propCount = props2.length;
        while (true) {
            if (p.nextToken() == JsonToken.END_ARRAY) {
                return this.finishBuild(ctxt, builder);
            }
            if (i == propCount) break;
            SettableBeanProperty prop = props2[i];
            if (prop != null) {
                try {
                    builder = prop.deserializeSetAndReturn(p, ctxt, builder);
                }
                catch (Exception e) {
                    this.wrapAndThrow((Throwable)e, builder, prop.getName(), ctxt);
                }
            } else {
                p.skipChildren();
            }
            ++i;
        }
        if (!this._ignoreAllUnknown) {
            ctxt.reportWrongTokenException(p, JsonToken.END_ARRAY, "Unexpected JSON values; expected at most %d properties (in JSON Array)", propCount);
        }
        do {
            p.skipChildren();
        } while (p.nextToken() != JsonToken.END_ARRAY);
        return this.finishBuild(ctxt, builder);
    }

    @Override
    public Object deserializeFromObject(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this._deserializeFromNonArray(p, ctxt);
    }

    protected Object _deserializeNonVanilla(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this._nonStandardCreation) {
            return this.deserializeFromObjectUsingNonDefault(p, ctxt);
        }
        Object builder = this._valueInstantiator.createUsingDefault(ctxt);
        if (this._injectables != null) {
            this.injectValues(ctxt, builder);
        }
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        SettableBeanProperty[] props2 = this._orderedProperties;
        int i = 0;
        int propCount = props2.length;
        while (true) {
            if (p.nextToken() == JsonToken.END_ARRAY) {
                return builder;
            }
            if (i == propCount) break;
            SettableBeanProperty prop = props2[i];
            ++i;
            if (prop != null && (activeView == null || prop.visibleInView(activeView))) {
                try {
                    prop.deserializeSetAndReturn(p, ctxt, builder);
                }
                catch (Exception e) {
                    this.wrapAndThrow((Throwable)e, builder, prop.getName(), ctxt);
                }
                continue;
            }
            p.skipChildren();
        }
        if (!this._ignoreAllUnknown) {
            ctxt.reportWrongTokenException(p, JsonToken.END_ARRAY, "Unexpected JSON value(s); expected at most %d properties (in JSON Array)", propCount);
        }
        while (p.nextToken() != JsonToken.END_ARRAY) {
            p.skipChildren();
        }
        return builder;
    }

    @Override
    protected final Object _deserializeUsingPropertyBased(JsonParser p, DeserializationContext ctxt) throws IOException {
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p, ctxt, this._objectIdReader);
        SettableBeanProperty[] props2 = this._orderedProperties;
        int propCount = props2.length;
        int i = 0;
        Object builder = null;
        while (p.nextToken() != JsonToken.END_ARRAY) {
            block17: {
                SettableBeanProperty prop;
                SettableBeanProperty settableBeanProperty = prop = i < propCount ? props2[i] : null;
                if (prop == null) {
                    p.skipChildren();
                } else if (builder != null) {
                    try {
                        builder = prop.deserializeSetAndReturn(p, ctxt, builder);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow((Throwable)e, builder, prop.getName(), ctxt);
                    }
                } else {
                    String propName = prop.getName();
                    SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
                    if (creatorProp != null) {
                        if (buffer.assignParameter(creatorProp, creatorProp.deserialize(p, ctxt))) {
                            try {
                                builder = creator.build(ctxt, buffer);
                            }
                            catch (Exception e) {
                                this.wrapAndThrow((Throwable)e, this._beanType.getRawClass(), propName, ctxt);
                                break block17;
                            }
                            if (builder.getClass() != this._beanType.getRawClass()) {
                                ctxt.reportMappingException("Can not support implicit polymorphic deserialization for POJOs-as-Arrays style: nominal type %s, actual type %s", this._beanType.getRawClass().getName(), builder.getClass().getName());
                                return null;
                            }
                        }
                    } else if (!buffer.readIdProperty(propName)) {
                        buffer.bufferProperty(prop, prop.deserialize(p, ctxt));
                    }
                }
            }
            ++i;
        }
        if (builder == null) {
            try {
                builder = creator.build(ctxt, buffer);
            }
            catch (Exception e) {
                return this.wrapInstantiationProblem(e, ctxt);
            }
        }
        return builder;
    }

    protected Object _deserializeFromNonArray(JsonParser p, DeserializationContext ctxt) throws IOException {
        return ctxt.handleUnexpectedToken(this.handledType(), p.getCurrentToken(), p, "Can not deserialize a POJO (of type %s) from non-Array representation (token: %s): type/property designed to be serialized as JSON Array", new Object[]{this._beanType.getRawClass().getName(), p.getCurrentToken()});
    }
}

