/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.dbengine;

import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.rdbms.dbengine.DataSourceQueryEngine;
import com.arcadeanalytics.provider.rdbms.dbengine.QueryBuilder;
import com.arcadeanalytics.provider.rdbms.factory.QueryBuilderFactory;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Attribute;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Entity;
import com.arcadeanalytics.provider.rdbms.model.dbschema.HierarchicalBag;
import com.arcadeanalytics.provider.rdbms.model.dbschema.PrimaryKey;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Relationship;
import com.arcadeanalytics.provider.rdbms.persistence.util.DBSourceConnection;
import com.arcadeanalytics.provider.rdbms.persistence.util.QueryResult;
import com.arcadeanalytics.provider.rdbms.persistence.util.RelationshipQueryResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBQueryEngine
implements DataSourceQueryEngine {
    private static final Logger log = LoggerFactory.getLogger(DBQueryEngine.class);
    private final QueryBuilder queryBuilder;
    private final DataSourceInfo dataSource;
    private final int maxElements;
    private final Connection dbConnection;

    public DBQueryEngine(DataSourceInfo dataSource, int maxElements) {
        this.dataSource = dataSource;
        this.maxElements = maxElements;
        QueryBuilderFactory queryBuilderFactory = new QueryBuilderFactory();
        this.queryBuilder = queryBuilderFactory.buildQueryBuilder(dataSource.getType());
        this.dbConnection = DBSourceConnection.getConnection(dataSource);
    }

    public Connection getDbConnection() {
        return this.dbConnection;
    }

    public QueryResult countTableRecords(String currentTableName, String currentTableSchema) throws SQLException {
        String query = this.queryBuilder.countTableRecords(currentTableName, currentTableSchema);
        return this.executeQuery(query, this.dataSource);
    }

    public QueryResult countTableRecords(String tableName) throws SQLException {
        String query = "select count(*) from " + tableName;
        return this.executeQuery(query, this.dataSource);
    }

    public QueryResult getRecordById(Entity entity, String[] propertyOfKey, String[] valueOfKey) throws SQLException {
        String query = this.queryBuilder.getRecordById(entity, propertyOfKey, valueOfKey);
        return this.executeQuery(query, entity.getDataSource());
    }

    public QueryResult getRecordsByEntity(Entity entity) throws SQLException {
        String query = this.queryBuilder.getRecordsByEntity(entity);
        return this.executeQuery(query, entity.getDataSource());
    }

    public QueryResult getRecordsFromMultipleEntities(List<Entity> mappedEntities, String[][] columns) throws SQLException {
        DataSourceInfo sourceDBInfo = mappedEntities.get(0).getDataSource();
        String query = this.queryBuilder.getRecordsFromMultipleEntities(mappedEntities, columns);
        return this.executeQuery(query, sourceDBInfo);
    }

    public QueryResult getRecordsFromSingleTableByDiscriminatorValue(String discriminatorColumn, String currentDiscriminatorValue, Entity entity) throws SQLException {
        String query = this.queryBuilder.getRecordsFromSingleTableByDiscriminatorValue(discriminatorColumn, currentDiscriminatorValue, entity);
        return this.executeQuery(query, entity.getDataSource());
    }

    public QueryResult getEntityTypeFromSingleTable(String discriminatorColumn, Entity entity, String[] propertyOfKey, String[] valueOfKey) throws SQLException {
        String query = this.queryBuilder.getEntityTypeFromSingleTable(discriminatorColumn, entity, propertyOfKey, valueOfKey);
        return this.executeQuery(query, entity.getDataSource());
    }

    public QueryResult buildAggregateTableFromHierarchicalBag(HierarchicalBag bag) throws SQLException {
        String query = this.queryBuilder.buildAggregateTableFromHierarchicalBag(bag);
        return this.executeQuery(query, bag.getSourceDataseInfo());
    }

    public QueryResult executeQuery(String query, DataSourceInfo dataSource) throws SQLException {
        log.debug("query:: {}", (Object)query);
        Statement statement = this.dbConnection.createStatement(1003, 1007);
        ResultSet result = statement.executeQuery(query);
        return new QueryResult(this.dbConnection, statement, result, query);
    }

    public QueryResult scanTableAndOrder(String query, int limit, Entity entity, DataSourceInfo dataSource) throws SQLException {
        Statement statement = this.dbConnection.createStatement(1003, 1007);
        statement.setMaxRows(limit);
        String limitStatement = null;
        String sqlQuery = query;
        if (sqlQuery.contains("LIMIT")) {
            int index = sqlQuery.lastIndexOf(" LIMIT");
            limitStatement = sqlQuery.substring(index);
            sqlQuery = sqlQuery.substring(0, index);
        }
        if (entity.getPrimaryKey() != null && !sqlQuery.contains("ORDER BY")) {
            log.info("adds order by");
            sqlQuery = sqlQuery + "\nORDER BY ";
            for (Attribute currentAttribute : entity.getPrimaryKey().getInvolvedAttributes()) {
                sqlQuery = sqlQuery + entity.getName() + "." + currentAttribute.getName() + ", ";
            }
            sqlQuery = StringUtils.removeEnd(sqlQuery, ", ");
        }
        if (limitStatement != null) {
            sqlQuery = sqlQuery + limitStatement;
        }
        log.debug("sqlQuery :: {} ", (Object)sqlQuery);
        ResultSet result = statement.executeQuery(sqlQuery);
        QueryResult queryResult = new QueryResult(this.dbConnection, statement, result, sqlQuery);
        return queryResult;
    }

    public RelationshipQueryResult performConnectionCountQueryGroupedByElement(Relationship relationship, String pivotTableName, List<Attribute> filteringColumns, List<String> filteringIds, DataSourceInfo dataSource, String relationshipName) throws SQLException {
        Statement statement = this.dbConnection.createStatement(1003, 1007);
        statement.setMaxRows(1000);
        String query = "select ";
        Entity foreignTable = relationship.getForeignEntity();
        Entity parentTable = relationship.getParentEntity();
        String primaryKeyFields = "";
        if (pivotTableName.equals("foreignTable")) {
            primaryKeyFields = this.buildPrimaryKeyColumnsStatement(foreignTable);
            query = query + primaryKeyFields + ", ";
        } else if (pivotTableName.equals("parentTable")) {
            primaryKeyFields = this.buildPrimaryKeyColumnsStatement(parentTable);
            query = query + primaryKeyFields + ", ";
        }
        query = query + "count(*) as connectionsCount from \n" + parentTable.getName() + " join " + foreignTable.getName() + " on ";
        query = query + this.buildJoinConditionStatement(relationship.getFromColumns(), relationship.getToColumns(), foreignTable.getName(), parentTable.getName()) + "\n";
        if (filteringColumns != null && filteringIds != null) {
            if (pivotTableName.equals("foreignTable")) {
                query = query + " and \n" + this.buildIdsINStatement(foreignTable.getName(), filteringColumns, filteringIds) + " ";
            } else if (pivotTableName.equals("parentTable")) {
                query = query + " and \n" + this.buildIdsINStatement(parentTable.getName(), filteringColumns, filteringIds) + " ";
            }
        }
        query = query + "group by " + primaryKeyFields + "\n";
        query = query + "order by " + primaryKeyFields;
        log.debug("query :: {} ", (Object)query);
        ResultSet result = statement.executeQuery(query);
        return new RelationshipQueryResult(this.dbConnection, statement, result, query, relationshipName);
    }

    public RelationshipQueryResult computeRelationshipCardinality(Relationship relationship, DataSourceInfo dataSource, String relationshipName) throws SQLException {
        Statement statement = this.dbConnection.createStatement(1003, 1007);
        statement.setMaxRows(1000);
        String query = "select ";
        Entity foreignTable = relationship.getForeignEntity();
        Entity parentTable = relationship.getParentEntity();
        query = query + "count(*) as connectionsCount from \n" + parentTable.getName() + " join " + foreignTable.getName() + " on ";
        query = query + this.buildJoinConditionStatement(relationship.getFromColumns(), relationship.getToColumns(), foreignTable.getName(), parentTable.getName()) + "\n";
        log.debug("query :: {} ", (Object)query);
        ResultSet result = statement.executeQuery(query);
        return new RelationshipQueryResult(this.dbConnection, statement, result, query, relationshipName);
    }

    public QueryResult expandRelationship(Entity enteringEntity, Entity rootEntity, List<Attribute> fromColumns, List<Attribute> toColumns, List<String> rootNodeIds, String direction, DataSourceInfo dataSource) throws SQLException {
        Statement statement = this.dbConnection.createStatement(1004, 1007);
        String enteringEntityName = enteringEntity.getName();
        String rootEntityName = rootEntity.getName();
        String query = "select ";
        query = query + this.buildPrimaryKeyColumnsStatement(rootEntity) + ", ";
        for (Attribute currColumn : enteringEntity.getAttributes()) {
            query = query + enteringEntityName + "." + currColumn.getName() + ", ";
        }
        query = query.substring(0, query.lastIndexOf(", "));
        query = query + " from \n " + enteringEntityName + " join " + rootEntityName + " on ";
        if (direction.equals("in")) {
            query = query + this.buildJoinConditionStatement(fromColumns, toColumns, enteringEntityName, rootEntityName) + "\n ";
        } else if (direction.equals("out")) {
            query = query + this.buildJoinConditionStatement(fromColumns, toColumns, rootEntityName, enteringEntityName) + "\n ";
        }
        LinkedHashMap<Entity, List<String>> tableName2ids = new LinkedHashMap<Entity, List<String>>();
        tableName2ids.put(rootEntity, rootNodeIds);
        query = query + "where " + this.buildPrimaryKeyIdsINStatement(rootEntity, tableName2ids) + "\n";
        query = query + "order by " + this.buildPrimaryKeyColumnsStatement(rootEntity);
        log.debug("query :: {} ", (Object)query);
        ResultSet result = statement.executeQuery(query);
        QueryResult queryResult = new QueryResult(this.dbConnection, statement, result, query);
        return queryResult;
    }

    public List<String> buildLoadQueries(Map<Entity, List<String>> tableName2ids) {
        ArrayList<String> queryDtos = new ArrayList<String>();
        for (Entity currentTable : tableName2ids.keySet()) {
            String currentTableName = currentTable.getName();
            String query = "select * from " + currentTableName + " where ";
            query = query + this.buildPrimaryKeyIdsINStatement(currentTable, tableName2ids);
            query = query + "\n order by ";
            query = query + this.buildPrimaryKeyColumnsStatement(currentTable);
            queryDtos.add(query);
        }
        return queryDtos;
    }

    private String buildJoinConditionStatement(List<Attribute> fromColumns, List<Attribute> toColumns, String foreignTableName, String parentTableName) {
        int numberOfJoinColumns = fromColumns.size();
        String joinCondition = parentTableName + "." + toColumns.get(0).getName() + "=" + foreignTableName + "." + fromColumns.get(0).getName();
        if (numberOfJoinColumns > 1) {
            for (int i = 1; i < fromColumns.size(); ++i) {
                joinCondition = joinCondition + ", " + parentTableName + "." + toColumns.get(i).getName() + "=" + foreignTableName + "." + fromColumns.get(0);
            }
        }
        return joinCondition;
    }

    private String buildPrimaryKeyColumnsStatement(Entity table) {
        String statement = "";
        String tableName = table.getName();
        for (Attribute a : table.getPrimaryKey().getInvolvedAttributes()) {
            statement = statement + tableName + "." + a.getName() + ", ";
        }
        statement = statement.substring(0, statement.lastIndexOf(", "));
        return statement;
    }

    private String buildPrimaryKeyIdsINStatement(Entity table, Map<Entity, List<String>> tableName2ids) {
        String statement = "";
        String tableName = table.getName();
        PrimaryKey primaryKey = table.getPrimaryKey();
        for (Attribute a : primaryKey.getInvolvedAttributes()) {
            statement = statement + tableName + "." + a.getName() + " in (";
            for (String currentId : tableName2ids.get(table)) {
                String[] currentIdSplit = currentId.split("_");
                statement = statement + "'" + currentIdSplit[a.getOrdinalPosition() - 1] + "', ";
            }
            statement = statement.substring(0, statement.lastIndexOf(", "));
            statement = statement + ") and ";
        }
        statement = statement.substring(0, statement.lastIndexOf(" and "));
        return statement;
    }

    private String buildIdsINStatement(String tableName, List<Attribute> columns, List<String> ids) {
        String statement = "";
        for (Attribute currColumn : columns) {
            statement = statement + tableName + "." + currColumn.getName() + " in (";
            for (String currentId : ids) {
                statement = statement + "'" + currentId + "', ";
            }
            statement = statement.substring(0, statement.lastIndexOf(", "));
            statement = statement + ") and ";
        }
        statement = statement.substring(0, statement.lastIndexOf(" and "));
        return statement;
    }

    public void close() {
        try {
            log.debug("    closing connection");
            this.dbConnection.close();
        }
        catch (SQLException e) {
            log.error("", (Throwable)e);
        }
    }
}

