/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.model.dbschema;

import com.arcadeanalytics.provider.rdbms.model.dbschema.Attribute;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Entity;
import com.arcadeanalytics.provider.rdbms.model.dbschema.ForeignKey;
import com.arcadeanalytics.provider.rdbms.model.dbschema.PrimaryKey;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Relationship;
import java.util.List;

public class CanonicalRelationship
extends Relationship {
    private ForeignKey foreignKey;
    private PrimaryKey primaryKey;

    public CanonicalRelationship(Entity foreignEntity, Entity parentEntity) {
        this.foreignEntity = foreignEntity;
        this.parentEntity = parentEntity;
        this.direction = "direct";
    }

    public CanonicalRelationship(Entity foreignEntity, Entity parentEntity, ForeignKey foreignKey, PrimaryKey primaryKey) {
        this.foreignEntity = foreignEntity;
        this.parentEntity = parentEntity;
        this.foreignKey = foreignKey;
        this.primaryKey = primaryKey;
        this.direction = "direct";
    }

    @Override
    public List<Attribute> getFromColumns() {
        return this.foreignKey.getInvolvedAttributes();
    }

    @Override
    public List<Attribute> getToColumns() {
        return this.primaryKey.getInvolvedAttributes();
    }

    public ForeignKey getForeignKey() {
        return this.foreignKey;
    }

    public void setForeignKey(ForeignKey foreignKey) {
        this.foreignKey = foreignKey;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean equals(Object obj) {
        CanonicalRelationship that = (CanonicalRelationship)obj;
        return this.foreignEntity.equals(that.getForeignEntity()) && this.parentEntity.equals(that.getParentEntity()) && this.foreignKey.equals(that.getForeignKey()) && this.primaryKey.equals(that.getPrimaryKey());
    }

    public String toString() {
        return "CanonicalRelationship [foreignEntity=" + this.foreignEntity.getName() + ", parentEntity=" + this.parentEntity.getName() + ", Foreign key=" + this.foreignKey.toString() + ", Primary key=" + this.primaryKey.toString() + "]";
    }
}

