/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.model.dbschema;

import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Attribute;
import com.arcadeanalytics.provider.rdbms.model.dbschema.CanonicalRelationship;
import com.arcadeanalytics.provider.rdbms.model.dbschema.ForeignKey;
import com.arcadeanalytics.provider.rdbms.model.dbschema.HierarchicalBag;
import com.arcadeanalytics.provider.rdbms.model.dbschema.LogicalRelationship;
import com.arcadeanalytics.provider.rdbms.model.dbschema.PrimaryKey;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Entity
implements Comparable<Entity> {
    private final String name;
    private final DataSourceInfo dataSource;
    private final String schemaName;
    private final Set<Attribute> attributes;
    private final List<ForeignKey> foreignKeys;
    private final Set<CanonicalRelationship> outCanonicalRelationships;
    private final Set<CanonicalRelationship> inCanonicalRelationships;
    private final Set<LogicalRelationship> outLogicalRelationships;
    private final Set<LogicalRelationship> inLogicalRelationships;
    private Boolean isSplitEntity;
    private Set<CanonicalRelationship> inheritedInCanonicalRelationships;
    private boolean inheritedInCanonicalRelationshipsRecovered;
    private Set<CanonicalRelationship> inheritedOutCanonicalRelationships;
    private boolean inheritedOutCanonicalRelationshipsRecovered;
    private Boolean isAggregable;
    private Set<Attribute> inheritedAttributes;
    private boolean inheritedAttributesRecovered;
    private int schemaPosition;
    private PrimaryKey primaryKey;
    private String directionOfN2NRepresentedRelationship;
    private String nameOfN2NRepresentedRelationship;
    private Entity parentEntity;
    private int inheritanceLevel;
    private HierarchicalBag hierarchicalBag;

    public Entity(String name, String schemaName, DataSourceInfo dataSource) {
        this.name = name;
        this.dataSource = dataSource;
        this.schemaName = schemaName;
        this.attributes = new LinkedHashSet<Attribute>();
        this.inheritedAttributes = new LinkedHashSet<Attribute>();
        this.inheritedAttributesRecovered = false;
        this.foreignKeys = new LinkedList<ForeignKey>();
        this.outCanonicalRelationships = new LinkedHashSet<CanonicalRelationship>();
        this.inheritedOutCanonicalRelationships = new LinkedHashSet<CanonicalRelationship>();
        this.inheritedOutCanonicalRelationshipsRecovered = false;
        this.inCanonicalRelationships = new LinkedHashSet<CanonicalRelationship>();
        this.inheritedInCanonicalRelationships = new LinkedHashSet<CanonicalRelationship>();
        this.inheritedInCanonicalRelationshipsRecovered = false;
        this.outLogicalRelationships = new LinkedHashSet<LogicalRelationship>();
        this.inLogicalRelationships = new LinkedHashSet<LogicalRelationship>();
        this.isAggregable = null;
        this.isSplitEntity = false;
        this.inheritanceLevel = 0;
    }

    public boolean isAggregableJoinTable() {
        if (this.isAggregable != null) {
            return this.isAggregable;
        }
        if (this.foreignKeys.size() != 2) {
            return false;
        }
        boolean aggregable = this.isJunctionTable();
        this.isAggregable = aggregable;
        if (this.isAggregable.booleanValue() && this.directionOfN2NRepresentedRelationship == null) {
            this.directionOfN2NRepresentedRelationship = "direct";
        }
        return this.isAggregable;
    }

    private boolean isJunctionTable() {
        boolean isJunctionTable = true;
        block0: for (ForeignKey currentFk : this.foreignKeys) {
            for (Attribute attribute : currentFk.getInvolvedAttributes()) {
                if (this.primaryKey.getInvolvedAttributes().contains(attribute)) continue;
                isJunctionTable = false;
                continue block0;
            }
        }
        if (isJunctionTable && this.getAllInCanonicalRelationships().size() > 0) {
            isJunctionTable = false;
        }
        return isJunctionTable;
    }

    public Boolean isSplitEntity() {
        return this.isSplitEntity;
    }

    public void setIsSplitEntity(Boolean splitEntity) {
        this.isSplitEntity = splitEntity;
    }

    public void setIsAggregableJoinTable(boolean isAggregable) {
        this.isAggregable = isAggregable;
    }

    public String getDirectionOfN2NRepresentedRelationship() {
        return this.directionOfN2NRepresentedRelationship;
    }

    public void setDirectionOfN2NRepresentedRelationship(String directionOfN2NRepresentedRelationship) {
        this.directionOfN2NRepresentedRelationship = directionOfN2NRepresentedRelationship;
    }

    public String getNameOfN2NRepresentedRelationship() {
        return this.nameOfN2NRepresentedRelationship;
    }

    public void setNameOfN2NRepresentedRelationship(String nameOfN2NRepresentedRelationship) {
        this.nameOfN2NRepresentedRelationship = nameOfN2NRepresentedRelationship;
    }

    public String getName() {
        return this.name;
    }

    public DataSourceInfo getDataSource() {
        return this.dataSource;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public int getSchemaPosition() {
        return this.schemaPosition;
    }

    public void setSchemaPosition(int schemaPosition) {
        this.schemaPosition = schemaPosition;
    }

    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    public Set<Attribute> getInheritedAttributes() {
        if (this.inheritedAttributesRecovered) {
            return this.inheritedAttributes;
        }
        if (this.parentEntity != null) {
            this.inheritedAttributes = this.parentEntity.getAllAttributes();
            this.inheritedAttributesRecovered = true;
            return this.inheritedAttributes;
        }
        return this.inheritedAttributes;
    }

    public Set<Attribute> getAllAttributes() {
        LinkedHashSet<Attribute> allAttributes = new LinkedHashSet<Attribute>();
        allAttributes.addAll(this.getInheritedAttributes());
        allAttributes.addAll(this.attributes);
        return allAttributes;
    }

    public boolean isInheritedAttributesRecovered() {
        return this.inheritedAttributesRecovered;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public List<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public boolean addAttribute(Attribute attribute) {
        boolean added = this.attributes.add(attribute);
        LinkedList<Attribute> temp = new LinkedList<Attribute>(this.attributes);
        if (added) {
            Collections.sort(temp);
        }
        this.attributes.clear();
        this.attributes.addAll(temp);
        return added;
    }

    public void removeAttributeByNameIgnoreCase(String toRemove) {
        Iterator<Attribute> it = this.attributes.iterator();
        while (it.hasNext()) {
            Attribute currentAttribute = it.next();
            if (!currentAttribute.getName().equalsIgnoreCase(toRemove)) continue;
            it.remove();
            break;
        }
    }

    public Attribute getAttributeByName(String name) {
        Attribute toReturn = null;
        for (Attribute a : this.attributes) {
            if (!a.getName().equals(name)) continue;
            toReturn = a;
            break;
        }
        return toReturn;
    }

    public Attribute getAttributeByNameIgnoreCase(String name) {
        Attribute toReturn = null;
        for (Attribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(name)) continue;
            toReturn = a;
            break;
        }
        return toReturn;
    }

    public Attribute getAttributeByOrdinalPosition(int position) {
        Attribute toReturn = null;
        for (Attribute a : this.attributes) {
            if (a.getOrdinalPosition() != position) continue;
            toReturn = a;
            break;
        }
        return toReturn;
    }

    public Attribute getInheritedAttributeByName(String name) {
        Attribute toReturn = null;
        for (Attribute a : this.getInheritedAttributes()) {
            if (!a.getName().equals(name)) continue;
            toReturn = a;
            break;
        }
        return toReturn;
    }

    public Attribute getInheritedAttributeByNameIgnoreCase(String name) {
        Attribute toReturn = null;
        for (Attribute a : this.getInheritedAttributes()) {
            if (!a.getName().equalsIgnoreCase(name)) continue;
            toReturn = a;
            break;
        }
        return toReturn;
    }

    public Set<CanonicalRelationship> getOutCanonicalRelationships() {
        return this.outCanonicalRelationships;
    }

    public Set<CanonicalRelationship> getInheritedOutCanonicalRelationships() {
        if (this.inheritedOutCanonicalRelationshipsRecovered) {
            return this.inheritedOutCanonicalRelationships;
        }
        if (this.parentEntity != null) {
            this.inheritedOutCanonicalRelationships = this.parentEntity.getAllOutCanonicalRelationships();
            this.inheritedOutCanonicalRelationshipsRecovered = true;
            return this.inheritedOutCanonicalRelationships;
        }
        return this.inheritedOutCanonicalRelationships;
    }

    public Set<CanonicalRelationship> getAllOutCanonicalRelationships() {
        LinkedHashSet<CanonicalRelationship> allRelationships = new LinkedHashSet<CanonicalRelationship>();
        allRelationships.addAll(this.getInheritedOutCanonicalRelationships());
        allRelationships.addAll(this.outCanonicalRelationships);
        return allRelationships;
    }

    public boolean isInheritedOutCanonicalRelationshipsRecovered() {
        return this.inheritedOutCanonicalRelationshipsRecovered;
    }

    public void setInheritedOutCanonicalRelationshipsRecovered(boolean inheritedOutCanonicalRelationshipsRecovered) {
        this.inheritedOutCanonicalRelationshipsRecovered = inheritedOutCanonicalRelationshipsRecovered;
    }

    public Set<CanonicalRelationship> getInCanonicalRelationships() {
        return this.inCanonicalRelationships;
    }

    public Set<CanonicalRelationship> getInheritedInCanonicalRelationships() {
        if (this.inheritedInCanonicalRelationshipsRecovered) {
            return this.inheritedInCanonicalRelationships;
        }
        if (this.parentEntity != null) {
            this.inheritedInCanonicalRelationships = this.parentEntity.getAllInCanonicalRelationships();
            this.inheritedInCanonicalRelationshipsRecovered = true;
            return this.inheritedInCanonicalRelationships;
        }
        return this.inheritedInCanonicalRelationships;
    }

    public void setInheritedInCanonicalRelationships(Set<CanonicalRelationship> inheritedInCanonicalRelationships) {
        this.inheritedInCanonicalRelationships = inheritedInCanonicalRelationships;
    }

    public Set<CanonicalRelationship> getAllInCanonicalRelationships() {
        LinkedHashSet<CanonicalRelationship> allRelationships = new LinkedHashSet<CanonicalRelationship>();
        allRelationships.addAll(this.getInheritedInCanonicalRelationships());
        allRelationships.addAll(this.inCanonicalRelationships);
        return allRelationships;
    }

    public boolean isInheritedInCanonicalRelationshipsRecovered() {
        return this.inheritedInCanonicalRelationshipsRecovered;
    }

    public Set<LogicalRelationship> getOutLogicalRelationships() {
        return this.outLogicalRelationships;
    }

    public Set<LogicalRelationship> getInLogicalRelationships() {
        return this.inLogicalRelationships;
    }

    public Entity getParentEntity() {
        return this.parentEntity;
    }

    public void setParentEntity(Entity parentEntity) {
        this.parentEntity = parentEntity;
    }

    public int getInheritanceLevel() {
        return this.inheritanceLevel;
    }

    public void setInheritanceLevel(int inheritanceLevel) {
        this.inheritanceLevel = inheritanceLevel;
    }

    public HierarchicalBag getHierarchicalBag() {
        return this.hierarchicalBag;
    }

    public void setHierarchicalBag(HierarchicalBag hierarchicalBag) {
        this.hierarchicalBag = hierarchicalBag;
    }

    public void renumberAttributesOrdinalPositions() {
        int i = 1;
        for (Attribute attribute : this.attributes) {
            attribute.setOrdinalPosition(i);
            ++i;
        }
    }

    @Override
    public int compareTo(Entity toCompare) {
        if (this.inheritanceLevel > toCompare.getInheritanceLevel()) {
            return 1;
        }
        if (this.inheritanceLevel < toCompare.getInheritanceLevel()) {
            return -1;
        }
        return this.name.compareTo(toCompare.getName());
    }

    public String toString() {
        String s = "Entity [name = " + this.name + ", number of attributes = " + this.attributes.size() + "]";
        if (this.isAggregableJoinTable()) {
            s = s + "\t\t\tJoin Entity (Aggregable Join Table)";
        }
        s = s + "\n|| ";
        for (Attribute a : this.attributes) {
            s = s + a.getOrdinalPosition() + ": " + a.getName() + " ( " + a.getDataType() + " ) || ";
        }
        s = s + "\nPrimary Key (" + this.primaryKey.getInvolvedAttributes().size() + " involved attributes): ";
        int cont = 1;
        int size = this.primaryKey.getInvolvedAttributes().size();
        for (Attribute a : this.primaryKey.getInvolvedAttributes()) {
            s = cont < size ? s + a.getName() + ", " : s + a.getName() + ".";
            ++cont;
        }
        if (this.outCanonicalRelationships.size() > 0) {
            s = s + "\nForeign Keys (" + this.outCanonicalRelationships.size() + "):\n";
            int index = 1;
            for (CanonicalRelationship relationship : this.outCanonicalRelationships) {
                s = s + index + ".  ";
                s = s + "Foreign Entity: " + relationship.getForeignEntity().getName() + ", Foreign Key: " + relationship.getForeignKey().toString() + "\t||\tParent Entity: " + relationship.getParentEntity().getName() + ", Primary Key: " + relationship.getForeignKey().toString() + "\n";
                ++index;
            }
        } else {
            s = s + "\nForeign Key: Not Present\n";
        }
        s = s + "\n\n";
        return s;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        Entity that = (Entity)obj;
        return this.name.equals(that.getName()) && this.getDataSource().equals((Object)that.getDataSource());
    }
}

