/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.model.graphmodel;

import com.arcadeanalytics.provider.rdbms.model.graphmodel.EdgeType;
import com.arcadeanalytics.provider.rdbms.model.graphmodel.VertexType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GraphModel {
    private List<VertexType> verticesType = new ArrayList<VertexType>();
    private List<EdgeType> edgesType = new ArrayList<EdgeType>();

    public VertexType getVertexTypeByName(String name) {
        VertexType vertex = null;
        for (VertexType currentVertex : this.verticesType) {
            if (!currentVertex.getName().equals(name)) continue;
            vertex = currentVertex;
            break;
        }
        return vertex;
    }

    public VertexType getVertexTypeByNameIgnoreCase(String name) {
        VertexType vertex = null;
        for (VertexType currentVertex : this.verticesType) {
            if (!currentVertex.getName().equalsIgnoreCase(name)) continue;
            vertex = currentVertex;
            break;
        }
        return vertex;
    }

    public List<VertexType> getVerticesType() {
        return this.verticesType;
    }

    public List<EdgeType> getEdgesType() {
        return this.edgesType;
    }

    public EdgeType getEdgeTypeByName(String name) {
        for (EdgeType currentEdgetype : this.edgesType) {
            if (!currentEdgetype.getName().equals(name)) continue;
            return currentEdgetype;
        }
        return null;
    }

    public EdgeType getEdgeTypeByNameIgnoreCase(String name) {
        for (EdgeType currentEdgetype : this.edgesType) {
            if (!currentEdgetype.getName().equalsIgnoreCase(name)) continue;
            return currentEdgetype;
        }
        return null;
    }

    public boolean removeVertexTypeByName(String vertexName) {
        Iterator<VertexType> iterator = this.verticesType.iterator();
        while (iterator.hasNext()) {
            VertexType currVertexType = iterator.next();
            if (!currVertexType.getName().equals(vertexName)) continue;
            for (EdgeType currInEdgeType : currVertexType.getInEdgesType()) {
                currInEdgeType.setInVertexType(null);
            }
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeEdgeTypeByName(String vertexName) {
        Iterator<EdgeType> iterator = this.edgesType.iterator();
        while (iterator.hasNext()) {
            EdgeType currEdgeType = iterator.next();
            if (!currEdgeType.getName().equals(vertexName)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public String toString() {
        String s = "\n\n\n------------------------------ MODEL GRAPH DESCRIPTION ------------------------------\n\n\n";
        s = s + "Number of Vertex-type: " + this.verticesType.size() + ".\nNumber of Edge-type: " + this.edgesType.size() + ".\n\n";
        s = s + "Vertex-type:\n\n";
        for (VertexType v : this.verticesType) {
            s = s + v.toString() + "\n\n";
        }
        s = s + "\n\n";
        s = s + "Edge-type:\n\n";
        for (EdgeType e : this.edgesType) {
            s = s + e.toString() + "\n";
        }
        s = s + "\n\n";
        s = s + "Graph structure:\n\n";
        for (VertexType v : this.verticesType) {
            for (EdgeType e : v.getOutEdgesType()) {
                s = s + v.getName() + " -----------[" + e.getName() + "]-----------> " + e.getInVertexType().getName() + "\n";
            }
        }
        return s;
    }
}

