/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.util;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class FunctionsHandler {
    public static String getHMSFormat(Date start, Date end) {
        String hmsTime = String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(end.getTime() - start.getTime()), TimeUnit.MILLISECONDS.toMinutes(end.getTime() - start.getTime()) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(end.getTime() - start.getTime())), TimeUnit.MILLISECONDS.toSeconds(end.getTime() - start.getTime()) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(end.getTime() - start.getTime())));
        return hmsTime;
    }

    public static String getHMSFormat(long millis) {
        String hmsTime = String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(millis), TimeUnit.MILLISECONDS.toMinutes(millis) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(millis)), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
        return hmsTime;
    }

    public static boolean haveDocumentsSameContent(ODocument d1, ODocument d2) {
        if (d1.toMap().keySet().size() != d2.toMap().keySet().size()) {
            return false;
        }
        for (String key1 : d1.toMap().keySet()) {
            if (!d2.toMap().keySet().contains(key1)) {
                return false;
            }
            Object obj1 = d1.toMap().get(key1);
            Object obj2 = d2.toMap().get(key1);
            if (obj1 instanceof String && obj2 instanceof String) {
                if (obj1.equals(obj2)) continue;
                return false;
            }
            if (obj1 instanceof ODocument && obj2 instanceof ODocument) {
                if (FunctionsHandler.haveDocumentsSameContent((ODocument)obj1, (ODocument)obj2)) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

