/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.nio.ByteBuffer;

public class OByteSerializer
implements OBinarySerializer<Byte> {
    public static final int BYTE_SIZE = 1;
    public static final byte ID = 2;
    public static final OByteSerializer INSTANCE = new OByteSerializer();

    @Override
    public int getObjectSize(Byte object, Object ... hints) {
        return 1;
    }

    @Override
    public void serialize(Byte object, byte[] stream, int startPosition, Object ... hints) {
        stream[startPosition] = object;
    }

    public void serializeLiteral(byte value, byte[] stream, int startPosition) {
        stream[startPosition] = value;
    }

    @Override
    public Byte deserialize(byte[] stream, int startPosition) {
        return stream[startPosition];
    }

    public byte deserializeLiteral(byte[] stream, int startPosition) {
        return stream[startPosition];
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 1;
    }

    @Override
    public byte getId() {
        return 2;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return this.getObjectSize(stream, startPosition);
    }

    @Override
    public void serializeNativeObject(Byte object, byte[] stream, int startPosition, Object ... hints) {
        this.serialize(object, stream, startPosition, new Object[0]);
    }

    public void serializeNative(byte object, byte[] stream, int startPosition, Object ... hints) {
        this.serializeLiteral(object, stream, startPosition);
    }

    public void serializeRawBytes(byte[] bytesToWrite, byte[] stream, int startPosition) {
        System.arraycopy(bytesToWrite, 0, stream, startPosition, bytesToWrite.length);
    }

    @Override
    public Byte deserializeNativeObject(byte[] stream, int startPosition) {
        return stream[startPosition];
    }

    public byte deserializeNative(byte[] stream, int startPosition) {
        return stream[startPosition];
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 1;
    }

    @Override
    public Byte preprocess(Byte value, Object ... hints) {
        return value;
    }

    @Override
    public void serializeInByteBufferObject(Byte object, ByteBuffer buffer, Object ... hints) {
        buffer.put(object);
    }

    @Override
    public Byte deserializeFromByteBufferObject(ByteBuffer buffer) {
        return buffer.get();
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return 1;
    }

    @Override
    public Byte deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return walChanges.getByteValue(buffer, offset);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return 1;
    }
}

