/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OCommit37Response;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OBatchOperationsResponse
implements OBinaryResponse {
    private int txId;
    private List<OCommit37Response.OCreatedRecordResponse> created;
    private List<OCommit37Response.OUpdatedRecordResponse> updated;
    private List<OCommit37Response.ODeletedRecordResponse> deleted;

    public OBatchOperationsResponse(int txId, List<OCommit37Response.OCreatedRecordResponse> created, List<OCommit37Response.OUpdatedRecordResponse> updated, List<OCommit37Response.ODeletedRecordResponse> deleted) {
        this.txId = txId;
        this.created = created;
        this.updated = updated;
        this.deleted = deleted;
    }

    public OBatchOperationsResponse() {
    }

    @Override
    public void write(OChannelDataOutput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        channel.writeInt(this.txId);
        channel.writeInt(this.created.size());
        for (OCommit37Response.OCreatedRecordResponse createdRecord : this.created) {
            channel.writeRID(createdRecord.getCurrentRid());
            channel.writeRID(createdRecord.getCreatedRid());
            channel.writeVersion(createdRecord.getVersion());
        }
        channel.writeInt(this.updated.size());
        for (OCommit37Response.OUpdatedRecordResponse updatedRecord : this.updated) {
            channel.writeRID(updatedRecord.getRid());
            channel.writeVersion(updatedRecord.getVersion());
        }
        channel.writeInt(this.deleted.size());
        for (OCommit37Response.ODeletedRecordResponse deleteRecord : this.deleted) {
            channel.writeRID(deleteRecord.getRid());
        }
    }

    @Override
    public void read(OChannelDataInput network, OStorageRemoteSession session) throws IOException {
        this.txId = network.readInt();
        int createdRecords = network.readInt();
        this.created = new ArrayList<OCommit37Response.OCreatedRecordResponse>(createdRecords);
        for (int i = 0; i < createdRecords; ++i) {
            ORecordId currentRid = network.readRID();
            ORecordId createdRid = network.readRID();
            int version = network.readVersion();
            this.created.add(new OCommit37Response.OCreatedRecordResponse(currentRid, createdRid, version));
        }
        int updatedRecords = network.readInt();
        this.updated = new ArrayList<OCommit37Response.OUpdatedRecordResponse>(updatedRecords);
        for (int i = 0; i < updatedRecords; ++i) {
            ORecordId rid = network.readRID();
            int version = network.readVersion();
            this.updated.add(new OCommit37Response.OUpdatedRecordResponse(rid, version));
        }
        int deletedRecords = network.readInt();
        this.deleted = new ArrayList<OCommit37Response.ODeletedRecordResponse>(deletedRecords);
        for (int i = 0; i < deletedRecords; ++i) {
            ORecordId rid = network.readRID();
            this.deleted.add(new OCommit37Response.ODeletedRecordResponse(rid));
        }
    }

    public int getTxId() {
        return this.txId;
    }

    public List<OCommit37Response.OCreatedRecordResponse> getCreated() {
        return this.created;
    }

    public List<OCommit37Response.OUpdatedRecordResponse> getUpdated() {
        return this.updated;
    }

    public List<OCommit37Response.ODeletedRecordResponse> getDeleted() {
        return this.deleted;
    }
}

