/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public class OCreateRecordResponse
implements OBinaryResponse {
    private ORecordId identity;
    private int version;
    private Map<UUID, OBonsaiCollectionPointer> changedIds;

    public OCreateRecordResponse() {
    }

    public OCreateRecordResponse(ORecordId identity, int version, Map<UUID, OBonsaiCollectionPointer> changedIds) {
        this.identity = identity;
        this.version = version;
        this.changedIds = changedIds;
    }

    @Override
    public void write(OChannelDataOutput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        channel.writeShort((short)this.identity.getClusterId());
        channel.writeLong(this.identity.getClusterPosition());
        channel.writeInt(this.version);
        if (protocolVersion >= 20) {
            OMessageHelper.writeCollectionChanges(channel, this.changedIds);
        }
    }

    @Override
    public void read(OChannelDataInput network, OStorageRemoteSession session) throws IOException {
        short clusterId = network.readShort();
        long posistion = network.readLong();
        this.identity = new ORecordId(clusterId, posistion);
        this.version = network.readVersion();
        this.changedIds = OMessageHelper.readCollectionChanges(network);
    }

    public ORecordId getIdentity() {
        return this.identity;
    }

    public int getVersion() {
        return this.version;
    }

    public Map<UUID, OBonsaiCollectionPointer> getChangedIds() {
        return this.changedIds;
    }
}

