/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.ONestedValueChangeListener;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class OTrackedMap<T>
extends LinkedHashMap<Object, T>
implements ORecordElement,
OTrackedMultiValue<Object, T>,
Serializable {
    protected final ORecord sourceRecord;
    private ORecordElement.STATUS status = ORecordElement.STATUS.NOT_LOADED;
    private List<OMultiValueChangeListener<Object, T>> changeListeners = null;
    protected Class<?> genericClass;
    private final boolean embeddedCollection;

    public OTrackedMap(ORecord iRecord, Map<Object, T> iOrigin, Class<?> cls) {
        this(iRecord);
        this.genericClass = cls;
        if (iOrigin != null && !iOrigin.isEmpty()) {
            this.putAll(iOrigin);
        }
    }

    public OTrackedMap(ORecord iSourceRecord) {
        this.sourceRecord = iSourceRecord;
        this.embeddedCollection = this.getClass().equals(OTrackedMap.class);
    }

    @Override
    public ORecordElement getOwner() {
        return this.sourceRecord;
    }

    @Override
    public T put(Object key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("null key not supported by embedded map");
        }
        boolean containsKey = this.containsKey(key);
        T oldValue = super.put(key, value);
        if (containsKey && oldValue == value) {
            return oldValue;
        }
        if (oldValue instanceof ODocument) {
            ODocumentInternal.removeOwner((ODocument)oldValue, this);
        }
        this.addOwnerToEmbeddedDoc(value);
        if (containsKey) {
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<Object, T>(OMultiValueChangeEvent.OChangeType.UPDATE, key, value, oldValue));
        } else {
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<Object, T>(OMultiValueChangeEvent.OChangeType.ADD, key, value));
        }
        this.addNested(value);
        return oldValue;
    }

    private void addNested(T element) {
        if (element instanceof OTrackedMultiValue) {
            ((OTrackedMultiValue)element).addChangeListener(new ONestedValueChangeListener((ODocument)this.sourceRecord, this, (OTrackedMultiValue)element));
        }
    }

    private void addOwnerToEmbeddedDoc(T e) {
        if (this.embeddedCollection && e instanceof ODocument && !((ODocument)e).getIdentity().isValid()) {
            ODocumentInternal.addOwner((ODocument)e, this);
        }
        if (e instanceof ODocument) {
            ORecordInternal.track(this.sourceRecord, (ODocument)e);
        }
    }

    @Override
    public T remove(Object iKey) {
        boolean containsKey = this.containsKey(iKey);
        Object oldValue = super.remove(iKey);
        if (oldValue instanceof ODocument) {
            ODocumentInternal.removeOwner((ODocument)oldValue, this);
        }
        if (containsKey) {
            this.fireCollectionChangedEvent((OMultiValueChangeEvent<Object, T>)new OMultiValueChangeEvent<Object, Object>(OMultiValueChangeEvent.OChangeType.REMOVE, iKey, null, oldValue));
            this.removeNested(oldValue);
        }
        return (T)oldValue;
    }

    @Override
    public void clear() {
        HashMap origValues = this.changeListeners == null ? null : new HashMap(this);
        if (origValues == null) {
            for (Object v : super.values()) {
                if (!(v instanceof ODocument)) continue;
                ODocumentInternal.removeOwner((ODocument)v, this);
            }
        }
        super.clear();
        if (origValues != null) {
            for (Map.Entry entry : origValues.entrySet()) {
                if (entry.getValue() instanceof ODocument) {
                    ODocumentInternal.removeOwner((ODocument)entry.getValue(), this);
                }
                this.fireCollectionChangedEvent(new OMultiValueChangeEvent(OMultiValueChangeEvent.OChangeType.REMOVE, entry.getKey(), null, entry.getValue()));
                this.removeNested(entry.getValue());
            }
        } else {
            this.setDirty();
        }
    }

    private void removeNested(Object element) {
        if (element instanceof OTrackedMultiValue) {
            // empty if block
        }
    }

    @Override
    public void putAll(Map<?, ? extends T> m) {
        for (Map.Entry<?, T> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public OTrackedMap<T> setDirty() {
        if (!(this.status == ORecordElement.STATUS.UNMARSHALLING || this.sourceRecord == null || this.sourceRecord.isDirty() && ORecordInternal.isContentChanged(this.sourceRecord))) {
            this.sourceRecord.setDirty();
        }
        return this;
    }

    @Override
    public void setDirtyNoChanged() {
        if (this.status != ORecordElement.STATUS.UNMARSHALLING && this.sourceRecord != null) {
            this.sourceRecord.setDirtyNoChanged();
        }
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        return this.status;
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        this.status = iStatus;
    }

    @Override
    public void addChangeListener(OMultiValueChangeListener<Object, T> changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new LinkedList<OMultiValueChangeListener<Object, T>>();
        }
        this.changeListeners.add(changeListener);
    }

    @Override
    public void removeRecordChangeListener(OMultiValueChangeListener<Object, T> changeListener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(changeListener);
        }
    }

    public Map<Object, T> returnOriginalState(List<OMultiValueChangeEvent<Object, T>> multiValueChangeEvents) {
        HashMap<Object, T> reverted = new HashMap<Object, T>(this);
        ListIterator<OMultiValueChangeEvent<Object, T>> listIterator = multiValueChangeEvents.listIterator(multiValueChangeEvents.size());
        block5: while (listIterator.hasPrevious()) {
            OMultiValueChangeEvent<Object, T> event = listIterator.previous();
            switch (event.getChangeType()) {
                case ADD: {
                    reverted.remove(event.getKey());
                    continue block5;
                }
                case REMOVE: {
                    reverted.put(event.getKey(), event.getOldValue());
                    continue block5;
                }
                case UPDATE: {
                    reverted.put(event.getKey(), event.getOldValue());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)event.getChangeType()));
        }
        return reverted;
    }

    @Override
    public void fireCollectionChangedEvent(OMultiValueChangeEvent<Object, T> event) {
        if (this.status == ORecordElement.STATUS.UNMARSHALLING) {
            return;
        }
        this.setDirty();
        if (this.changeListeners != null) {
            for (OMultiValueChangeListener<Object, T> changeListener : this.changeListeners) {
                if (changeListener == null) continue;
                changeListener.onAfterRecordChanged(event);
            }
        }
    }

    @Override
    public Class<?> getGenericClass() {
        return this.genericClass;
    }

    private Object writeReplace() {
        return new LinkedHashMap(this);
    }

    @Override
    public void replace(OMultiValueChangeEvent<Object, Object> event, Object newValue) {
        super.put(event.getKey(), newValue);
        this.addNested(newValue);
    }
}

