/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODocumentFieldWalker;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.tool.ODatabaseExportException;
import com.orientechnologies.orient.core.db.tool.ODatabaseImpExpAbstract;
import com.orientechnologies.orient.core.db.tool.ODatabaseImportException;
import com.orientechnologies.orient.core.db.tool.importer.OConverterData;
import com.orientechnologies.orient.core.db.tool.importer.OLinksRewriter;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.index.ORuntimeKeyIndexDefinition;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.OJSONReader;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerJSON;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class ODatabaseImport
extends ODatabaseImpExpAbstract {
    public static final String EXPORT_IMPORT_MAP_NAME = "___exportImportRIDMap";
    public static final int IMPORT_RECORD_DUMP_LAP_EVERY_MS = 5000;
    private Map<OPropertyImpl, String> linkedClasses = new HashMap<OPropertyImpl, String>();
    private Map<OClass, List<String>> superClasses = new HashMap<OClass, List<String>>();
    private final OJSONReader jsonReader;
    private ORecord record;
    private boolean schemaImported = false;
    private int exporterVersion = -1;
    private ORID schemaRecordId;
    private ORID indexMgrRecordId;
    private boolean deleteRIDMapping = true;
    protected OIndex<OIdentifiable> exportImportHashTable;
    private boolean preserveClusterIDs = true;
    private boolean migrateLinks = true;
    private boolean merge = false;
    private boolean rebuildIndexes = true;
    private Set<String> indexesToRebuild = new HashSet<String>();
    private Map<String, String> convertedClassNames = new HashMap<String, String>();

    public ODatabaseImport(ODatabaseDocumentInternal database, String iFileName, OCommandOutputListener iListener) throws IOException {
        super(database, iFileName, iListener);
        FilterInputStream inStream;
        if (iListener == null) {
            this.listener = new OCommandOutputListener(){

                @Override
                public void onMessage(String iText) {
                }
            };
        }
        BufferedInputStream bf = new BufferedInputStream(new FileInputStream(this.fileName));
        bf.mark(1024);
        try {
            inStream = new GZIPInputStream((InputStream)bf, 16384);
        }
        catch (Exception ignore) {
            bf.reset();
            inStream = bf;
        }
        this.jsonReader = new OJSONReader(new InputStreamReader(inStream));
        database.declareIntent(new OIntentMassiveInsert());
    }

    public ODatabaseImport(ODatabaseDocumentInternal database, InputStream iStream, OCommandOutputListener iListener) throws IOException {
        super(database, "streaming", iListener);
        this.jsonReader = new OJSONReader(new InputStreamReader(iStream));
        database.declareIntent(new OIntentMassiveInsert());
    }

    @Override
    public ODatabaseImport setOptions(String iOptions) {
        super.setOptions(iOptions);
        return this;
    }

    @Override
    public void run() {
        this.importDatabase();
    }

    public ODatabaseImport importDatabase() {
        boolean preValidation = this.database.isValidationEnabled();
        try {
            this.listener.onMessage("\nStarted import of database '" + this.database.getURL() + "' from " + this.fileName + "...");
            long time = System.currentTimeMillis();
            this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
            this.database.setValidationEnabled(false);
            this.database.setStatus(ODatabase.STATUS.IMPORTING);
            if (!this.merge) {
                this.removeDefaultNonSecurityClasses();
                this.database.getMetadata().getIndexManager().reload();
            }
            for (OIndex<?> index : this.database.getMetadata().getIndexManager().getIndexes()) {
                if (!index.isAutomatic()) continue;
                this.indexesToRebuild.add(index.getName());
            }
            boolean clustersImported = false;
            while (this.jsonReader.hasNext() && this.jsonReader.lastChar() != '}') {
                String tag = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
                if (tag.equals("info")) {
                    this.importInfo();
                    continue;
                }
                if (tag.equals("clusters")) {
                    this.importClusters();
                    clustersImported = true;
                    continue;
                }
                if (tag.equals("schema")) {
                    this.importSchema(clustersImported);
                    continue;
                }
                if (tag.equals("records")) {
                    this.importRecords();
                    continue;
                }
                if (tag.equals("indexes")) {
                    this.importIndexes();
                    continue;
                }
                if (tag.equals("manualIndexes")) {
                    this.importManualIndexes();
                    continue;
                }
                if (tag.equals("brokenRids")) {
                    this.processBrokenRids();
                    continue;
                }
                throw new ODatabaseImportException("Invalid format. Found unsupported tag '" + tag + "'");
            }
            if (this.rebuildIndexes) {
                this.rebuildIndexes();
            }
            this.database.getMetadata().reload();
            this.database.getStorage().synch();
            this.database.setStatus(ODatabase.STATUS.OPEN);
            if (this.isDeleteRIDMapping()) {
                this.removeExportImportRIDsMap();
            }
            this.listener.onMessage("\n\nDatabase import completed in " + (System.currentTimeMillis() - time) + " ms");
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            writer.append("Error on database import happened just before line " + this.jsonReader.getLineNumber() + ", column " + this.jsonReader.getColumnNumber() + "\n");
            PrintWriter printWriter = new PrintWriter(writer);
            e.printStackTrace(printWriter);
            printWriter.flush();
            this.listener.onMessage(writer.toString());
            try {
                writer.close();
            }
            catch (IOException e1) {
                throw new ODatabaseExportException("Error on importing database '" + this.database.getName() + "' from file: " + this.fileName, e1);
            }
            throw new ODatabaseExportException("Error on importing database '" + this.database.getName() + "' from file: " + this.fileName, e);
        }
        finally {
            this.database.setValidationEnabled(preValidation);
            this.close();
        }
        return this;
    }

    private void processBrokenRids() throws IOException, ParseException {
        HashSet<ORID> brokenRids = new HashSet<ORID>();
        this.processBrokenRids(brokenRids);
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
    }

    private void processBrokenRids(Set<ORID> brokenRids) throws IOException, ParseException {
        if (this.exporterVersion >= 12) {
            this.listener.onMessage("Reading of set of RIDs of records which were detected as broken during database export\n");
            this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
            do {
                this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                ORecordId recordId = new ORecordId(this.jsonReader.getValue());
                brokenRids.add(recordId);
            } while (this.jsonReader.lastChar() != ']');
        }
        if (this.migrateLinks) {
            if (this.exporterVersion >= 12) {
                this.listener.onMessage(brokenRids.size() + " were detected as broken during database export, links on those records will be removed from" + " result database");
            }
            this.migrateLinksInImportedDocuments(brokenRids);
        }
    }

    public void rebuildIndexes() {
        this.database.getMetadata().getIndexManager().reload();
        OIndexManager indexManager = this.database.getMetadata().getIndexManager();
        this.listener.onMessage("\nRebuild of stale indexes...");
        for (String indexName : this.indexesToRebuild) {
            if (indexManager.getIndex(indexName) == null) {
                this.listener.onMessage("\nIndex " + indexName + " is skipped because it is absent in imported DB.");
                continue;
            }
            this.listener.onMessage("\nStart rebuild index " + indexName);
            this.database.command("rebuild index " + indexName, new Object[0]).close();
            this.listener.onMessage("\nRebuild  of index " + indexName + " is completed.");
        }
        this.listener.onMessage("\nStale indexes were rebuilt...");
    }

    public ODatabaseImport removeExportImportRIDsMap() {
        this.listener.onMessage("\nDeleting RID Mapping table...");
        if (this.exportImportHashTable != null) {
            this.database.command("drop index ___exportImportRIDMap", new Object[0]).close();
            this.exportImportHashTable = null;
        }
        this.listener.onMessage("OK\n");
        return this;
    }

    public void close() {
        this.database.declareIntent(null);
    }

    public boolean isMigrateLinks() {
        return this.migrateLinks;
    }

    public void setMigrateLinks(boolean migrateLinks) {
        this.migrateLinks = migrateLinks;
    }

    public boolean isRebuildIndexes() {
        return this.rebuildIndexes;
    }

    public void setRebuildIndexes(boolean rebuildIndexes) {
        this.rebuildIndexes = rebuildIndexes;
    }

    public boolean isPreserveClusterIDs() {
        return this.preserveClusterIDs;
    }

    public void setPreserveClusterIDs(boolean preserveClusterIDs) {
        this.preserveClusterIDs = preserveClusterIDs;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public boolean isDeleteRIDMapping() {
        return this.deleteRIDMapping;
    }

    public void setDeleteRIDMapping(boolean deleteRIDMapping) {
        this.deleteRIDMapping = deleteRIDMapping;
    }

    @Override
    protected void parseSetting(String option, List<String> items) {
        if (option.equalsIgnoreCase("-deleteRIDMapping")) {
            this.deleteRIDMapping = Boolean.parseBoolean(items.get(0));
        } else if (option.equalsIgnoreCase("-preserveClusterIDs")) {
            this.preserveClusterIDs = Boolean.parseBoolean(items.get(0));
        } else if (option.equalsIgnoreCase("-merge")) {
            this.merge = Boolean.parseBoolean(items.get(0));
        } else if (option.equalsIgnoreCase("-migrateLinks")) {
            this.migrateLinks = Boolean.parseBoolean(items.get(0));
        } else if (option.equalsIgnoreCase("-rebuildIndexes")) {
            this.rebuildIndexes = Boolean.parseBoolean(items.get(0));
        } else {
            super.parseSetting(option, items);
        }
    }

    public void setOption(String option, String value) {
        this.parseSetting("-" + option, Arrays.asList(value));
    }

    protected void removeDefaultClusters() {
        this.listener.onMessage("\nWARN: Exported database does not support manual index separation. Manual index cluster will be dropped.");
        this.database.dropCluster("manindex", true);
        OSchema schema = this.database.getMetadata().getSchema();
        if (schema.existsClass("OUser")) {
            schema.dropClass("OUser");
        }
        if (schema.existsClass("ORole")) {
            schema.dropClass("ORole");
        }
        if (schema.existsClass("ORestricted")) {
            schema.dropClass("ORestricted");
        }
        if (schema.existsClass("OFunction")) {
            schema.dropClass("OFunction");
        }
        if (schema.existsClass("ORIDs")) {
            schema.dropClass("ORIDs");
        }
        if (schema.existsClass("OTriggered")) {
            schema.dropClass("OTriggered");
        }
        schema.save();
        this.database.dropCluster("default", true);
        this.database.getStorage().setDefaultClusterId(this.database.addCluster("default", new Object[0]));
        new ODocument().save("default");
        this.database.getMetadata().getSecurity().create();
    }

    private void importInfo() throws IOException, ParseException {
        this.listener.onMessage("\nImporting database info...");
        this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
        while (this.jsonReader.lastChar() != '}') {
            String fieldName = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
            if (fieldName.equals("exporter-version")) {
                this.exporterVersion = this.jsonReader.readInteger(OJSONReader.NEXT_IN_OBJECT);
                continue;
            }
            if (fieldName.equals("schemaRecordId")) {
                this.schemaRecordId = new ORecordId(this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT));
                continue;
            }
            if (fieldName.equals("indexMgrRecordId")) {
                this.indexMgrRecordId = new ORecordId(this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT));
                continue;
            }
            this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
        }
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        if (this.schemaRecordId == null) {
            this.schemaRecordId = new ORecordId(this.database.getStorage().getConfiguration().getSchemaRecordId());
        }
        if (this.indexMgrRecordId == null) {
            this.indexMgrRecordId = new ORecordId(this.database.getStorage().getConfiguration().getIndexMgrRecordId());
        }
        this.listener.onMessage("OK");
    }

    /*
     * WARNING - void declaration
     */
    private void removeDefaultNonSecurityClasses() {
        void var9_12;
        this.listener.onMessage("\nNon merge mode (-merge=false): removing all default non security classes");
        OSchema schema = this.database.getMetadata().getSchema();
        Collection<OClass> classes = schema.getClasses();
        OClass orole = schema.getClass("ORole");
        OClass ouser = schema.getClass("OUser");
        OClass oidentity = schema.getClass("OIdentity");
        HashMap<String, OClass> classesToDrop = new HashMap<String, OClass>();
        HashSet<String> indexes = new HashSet<String>();
        for (OClass oClass : classes) {
            String className = oClass.getName();
            if (oClass.isSuperClassOf(orole) || oClass.isSuperClassOf(ouser) || oClass.isSuperClassOf(oidentity)) continue;
            classesToDrop.put(className, oClass);
            for (OIndex oIndex : oClass.getIndexes()) {
                indexes.add(oIndex.getName());
            }
        }
        OIndexManager indexManager = this.database.getMetadata().getIndexManager();
        for (String indexName : indexes) {
            indexManager.dropIndex(indexName);
        }
        boolean bl = false;
        while (!classesToDrop.isEmpty()) {
            ArrayList<String> classesReadyToDrop = new ArrayList<String>();
            for (String string : classesToDrop.keySet()) {
                boolean isSuperClass = false;
                block5: for (OClass dbClass : classesToDrop.values()) {
                    List<OClass> parentClasses = dbClass.getSuperClasses();
                    if (parentClasses == null) continue;
                    for (OClass parentClass : parentClasses) {
                        if (!string.equalsIgnoreCase(parentClass.getName())) continue;
                        isSuperClass = true;
                        continue block5;
                    }
                }
                if (isSuperClass) continue;
                ((AbstractList)classesReadyToDrop).add(string);
            }
            for (String string : classesReadyToDrop) {
                schema.dropClass(string);
                classesToDrop.remove(string);
                ++var9_12;
                this.listener.onMessage("\n- Class " + string + " was removed.");
            }
        }
        schema.save();
        schema.reload();
        this.listener.onMessage("\nRemoved " + (int)var9_12 + " classes.");
    }

    private void importManualIndexes() throws IOException, ParseException {
        this.listener.onMessage("\nImporting manual index entries...");
        ODocument doc = new ODocument();
        OIndexManager indexManager = this.database.getMetadata().getIndexManager();
        indexManager.reload();
        int n = 0;
        do {
            this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
            this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
            String indexName = this.jsonReader.readString(OJSONReader.NEXT_IN_ARRAY);
            if (indexName == null || indexName.length() == 0) {
                return;
            }
            this.listener.onMessage("\n- Index '" + indexName + "'...");
            OIndex<?> index = this.database.getMetadata().getIndexManager().getIndex(indexName);
            long tot = 0L;
            this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
            do {
                OIdentifiable newRid;
                String value;
                if ((value = this.jsonReader.readString(OJSONReader.NEXT_IN_ARRAY).trim()).isEmpty() || indexName.equalsIgnoreCase(EXPORT_IMPORT_MAP_NAME)) continue;
                doc = (ODocument)ORecordSerializerJSON.INSTANCE.fromString(value, doc, null);
                doc.setLazyLoad(false);
                OIdentifiable oldRid = (OIdentifiable)doc.field("rid");
                if (!((Boolean)doc.field("binary")).booleanValue()) {
                    newRid = this.exportImportHashTable != null ? this.exportImportHashTable.get(oldRid) : oldRid;
                    index.put(doc.field("key"), newRid != null ? newRid.getIdentity() : oldRid.getIdentity());
                } else {
                    ORuntimeKeyIndexDefinition runtimeKeyIndexDefinition = (ORuntimeKeyIndexDefinition)index.getDefinition();
                    OBinarySerializer binarySerializer = runtimeKeyIndexDefinition.getSerializer();
                    newRid = this.exportImportHashTable != null ? this.exportImportHashTable.get(doc.field("rid")).getIdentity() : (OIdentifiable)doc.field("rid");
                    index.put(binarySerializer.deserialize((byte[])doc.field("key"), 0), newRid != null ? newRid : oldRid);
                }
                ++tot;
            } while (this.jsonReader.lastChar() == ',');
            if (index != null) {
                this.listener.onMessage("OK (" + tot + " entries)");
                ++n;
            } else {
                this.listener.onMessage("ERR, the index wasn't found in configuration");
            }
            this.jsonReader.readNext(OJSONReader.END_OBJECT);
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
        } while (this.jsonReader.lastChar() == ',');
        this.listener.onMessage("\nDone. Imported " + String.format("%,d", n) + " indexes.");
        this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
    }

    private void importSchema(boolean clustersImported) throws IOException, ParseException {
        if (!clustersImported) {
            this.removeDefaultClusters();
        }
        this.listener.onMessage("\nImporting database schema...");
        this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
        int schemaVersion = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"version\"").readNumber(OJSONReader.ANY_NUMBER, true);
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
        if (this.jsonReader.getValue().equals("\"globalProperties\"")) {
            this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
            do {
                this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
                this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"name\"");
                String name = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"global-id\"");
                String id = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"type\"");
                String type = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
            } while (this.jsonReader.lastChar() == ',');
            this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
            this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
        }
        if (this.jsonReader.getValue().equals("\"blob-clusters\"")) {
            String blobClusterIds = this.jsonReader.readString(OJSONReader.END_COLLECTION, true).trim();
            if (!"".equals(blobClusterIds = blobClusterIds.substring(1, blobClusterIds.length() - 1))) {
                for (String i : OStringSerializerHelper.split(blobClusterIds, ',', new char[0])) {
                    Integer n = Integer.parseInt(i);
                    if (this.database.getBlobClusterIds().contains(n)) continue;
                    String name = this.database.getClusterNameById(n);
                    this.database.addBlobCluster(name, new Object[0]);
                }
            }
            this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
            this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
        }
        this.jsonReader.checkContent("\"classes\"").readNext(OJSONReader.BEGIN_COLLECTION);
        long classImported = 0L;
        try {
            do {
                OClassImpl cls;
                int classDefClusterId;
                this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
                Iterator<Map.Entry<OPropertyImpl, String>> className = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"name\"").readString(OJSONReader.COMMA_SEPARATOR);
                String string = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
                if (string.equals("\"id\"")) {
                    String string3 = this.jsonReader.readString(OJSONReader.COMMA_SEPARATOR);
                    string3 = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
                }
                if (this.jsonReader.isContent("\"default-cluster-id\"")) {
                    String string4 = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                    classDefClusterId = Integer.parseInt(string4);
                } else {
                    classDefClusterId = this.database.getDefaultClusterId();
                }
                String classClusterIds = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"cluster-ids\"").readString(OJSONReader.END_COLLECTION, true).trim();
                this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
                if (((String)((Object)className)).contains(".")) {
                    String newClassName = ((String)((Object)className)).replace('.', '_');
                    this.convertedClassNames.put((String)((Object)className), newClassName);
                    this.listener.onMessage("\nWARNING: class '" + (String)((Object)className) + "' has been renamed in '" + newClassName + "'\n");
                    className = newClassName;
                }
                if ((cls = (OClassImpl)this.database.getMetadata().getSchema().getClass((String)((Object)className))) != null) {
                    if (cls.getDefaultClusterId() != classDefClusterId) {
                        cls.setDefaultClusterId(classDefClusterId);
                    }
                } else {
                    cls = clustersImported ? (OClassImpl)this.database.getMetadata().getSchema().createClass((String)((Object)className), new int[]{classDefClusterId}, new OClass[0]) : (((String)((Object)className)).equalsIgnoreCase("ORestricted") ? (OClassImpl)this.database.getMetadata().getSchema().createAbstractClass((String)((Object)className)) : (OClassImpl)this.database.getMetadata().getSchema().createClass((String)((Object)className)));
                }
                if (classClusterIds != null && clustersImported) {
                    classClusterIds = classClusterIds.substring(1, classClusterIds.length() - 1);
                    for (int i : OStringSerializerHelper.splitIntArray(classClusterIds)) {
                        if (i == -1) continue;
                        cls.addClusterId(i);
                    }
                }
                while (this.jsonReader.lastChar() == ',') {
                    this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
                    String value = this.jsonReader.getValue();
                    if (value.equals("\"strictMode\"")) {
                        cls.setStrictMode(this.jsonReader.readBoolean(OJSONReader.NEXT_IN_OBJECT));
                        continue;
                    }
                    if (value.equals("\"abstract\"")) {
                        cls.setAbstract(this.jsonReader.readBoolean(OJSONReader.NEXT_IN_OBJECT));
                        continue;
                    }
                    if (value.equals("\"oversize\"")) {
                        String oversize = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                        cls.setOverSize(Float.parseFloat(oversize));
                        continue;
                    }
                    if (value.equals("\"strictMode\"")) {
                        String strictMode = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                        cls.setStrictMode(Boolean.parseBoolean(strictMode));
                        continue;
                    }
                    if (value.equals("\"short-name\"")) {
                        String shortName = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                        if (cls.getName().equalsIgnoreCase(shortName)) continue;
                        cls.setShortName(shortName);
                        continue;
                    }
                    if (value.equals("\"super-class\"")) {
                        String classSuper = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                        ArrayList<String> superClassNames = new ArrayList<String>();
                        superClassNames.add(classSuper);
                        this.superClasses.put(cls, superClassNames);
                        continue;
                    }
                    if (value.equals("\"super-classes\"")) {
                        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
                        ArrayList<String> superClassNames = new ArrayList<String>();
                        while (this.jsonReader.lastChar() != ']') {
                            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                            String clsName = this.jsonReader.getValue();
                            superClassNames.add(OIOUtils.getStringContent(clsName));
                        }
                        this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
                        this.superClasses.put(cls, superClassNames);
                        continue;
                    }
                    if (value.equals("\"properties\"")) {
                        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
                        while (this.jsonReader.lastChar() != ']') {
                            this.importProperty(cls);
                            if (this.jsonReader.lastChar() != '}') continue;
                            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                        }
                        this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
                        continue;
                    }
                    if (value.equals("\"customFields\"")) {
                        Map<String, String> customFields = this.importCustomFields();
                        for (Map.Entry<String, String> entry : customFields.entrySet()) {
                            cls.setCustom(entry.getKey(), entry.getValue());
                        }
                        continue;
                    }
                    if (!value.equals("\"cluster-selection\"")) continue;
                    cls.setClusterSelection(this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT));
                }
                ++classImported;
                this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
            } while (this.jsonReader.lastChar() == ',');
            for (Map.Entry entry : this.superClasses.entrySet()) {
                for (String s : (List)entry.getValue()) {
                    OClass superClass = this.database.getMetadata().getSchema().getClass(s);
                    if (((OClass)entry.getKey()).getSuperClasses().contains(superClass)) continue;
                    ((OClass)entry.getKey()).addSuperClass(superClass);
                }
            }
            for (Map.Entry<OPropertyImpl, String> entry : this.linkedClasses.entrySet()) {
                entry.getKey().setLinkedClass(this.database.getMetadata().getSchema().getClass(entry.getValue()));
            }
            this.database.getMetadata().getSchema().save();
            if (this.exporterVersion < 11) {
                OClass role = this.database.getMetadata().getSchema().getClass("ORole");
                role.dropProperty("rules");
            }
            this.listener.onMessage("OK (" + classImported + " classes)");
            this.schemaImported = true;
            this.jsonReader.readNext(OJSONReader.END_OBJECT);
            this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        }
        catch (Exception e) {
            OLogManager.instance().error(this, "Error on importing schema", e, new Object[0]);
            this.listener.onMessage("ERROR (" + classImported + " entries): " + e);
        }
    }

    private void importProperty(OClass iClass) throws IOException, ParseException {
        this.jsonReader.readNext(OJSONReader.NEXT_OBJ_IN_ARRAY);
        if (this.jsonReader.lastChar() == ']') {
            return;
        }
        String propName = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"name\"").readString(OJSONReader.COMMA_SEPARATOR);
        String next = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
        if (next.equals("\"id\"")) {
            next = this.jsonReader.readString(OJSONReader.COMMA_SEPARATOR);
            next = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
        }
        next = this.jsonReader.checkContent("\"type\"").readString(OJSONReader.NEXT_IN_OBJECT);
        OType type = OType.valueOf(next);
        String value = null;
        String min = null;
        String max = null;
        String linkedClass = null;
        OType linkedType = null;
        boolean mandatory = false;
        boolean readonly = false;
        boolean notNull = false;
        String collate = null;
        String regexp = null;
        String defaultValue = null;
        Map<String, String> customFields = null;
        while (this.jsonReader.lastChar() == ',') {
            this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
            String attrib = this.jsonReader.getValue();
            if (!attrib.equals("\"customFields\"")) {
                value = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT, false, OJSONReader.DEFAULT_JUMP, null, false);
            }
            if (attrib.equals("\"min\"")) {
                min = value;
                continue;
            }
            if (attrib.equals("\"max\"")) {
                max = value;
                continue;
            }
            if (attrib.equals("\"linked-class\"")) {
                linkedClass = value;
                continue;
            }
            if (attrib.equals("\"mandatory\"")) {
                mandatory = Boolean.parseBoolean(value);
                continue;
            }
            if (attrib.equals("\"readonly\"")) {
                readonly = Boolean.parseBoolean(value);
                continue;
            }
            if (attrib.equals("\"not-null\"")) {
                notNull = Boolean.parseBoolean(value);
                continue;
            }
            if (attrib.equals("\"linked-type\"")) {
                linkedType = OType.valueOf(value);
                continue;
            }
            if (attrib.equals("\"collate\"")) {
                collate = value;
                continue;
            }
            if (attrib.equals("\"default-value\"")) {
                defaultValue = value;
                continue;
            }
            if (attrib.equals("\"customFields\"")) {
                customFields = this.importCustomFields();
                continue;
            }
            if (!attrib.equals("\"regexp\"")) continue;
            regexp = value;
        }
        OPropertyImpl prop = (OPropertyImpl)iClass.getProperty(propName);
        if (prop == null) {
            prop = (OPropertyImpl)iClass.createProperty(propName, type, (OType)null, true);
        }
        prop.setMandatory(mandatory);
        prop.setReadonly(readonly);
        prop.setNotNull(notNull);
        if (min != null) {
            prop.setMin(min);
        }
        if (max != null) {
            prop.setMax(max);
        }
        if (linkedClass != null) {
            this.linkedClasses.put(prop, linkedClass);
        }
        if (linkedType != null) {
            prop.setLinkedType(linkedType);
        }
        if (collate != null) {
            prop.setCollate(collate);
        }
        if (regexp != null) {
            prop.setRegexp(regexp);
        }
        if (defaultValue != null) {
            prop.setDefaultValue(value);
        }
        if (customFields != null) {
            for (Map.Entry entry : customFields.entrySet()) {
                prop.setCustom((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private Map<String, String> importCustomFields() throws ParseException, IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
        while (this.jsonReader.lastChar() != '}') {
            String key = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
            String value = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
            result.put(key, value);
        }
        this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long importClusters() throws ParseException, IOException {
        this.listener.onMessage("\nImporting clusters...");
        long total = 0L;
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        boolean recreateManualIndex = false;
        if (this.exporterVersion <= 4) {
            this.removeDefaultClusters();
            recreateManualIndex = true;
        }
        HashSet<String> indexesToRebuild = new HashSet<String>();
        ORecordId rid = null;
        while (this.jsonReader.lastChar() != ']') {
            int clusterId;
            String type;
            int id;
            this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
            Object name = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"name\"").readString(OJSONReader.COMMA_SEPARATOR);
            if (((String)name).length() == 0) {
                name = null;
            }
            if ((name = OClassImpl.decodeClassName((String)name)) != null) {
                if (this.includeClusters != null) {
                    if (!this.includeClusters.contains(name)) {
                        this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                        continue;
                    }
                } else if (this.excludeClusters != null && this.excludeClusters.contains(name)) {
                    this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                    continue;
                }
            }
            if (this.exporterVersion < 9) {
                id = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"id\"").readInteger(OJSONReader.COMMA_SEPARATOR);
                type = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"type\"").readString(OJSONReader.NEXT_IN_OBJECT);
            } else {
                id = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"id\"").readInteger(OJSONReader.NEXT_IN_OBJECT);
            }
            type = this.jsonReader.lastChar() == ',' ? this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"type\"").readString(OJSONReader.NEXT_IN_OBJECT) : "PHYSICAL";
            rid = this.jsonReader.lastChar() == ',' ? new ORecordId(this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"rid\"").readString(OJSONReader.NEXT_IN_OBJECT)) : null;
            this.listener.onMessage("\n- Creating cluster " + (name != null ? "'" + (String)name + "'" : "NULL") + "...");
            int n = clusterId = name != null ? this.database.getClusterIdByName((String)name) : -1;
            if (clusterId == -1) {
                if (!this.preserveClusterIDs) {
                    clusterId = this.database.addCluster((String)name, new Object[0]);
                } else {
                    clusterId = this.database.addCluster((String)name, id, (Object[])null);
                    assert (clusterId == id);
                }
            }
            if (clusterId != id) {
                if (!this.preserveClusterIDs) {
                    if (this.database.countClusterElements(clusterId - 1) != 0L) throw new OConfigurationException("Imported cluster '" + (String)name + "' has id=" + clusterId + " different from the original: " + id + ". To continue the import drop the cluster '" + this.database.getClusterNameById(clusterId - 1) + "' that has " + this.database.countClusterElements(clusterId - 1) + " records");
                    this.listener.onMessage("Found previous version: migrating old clusters...");
                    this.database.dropCluster((String)name, true);
                    this.database.addCluster("temp_" + clusterId, null);
                    clusterId = this.database.addCluster((String)name, new Object[0]);
                } else {
                    this.database.dropCluster(clusterId, false);
                    this.database.addCluster((String)name, id, (Object[])null);
                }
            }
            if (!(name == null || ((String)name).equalsIgnoreCase("manindex") || ((String)name).equalsIgnoreCase("internal") || ((String)name).equalsIgnoreCase("index"))) {
                if (!this.merge) {
                    this.database.command("truncate cluster `" + (String)name + "`", new Object[0]).close();
                }
                for (OIndex<?> existingIndex : this.database.getMetadata().getIndexManager().getIndexes()) {
                    if (!existingIndex.getClusters().contains(name)) continue;
                    indexesToRebuild.add(existingIndex.getName());
                }
            }
            this.listener.onMessage("OK, assigned id=" + clusterId);
            ++total;
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
        }
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        this.listener.onMessage("\nRebuilding indexes of truncated clusters ...");
        for (final String indexName : indexesToRebuild) {
            this.database.getMetadata().getIndexManager().getIndex(indexName).rebuild(new OProgressListener(){
                private long last = 0L;

                @Override
                public void onBegin(Object iTask, long iTotal, Object metadata) {
                    ODatabaseImport.this.listener.onMessage("\n- Cluster content was updated: rebuilding index '" + indexName + "'...");
                }

                @Override
                public boolean onProgress(Object iTask, long iCounter, float iPercent) {
                    long now = System.currentTimeMillis();
                    if (this.last == 0L) {
                        this.last = now;
                    } else if (now - this.last > 1000L) {
                        ODatabaseImport.this.listener.onMessage(String.format("\nIndex '%s' is rebuilding (%.2f/100)", indexName, Float.valueOf(iPercent)));
                        this.last = now;
                    }
                    return true;
                }

                @Override
                public void onCompletition(Object iTask, boolean iSucceed) {
                    ODatabaseImport.this.listener.onMessage(" Index " + indexName + " was successfully rebuilt.");
                }
            });
        }
        this.listener.onMessage("\nDone " + indexesToRebuild.size() + " indexes were rebuilt.");
        if (recreateManualIndex) {
            this.database.addCluster("manindex", new Object[0]);
            this.database.getMetadata().getIndexManager().create();
            this.listener.onMessage("\nManual index cluster was recreated.");
        }
        this.listener.onMessage("\nDone. Imported " + total + " clusters");
        if (this.database.load(new ORecordId(this.database.getStorage().getConfiguration().getIndexMgrRecordId())) != null) return total;
        ODocument indexDocument = new ODocument();
        indexDocument.save("internal");
        this.database.getStorage().setIndexMgrRecordId(indexDocument.getIdentity().toString());
        return total;
    }

    private long importRecords() throws Exception {
        long total = 0L;
        this.database.getMetadata().getIndexManager().dropIndex(EXPORT_IMPORT_MAP_NAME);
        OIndexFactory factory = OIndexes.getFactory(OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.toString(), "HASH_INDEX");
        this.exportImportHashTable = this.database.getMetadata().getIndexManager().createIndex(EXPORT_IMPORT_MAP_NAME, OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.toString(), new OSimpleKeyIndexDefinition(OType.LINK), null, null, null);
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        long totalRecords = 0L;
        this.listener.onMessage("\n\nImporting records...");
        ORID lastRid = new ORecordId();
        long begin = System.currentTimeMillis();
        long lastLapRecords = 0L;
        long last = begin;
        HashSet<String> involvedClusters = new HashSet<String>();
        while (this.jsonReader.lastChar() != ']') {
            long now;
            ORID rid = this.importRecord();
            ++total;
            if (rid != null) {
                ++lastLapRecords;
                ++totalRecords;
                if (rid.getClusterId() != lastRid.getClusterId() || involvedClusters.isEmpty()) {
                    involvedClusters.add(this.database.getClusterNameById(rid.getClusterId()));
                }
                lastRid = rid;
            }
            if ((now = System.currentTimeMillis()) - last > 5000L) {
                ArrayList sortedClusters = new ArrayList(involvedClusters);
                Collections.sort(sortedClusters);
                this.listener.onMessage(String.format("\n- Imported %,d records into clusters: %s. Total JSON records imported so for %,d .Total records imported so far: %,d (%,.2f/sec)", lastLapRecords, total, sortedClusters.size(), totalRecords, Float.valueOf((float)lastLapRecords * 1000.0f / 5000.0f)));
                last = now;
                lastLapRecords = 0L;
                involvedClusters.clear();
            }
            this.record = null;
        }
        HashSet<ORID> brokenRids = new HashSet<ORID>();
        this.processBrokenRids(brokenRids);
        this.listener.onMessage(String.format("\n\nDone. Imported %,d records in %,.2f secs\n", totalRecords, Float.valueOf((float)(System.currentTimeMillis() - begin) / 1000.0f)));
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        return total;
    }

    private ORID importRecord() throws Exception {
        block23: {
            String value = this.jsonReader.readString(OJSONReader.NEXT_IN_ARRAY).trim();
            if (value.isEmpty()) {
                return null;
            }
            while (!value.isEmpty() && value.charAt(0) != '{') {
                value = value.substring(1);
            }
            this.record = null;
            try {
                try {
                    this.record = ORecordSerializerJSON.INSTANCE.fromString(value, this.record, null);
                }
                catch (OSerializationException e) {
                    if (e.getCause() instanceof OSchemaException) {
                        int pos = value.indexOf("\"@class\":\"");
                        if (pos > -1) {
                            int end = value.indexOf("\"", pos + "\"@class\":\"".length() + 1);
                            String value1 = value.substring(0, pos + "\"@class\":\"".length());
                            String clsName = value.substring(pos + "\"@class\":\"".length(), end);
                            String value2 = value.substring(end);
                            String newClassName = this.convertedClassNames.get(clsName);
                            value = value1 + newClassName + value2;
                            this.record = ORecordSerializerJSON.INSTANCE.fromString(value, this.record, null);
                        }
                    }
                    throw OException.wrapException(new ODatabaseImportException("Error on importing record"), e);
                }
                if (this.record == null || this.record.getIdentity() == null) {
                    OLogManager.instance().warn((Object)this, "Broken record was detected and will be skipped", new Object[0]);
                    return null;
                }
                if (this.schemaImported && this.record.getIdentity().equals(this.schemaRecordId)) {
                    return null;
                }
                if (this.includeClusters != null ? !this.includeClusters.contains(this.database.getClusterNameById(this.record.getIdentity().getClusterId())) : this.excludeClusters != null && this.excludeClusters.contains(this.database.getClusterNameById(this.record.getIdentity().getClusterId()))) {
                    return null;
                }
                if (this.record instanceof ODocument && this.excludeClasses != null && this.excludeClasses.contains(((ODocument)this.record).getClassName())) {
                    return null;
                }
                if (this.record.getIdentity().getClusterId() == 0 && this.record.getIdentity().getClusterPosition() == 1L) {
                    return null;
                }
                if (this.exporterVersion >= 3) {
                    int oridsId = this.database.getClusterIdByName("ORIDs");
                    int indexId = this.database.getClusterIdByName("index");
                    if (this.record.getIdentity().getClusterId() == indexId || this.record.getIdentity().getClusterId() == oridsId) {
                        return null;
                    }
                }
                int manualIndexCluster = this.database.getClusterIdByName("manindex");
                int internalCluster = this.database.getClusterIdByName("internal");
                int indexCluster = this.database.getClusterIdByName("index");
                if (this.exporterVersion >= 4 && this.record.getIdentity().getClusterId() == manualIndexCluster) {
                    return null;
                }
                if (this.record.getIdentity().equals(this.indexMgrRecordId)) {
                    return null;
                }
                ORID rid = this.record.getIdentity();
                int clusterId = rid.getClusterId();
                if (clusterId != manualIndexCluster && clusterId != internalCluster && clusterId != indexCluster) {
                    ORecordInternal.setVersion(this.record, 0);
                    this.record.setDirty();
                    ORecordInternal.setIdentity(this.record, new ORecordId());
                    if (!this.preserveRids && this.record instanceof ODocument && ODocumentInternal.getImmutableSchemaClass(this.database, (ODocument)this.record) != null) {
                        this.record.save();
                    } else {
                        this.record.save(this.database.getClusterNameById(clusterId));
                    }
                    if (!rid.equals(this.record.getIdentity())) {
                        this.exportImportHashTable.put(rid, this.record.getIdentity());
                    }
                }
            }
            catch (Exception t) {
                if (this.record != null) {
                    OLogManager.instance().error(this, "Error importing record " + this.record.getIdentity() + ". Source line " + this.jsonReader.getLineNumber() + ", column " + this.jsonReader.getColumnNumber(), t, new Object[0]);
                } else {
                    OLogManager.instance().error(this, "Error importing record. Source line " + this.jsonReader.getLineNumber() + ", column " + this.jsonReader.getColumnNumber(), t, new Object[0]);
                }
                if (t instanceof ODatabaseException) break block23;
                throw t;
            }
        }
        return this.record.getIdentity();
    }

    /*
     * Could not resolve type clashes
     */
    private void importIndexes() throws IOException, ParseException {
        this.listener.onMessage("\n\nImporting indexes ...");
        OIndexManager indexManager = this.database.getMetadata().getIndexManager();
        indexManager.reload();
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        int n = 0;
        while (this.jsonReader.lastChar() != ']') {
            this.jsonReader.readNext(OJSONReader.NEXT_OBJ_IN_ARRAY);
            if (this.jsonReader.lastChar() == ']') break;
            String blueprintsIndexClass = null;
            String indexName = null;
            String indexType = null;
            String indexAlgorithm = null;
            Set<Object> clustersToIndex = new HashSet();
            OIndexDefinition indexDefinition = null;
            ODocument metadata = null;
            HashMap engineProperties = null;
            while (this.jsonReader.lastChar() != '}') {
                String fieldName = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
                if (fieldName.equals("name")) {
                    indexName = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                    continue;
                }
                if (fieldName.equals("type")) {
                    indexType = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                    continue;
                }
                if (fieldName.equals("algorithm")) {
                    indexAlgorithm = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                    continue;
                }
                if (fieldName.equals("clustersToIndex")) {
                    clustersToIndex = this.importClustersToIndex();
                    continue;
                }
                if (fieldName.equals("definition")) {
                    indexDefinition = this.importIndexDefinition();
                    this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
                    continue;
                }
                if (fieldName.equals("metadata")) {
                    String jsonMetadata = this.jsonReader.readString(OJSONReader.END_OBJECT, true);
                    metadata = new ODocument().fromJSON(jsonMetadata);
                    this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
                    continue;
                }
                if (fieldName.equals("engineProperties")) {
                    String jsonEngineProperties = this.jsonReader.readString(OJSONReader.END_OBJECT, true);
                    Map<String, Object> map = new ODocument().fromJSON(jsonEngineProperties).toMap();
                    if (map != null) {
                        engineProperties = new HashMap(map.size());
                        for (Map.Entry<String, Object> entry : map.entrySet()) {
                            map.put(entry.getKey(), entry.getValue());
                        }
                    }
                    this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
                    continue;
                }
                if (!fieldName.equals("blueprintsIndexClass")) continue;
                blueprintsIndexClass = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
            }
            if (indexName == null) {
                throw new IllegalArgumentException("Index name is missing");
            }
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
            if (indexName.equalsIgnoreCase(EXPORT_IMPORT_MAP_NAME)) continue;
            this.listener.onMessage("\n- Index '" + indexName + "'...");
            indexManager.dropIndex(indexName);
            this.indexesToRebuild.remove(indexName);
            ArrayList<Integer> clusterIds = new ArrayList<Integer>();
            for (String clusterName : clustersToIndex) {
                int id = this.database.getClusterIdByName(clusterName);
                if (id != -1) {
                    clusterIds.add(id);
                    continue;
                }
                this.listener.onMessage(String.format("found not existent cluster '%s' in index '%s' configuration, skipping", clusterName, indexName));
            }
            int[] clusterIdsToIndex = new int[clusterIds.size()];
            int i = 0;
            for (Integer clusterId : clusterIds) {
                clusterIdsToIndex[i] = clusterId;
                ++i;
            }
            if (indexDefinition == null) {
                indexDefinition = new OSimpleKeyIndexDefinition(OType.STRING);
            }
            boolean oldValue = OGlobalConfiguration.INDEX_IGNORE_NULL_VALUES_DEFAULT.getValueAsBoolean();
            OGlobalConfiguration.INDEX_IGNORE_NULL_VALUES_DEFAULT.setValue(indexDefinition.isNullValuesIgnored());
            OIndex<?> index = indexManager.createIndex(indexName, indexType, indexDefinition, clusterIdsToIndex, null, metadata, indexAlgorithm);
            OGlobalConfiguration.INDEX_IGNORE_NULL_VALUES_DEFAULT.setValue(oldValue);
            if (blueprintsIndexClass != null) {
                ODocument configuration = index.getConfiguration();
                configuration.field("blueprintsIndexClass", blueprintsIndexClass);
                indexManager.save();
            }
            ++n;
            this.listener.onMessage("OK");
        }
        this.listener.onMessage("\nDone. Created " + n + " indexes.");
        this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
    }

    private Set<String> importClustersToIndex() throws IOException, ParseException {
        HashSet<String> clustersToIndex = new HashSet<String>();
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        while (this.jsonReader.lastChar() != ']') {
            String clusterToIndex = this.jsonReader.readString(OJSONReader.NEXT_IN_ARRAY);
            clustersToIndex.add(clusterToIndex);
        }
        this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
        return clustersToIndex;
    }

    private OIndexDefinition importIndexDefinition() throws IOException, ParseException {
        OIndexDefinition indexDefinition;
        this.jsonReader.readString(OJSONReader.BEGIN_OBJECT);
        this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
        String className = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
        this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
        String value = this.jsonReader.readString(OJSONReader.END_OBJECT, true);
        ODocument indexDefinitionDoc = (ODocument)ORecordSerializerJSON.INSTANCE.fromString(value, null, null);
        try {
            Class<?> indexDefClass = Class.forName(className);
            indexDefinition = (OIndexDefinition)indexDefClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            indexDefinition.fromStream(indexDefinitionDoc);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        catch (InvocationTargetException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        catch (InstantiationException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
        return indexDefinition;
    }

    private void migrateLinksInImportedDocuments(Set<ORID> brokenRids) throws IOException {
        long begin;
        this.listener.onMessage("\n\nStarted migration of links (-migrateLinks=true). Links are going to be updated according to new RIDs:");
        long last = begin = System.currentTimeMillis();
        long documentsLastLap = 0L;
        long totalDocuments = 0L;
        Collection<String> clusterNames = this.database.getClusterNames();
        for (String clusterName : clusterNames) {
            if ("index".equals(clusterName) || "internal".equals(clusterName) || "manindex".equals(clusterName)) continue;
            long documents = 0L;
            String prefix = "";
            this.listener.onMessage("\n- Cluster " + clusterName + "...");
            int clusterId = this.database.getClusterIdByName(clusterName);
            long clusterRecords = this.database.countClusterElements(clusterId);
            OStorage storage = this.database.getStorage();
            OPhysicalPosition[] positions = storage.ceilingPhysicalPositions(clusterId, new OPhysicalPosition(0L));
            while (positions.length > 0) {
                for (OPhysicalPosition position : positions) {
                    ORecord record = (ORecord)this.database.load(new ORecordId(clusterId, position.clusterPosition));
                    if (!(record instanceof ODocument)) continue;
                    ODocument document = (ODocument)record;
                    this.rewriteLinksInDocument(document, brokenRids);
                    ++documents;
                    ++documentsLastLap;
                    ++totalDocuments;
                    long now = System.currentTimeMillis();
                    if (now - last <= 5000L) continue;
                    this.listener.onMessage(String.format("\n--- Migrated %,d of %,d records (%,.2f/sec)", documents, clusterRecords, Float.valueOf((float)documentsLastLap * 1000.0f / 5000.0f)));
                    last = now;
                    documentsLastLap = 0L;
                    prefix = "\n---";
                }
                positions = storage.higherPhysicalPositions(clusterId, positions[positions.length - 1]);
            }
            this.listener.onMessage(String.format("%s Completed migration of %,d records in current cluster", prefix, documents));
        }
        this.listener.onMessage(String.format("\nTotal links updated: %,d", totalDocuments));
    }

    protected void rewriteLinksInDocument(ODocument document, Set<ORID> brokenRids) {
        ODatabaseImport.rewriteLinksInDocument(document, this.exportImportHashTable, brokenRids);
        document.save();
    }

    protected static void rewriteLinksInDocument(ODocument document, OIndex<OIdentifiable> exportImportHashTable, Set<ORID> brokenRids) {
        OLinksRewriter rewriter = new OLinksRewriter(new OConverterData(exportImportHashTable, brokenRids));
        ODocumentFieldWalker documentFieldWalker = new ODocumentFieldWalker();
        documentFieldWalker.walkDocument(document, rewriter);
    }
}

