/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import com.orientechnologies.orient.core.storage.impl.local.OStorageRecoverEventListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OGraphRepair {
    private OStorageRecoverEventListener eventListener;

    public void repair(ODatabaseSession graph, OCommandOutputListener outputListener, Map<String, List<String>> options) {
        this.message(outputListener, "Repair of graph '" + graph.getURL() + "' is started ...\n");
        long beginTime = System.currentTimeMillis();
        ORepairStats stats = new ORepairStats();
        this.repairEdges(graph, stats, outputListener, options, false);
        this.repairVertices(graph, stats, outputListener, options, false);
        this.message(outputListener, "Repair of graph '" + graph.getURL() + "' completed in " + (System.currentTimeMillis() - beginTime) / 1000L + " secs\n");
        this.message(outputListener, " scannedEdges.....: " + stats.scannedEdges + "\n");
        this.message(outputListener, " removedEdges.....: " + stats.removedEdges + "\n");
        this.message(outputListener, " scannedVertices..: " + stats.scannedVertices + "\n");
        this.message(outputListener, " scannedLinks.....: " + stats.scannedLinks + "\n");
        this.message(outputListener, " removedLinks.....: " + stats.removedLinks + "\n");
        this.message(outputListener, " repairedVertices.: " + stats.repairedVertices + "\n");
    }

    public void check(ODatabaseSession graph, OCommandOutputListener outputListener, Map<String, List<String>> options) {
        this.message(outputListener, "Check of graph '" + graph.getURL() + "' is started...\n");
        long beginTime = System.currentTimeMillis();
        ORepairStats stats = new ORepairStats();
        this.repairEdges(graph, stats, outputListener, options, true);
        this.repairVertices(graph, stats, outputListener, options, true);
        this.message(outputListener, "Check of graph '" + graph.getURL() + "' completed in " + (System.currentTimeMillis() - beginTime) / 1000L + " secs\n");
        this.message(outputListener, " scannedEdges.....: " + stats.scannedEdges + "\n");
        this.message(outputListener, " edgesToRemove....: " + stats.removedEdges + "\n");
        this.message(outputListener, " scannedVertices..: " + stats.scannedVertices + "\n");
        this.message(outputListener, " scannedLinks.....: " + stats.scannedLinks + "\n");
        this.message(outputListener, " linksToRemove....: " + stats.removedLinks + "\n");
        this.message(outputListener, " verticesToRepair.: " + stats.repairedVertices + "\n");
    }

    protected void repairEdges(ODatabaseSession graph, ORepairStats stats, OCommandOutputListener outputListener, Map<String, List<String>> options, boolean checkOnly) {
        ODatabaseSession db = graph;
        OMetadata metadata = db.getMetadata();
        OSchema schema = metadata.getSchema();
        boolean useVertexFieldsForEdgeLabels = true;
        OClass edgeClass = schema.getClass("E");
        if (edgeClass != null) {
            long countEdges = db.countClass(edgeClass.getName());
            long skipEdges = 0L;
            if (options != null && options.get("-skipEdges") != null) {
                skipEdges = Long.parseLong(options.get("-skipEdges").get(0));
            }
            this.message(outputListener, "Scanning " + countEdges + " edges (skipEdges=" + skipEdges + ")...\n");
            long parsedEdges = 0L;
            long beginTime = System.currentTimeMillis();
            for (ODocument edge : db.browseClass(edgeClass.getName())) {
                if (!edge.isEdge()) continue;
                ORID edgeId = edge.getIdentity();
                if (skipEdges > 0L && ++parsedEdges <= skipEdges) continue;
                ++stats.scannedEdges;
                if (this.eventListener != null) {
                    this.eventListener.onScannedEdge(edge);
                }
                if (outputListener != null && stats.scannedEdges % 100000L == 0L) {
                    long speedPerSecond = (long)((double)parsedEdges / ((double)(System.currentTimeMillis() - beginTime) / 1000.0));
                    if (speedPerSecond < 1L) {
                        speedPerSecond = 1L;
                    }
                    long remaining = (countEdges - parsedEdges) / speedPerSecond;
                    this.message(outputListener, "+ edges: scanned " + stats.scannedEdges + ", removed " + stats.removedEdges + " (estimated remaining time " + remaining + " secs)\n");
                }
                boolean outVertexMissing = false;
                String removalReason = "";
                OVertex out = edge.asEdge().get().getFrom();
                if (out == null) {
                    outVertexMissing = true;
                } else {
                    ODocument outVertex;
                    try {
                        outVertex = (ODocument)out.getRecord();
                    }
                    catch (ORecordNotFoundException e) {
                        outVertex = null;
                    }
                    if (outVertex == null) {
                        outVertexMissing = true;
                    } else {
                        String outFieldName = OVertexDocument.getConnectionFieldName(ODirection.OUT, edge.getClassName(), true);
                        Object outEdges = outVertex.field(outFieldName);
                        if (outEdges == null) {
                            outVertexMissing = true;
                        } else if (outEdges instanceof ORidBag) {
                            if (!((ORidBag)outEdges).contains(edgeId)) {
                                outVertexMissing = true;
                            }
                        } else if (outEdges instanceof Collection) {
                            if (!((Collection)outEdges).contains(edgeId)) {
                                outVertexMissing = true;
                            }
                        } else if (outEdges instanceof OIdentifiable && ((OIdentifiable)outEdges).getIdentity().equals(edgeId)) {
                            outVertexMissing = true;
                        }
                    }
                }
                if (outVertexMissing) {
                    removalReason = "outgoing vertex (" + out + ") does not contain the edge";
                }
                boolean inVertexMissing = false;
                OVertex in = edge.asEdge().get().getTo();
                if (in == null) {
                    inVertexMissing = true;
                } else {
                    ODocument inVertex;
                    try {
                        inVertex = (ODocument)in.getRecord();
                    }
                    catch (ORecordNotFoundException e) {
                        inVertex = null;
                    }
                    if (inVertex == null) {
                        inVertexMissing = true;
                    } else {
                        String inFieldName = OVertexDocument.getConnectionFieldName(ODirection.IN, edge.getClassName(), true);
                        Object inEdges = inVertex.field(inFieldName);
                        if (inEdges == null) {
                            inVertexMissing = true;
                        } else if (inEdges instanceof ORidBag) {
                            if (!((ORidBag)inEdges).contains(edgeId)) {
                                inVertexMissing = true;
                            }
                        } else if (inEdges instanceof Collection) {
                            if (!((Collection)inEdges).contains(edgeId)) {
                                inVertexMissing = true;
                            }
                        } else if (inEdges instanceof OIdentifiable && ((OIdentifiable)inEdges).getIdentity().equals(edgeId)) {
                            inVertexMissing = true;
                        }
                    }
                }
                if (inVertexMissing) {
                    if (!removalReason.isEmpty()) {
                        removalReason = removalReason + ", ";
                    }
                    removalReason = removalReason + "incoming vertex (" + in + ") does not contain the edge";
                }
                if (!outVertexMissing && !inVertexMissing) continue;
                try {
                    if (!checkOnly) {
                        this.message(outputListener, "+ deleting corrupted edge " + edge + " because " + removalReason + "\n");
                        edge.delete();
                    } else {
                        this.message(outputListener, "+ found corrupted edge " + edge + " because " + removalReason + "\n");
                    }
                    ++stats.removedEdges;
                    if (this.eventListener == null) continue;
                    this.eventListener.onRemovedEdge(edge);
                }
                catch (Exception e) {
                    this.message(outputListener, "Error on deleting edge " + edge.getIdentity() + " (" + e.getMessage() + ")");
                }
            }
            this.message(outputListener, "Scanning edges completed\n");
        }
    }

    protected void repairVertices(ODatabaseSession graph, ORepairStats stats, OCommandOutputListener outputListener, Map<String, List<String>> options, boolean checkOnly) {
        ODatabaseSession db = graph;
        OMetadata metadata = db.getMetadata();
        OSchema schema = metadata.getSchema();
        OClass vertexClass = schema.getClass("E");
        if (vertexClass != null) {
            long countVertices = db.countClass(vertexClass.getName());
            long skipVertices = 0L;
            if (options != null && options.get("-skipVertices") != null) {
                skipVertices = Long.parseLong(options.get("-skipVertices").get(0));
            }
            this.message(outputListener, "Scanning " + countVertices + " vertices...\n");
            long parsedVertices = 0L;
            long beginTime = System.currentTimeMillis();
            for (ODocument vertex : db.browseClass(vertexClass.getName())) {
                OVertex v;
                boolean vertexCorrupted = false;
                if (skipVertices > 0L && ++parsedVertices <= skipVertices) continue;
                ++stats.scannedVertices;
                if (this.eventListener != null) {
                    this.eventListener.onScannedVertex(vertex);
                }
                if (outputListener != null && stats.scannedVertices % 100000L == 0L) {
                    long speedPerSecond = (long)((double)parsedVertices / ((double)(System.currentTimeMillis() - beginTime) / 1000.0));
                    if (speedPerSecond < 1L) {
                        speedPerSecond = 1L;
                    }
                    long remaining = (countVertices - parsedVertices) / speedPerSecond;
                    this.message(outputListener, "+ vertices: scanned " + stats.scannedVertices + ", repaired " + stats.repairedVertices + " (estimated remaining time " + remaining + " secs)\n");
                }
                if ((v = (OVertex)vertex.asVertex().orElse(null)) == null) continue;
                for (String fieldName : vertex.fieldNames()) {
                    Object o;
                    Iterator<Object> it;
                    Object fieldValue;
                    OPair<ODirection, String> connection = this.getConnection(db, ODirection.BOTH, fieldName, null);
                    if (connection == null || (fieldValue = vertex.rawField(fieldName)) == null) continue;
                    if (fieldValue instanceof OIdentifiable) {
                        if (!this.isEdgeBroken(vertex, fieldName, (ODirection)((Object)connection.getKey()), (OIdentifiable)fieldValue, stats, true)) continue;
                        vertexCorrupted = true;
                        if (!checkOnly) {
                            vertex.field(fieldName, (Object)null);
                            continue;
                        }
                        this.message(outputListener, "+ found corrupted vertex " + vertex + " the property " + fieldName + " could be removed\n");
                        continue;
                    }
                    if (fieldValue instanceof Collection) {
                        Collection coll = (Collection)fieldValue;
                        it = coll.iterator();
                        while (it.hasNext()) {
                            o = it.next();
                            if (!this.isEdgeBroken(vertex, fieldName, (ODirection)((Object)connection.getKey()), (OIdentifiable)o, stats, true)) continue;
                            vertexCorrupted = true;
                            if (!checkOnly) {
                                it.remove();
                                continue;
                            }
                            this.message(outputListener, "+ found corrupted vertex " + vertex + " the edge should be removed from property " + fieldName + " (collection)\n");
                        }
                        continue;
                    }
                    if (!(fieldValue instanceof ORidBag)) continue;
                    ORidBag ridbag = (ORidBag)fieldValue;
                    if (ridbag.size() == 0) {
                        vertex.removeField(fieldName);
                    } else if (!ridbag.isEmbedded() && ridbag.size() < OGlobalConfiguration.RID_BAG_SBTREEBONSAI_TO_EMBEDDED_THRESHOLD.getValueAsInteger()) {
                        vertex.setDirty();
                    }
                    it = ridbag.rawIterator();
                    while (it.hasNext()) {
                        o = it.next();
                        if (!this.isEdgeBroken(vertex, fieldName, (ODirection)((Object)connection.getKey()), (OIdentifiable)o, stats, true)) continue;
                        vertexCorrupted = true;
                        if (!checkOnly) {
                            it.remove();
                            continue;
                        }
                        this.message(outputListener, "+ found corrupted vertex " + vertex + " the edge should be removed from property " + fieldName + " (ridbag)\n");
                    }
                }
                if (vertexCorrupted) {
                    ++stats.repairedVertices;
                    if (this.eventListener != null) {
                        this.eventListener.onRepairedVertex(vertex);
                    }
                    this.message(outputListener, "+ repaired corrupted vertex " + vertex + "\n");
                    if (checkOnly) continue;
                    vertex.save();
                    continue;
                }
                if (!vertex.isDirty() || checkOnly) continue;
                this.message(outputListener, "+ optimized vertex " + vertex + "\n");
                vertex.save();
            }
            this.message(outputListener, "Scanning vertices completed\n");
        }
    }

    protected OPair<ODirection, String> getConnection(ODatabaseDocument graph, ODirection iDirection, String iFieldName, String ... iClassNames) {
        OClass edgeType;
        String connClass;
        if (iClassNames != null && iClassNames.length == 1 && iClassNames[0].equalsIgnoreCase("E")) {
            iClassNames = null;
        }
        if ((iDirection == ODirection.OUT || iDirection == ODirection.BOTH) && iFieldName.startsWith("out_")) {
            connClass = this.getConnectionClass(ODirection.OUT, iFieldName);
            if (iClassNames == null || iClassNames.length == 0) {
                return new OPair<ODirection, String>(ODirection.OUT, connClass);
            }
            edgeType = graph.getClass(connClass);
            if (edgeType != null) {
                for (String clsName : iClassNames) {
                    if (!edgeType.isSubClassOf(clsName)) continue;
                    return new OPair<ODirection, String>(ODirection.OUT, connClass);
                }
            }
        }
        if ((iDirection == ODirection.IN || iDirection == ODirection.BOTH) && iFieldName.startsWith("in_")) {
            connClass = this.getConnectionClass(ODirection.IN, iFieldName);
            if (iClassNames == null || iClassNames.length == 0) {
                return new OPair<ODirection, String>(ODirection.IN, connClass);
            }
            edgeType = graph.getClass(connClass);
            if (edgeType != null) {
                for (String clsName : iClassNames) {
                    if (!edgeType.isSubClassOf(clsName)) continue;
                    return new OPair<ODirection, String>(ODirection.IN, connClass);
                }
            }
        }
        return null;
    }

    public String getConnectionClass(ODirection iDirection, String iFieldName) {
        if (iDirection == ODirection.OUT) {
            if (iFieldName.length() > "out_".length()) {
                return iFieldName.substring("out_".length());
            }
        } else if (iDirection == ODirection.IN && iFieldName.length() > "in_".length()) {
            return iFieldName.substring("in_".length());
        }
        return "E";
    }

    private void onScannedLink(ORepairStats stats, OIdentifiable fieldValue) {
        ++stats.scannedLinks;
        if (this.eventListener != null) {
            this.eventListener.onScannedLink(fieldValue);
        }
    }

    private void onRemovedLink(ORepairStats stats, OIdentifiable fieldValue) {
        ++stats.removedLinks;
        if (this.eventListener != null) {
            this.eventListener.onRemovedLink(fieldValue);
        }
    }

    public OStorageRecoverEventListener getEventListener() {
        return this.eventListener;
    }

    public OGraphRepair setEventListener(OStorageRecoverEventListener eventListener) {
        this.eventListener = eventListener;
        return this;
    }

    private void message(OCommandOutputListener outputListener, String message) {
        if (outputListener != null) {
            outputListener.onMessage(message);
        }
    }

    private boolean isEdgeBroken(OIdentifiable vertex, String fieldName, ODirection direction, OIdentifiable edgeRID, ORepairStats stats, boolean useVertexFieldsForEdgeLabels) {
        this.onScannedLink(stats, edgeRID);
        boolean broken = false;
        if (edgeRID == null) {
            broken = true;
        } else {
            ODocument record = null;
            try {
                record = (ODocument)edgeRID.getIdentity().getRecord();
            }
            catch (ORecordNotFoundException e) {
                broken = true;
            }
            if (record == null) {
                broken = true;
            } else {
                OImmutableClass immutableClass = ODocumentInternal.getImmutableSchemaClass(record);
                if (immutableClass == null || !immutableClass.isVertexType() && !immutableClass.isEdgeType()) {
                    broken = true;
                } else if (immutableClass.isVertexType()) {
                    String inverseFieldName = OGraphRepair.getInverseConnectionFieldName(fieldName, useVertexFieldsForEdgeLabels);
                    Object inverseEdgeContainer = record.field(inverseFieldName);
                    if (inverseEdgeContainer == null) {
                        broken = true;
                    } else if (inverseEdgeContainer instanceof OIdentifiable) {
                        if (!inverseEdgeContainer.equals(vertex)) {
                            broken = true;
                        }
                    } else if (inverseEdgeContainer instanceof Collection) {
                        if (!((Collection)inverseEdgeContainer).contains(vertex)) {
                            broken = true;
                        }
                    } else if (inverseEdgeContainer instanceof ORidBag && !((ORidBag)inverseEdgeContainer).contains(vertex)) {
                        broken = true;
                    }
                } else {
                    OVertex backRID;
                    OEdge edge = record.asEdge().orElse(null);
                    if (!(edge == null || (backRID = edge.getVertex(direction)) != null && backRID.equals(vertex))) {
                        broken = true;
                    }
                }
            }
        }
        if (broken) {
            this.onRemovedLink(stats, edgeRID);
            return true;
        }
        return false;
    }

    public static String getInverseConnectionFieldName(String iFieldName, boolean useVertexFieldsForEdgeLabels) {
        if (useVertexFieldsForEdgeLabels) {
            if (iFieldName.startsWith("out_")) {
                if (iFieldName.length() == "out_".length()) {
                    return "in_";
                }
                return "in_" + iFieldName.substring("out_".length());
            }
            if (iFieldName.startsWith("in_")) {
                if (iFieldName.length() == "in_".length()) {
                    return "out_";
                }
                return "out_" + iFieldName.substring("in_".length());
            }
            throw new IllegalArgumentException("Cannot find reverse connection name for field " + iFieldName);
        }
        if (iFieldName.equals("out")) {
            return "in";
        }
        if (iFieldName.equals("in")) {
            return "out";
        }
        throw new IllegalArgumentException("Cannot find reverse connection name for field " + iFieldName);
    }

    private class ORepairStats {
        long scannedEdges = 0L;
        long removedEdges = 0L;
        long scannedVertices = 0L;
        long scannedLinks = 0L;
        long removedLinks = 0L;
        long repairedVertices = 0L;

        private ORepairStats() {
        }
    }
}

