/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OAutoConvertToRecord;
import com.orientechnologies.orient.core.db.record.ODetachable;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.iterator.OEmptyMapEntryIterator;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableProperty;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OSecurityShared;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordListener;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocumentEntry;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.OEdgeDelegate;
import com.orientechnologies.orient.core.record.impl.ONestedMultiValueChangeEvent;
import com.orientechnologies.orient.core.record.impl.OSimpleMultiValueChangeListener;
import com.orientechnologies.orient.core.record.impl.OVertexDelegate;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import com.orientechnologies.orient.core.storage.OBasicTransaction;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ODocument
extends ORecordAbstract
implements Iterable<Map.Entry<String, Object>>,
ORecordSchemaAware,
ODetachable,
Externalizable,
OElement {
    public static final byte RECORD_TYPE = 100;
    protected static final String[] EMPTY_STRINGS = new String[0];
    private static final long serialVersionUID = 1L;
    protected int _fieldSize;
    protected Map<String, ODocumentEntry> _fields;
    protected boolean _trackingChanges = true;
    protected boolean _ordered = true;
    protected boolean _lazyLoad = true;
    protected boolean _allowChainedAccess = true;
    protected transient List<WeakReference<ORecordElement>> _owners = null;
    protected OImmutableSchema _schema;
    private String _className;
    private OImmutableClass _immutableClazz;
    private int _immutableSchemaVersion = 1;

    public ODocument() {
        this.setup();
    }

    @Deprecated
    public ODocument(byte[] iSource) {
        this._source = iSource;
        this.setup();
    }

    public ODocument(InputStream iSource) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OIOUtils.copyStream(iSource, out, -1L);
        this._source = out.toByteArray();
        this.setup();
    }

    public ODocument(ORID iRID) {
        this.setup();
        this._recordId = (ORecordId)iRID;
        this._status = ORecordElement.STATUS.NOT_LOADED;
        this._dirty = false;
        this._contentChanged = false;
    }

    public ODocument(String iClassName, ORID iRID) {
        this(iClassName);
        OImmutableSchema schema;
        OClass cls;
        this._recordId = (ORecordId)iRID;
        ODatabaseDocumentInternal database = this.getDatabaseInternal();
        if (this._recordId.getClusterId() > -1 && (cls = (schema = database.getMetadata().getImmutableSchemaSnapshot()).getClassByClusterId(this._recordId.getClusterId())) != null && !cls.getName().equals(iClassName)) {
            throw new IllegalArgumentException("Cluster id does not correspond class name should be " + iClassName + " but found " + cls.getName());
        }
        this._dirty = false;
        this._contentChanged = false;
        this._status = ORecordElement.STATUS.NOT_LOADED;
    }

    public ODocument(String iClassName) {
        this.setup();
        this.setClassName(iClassName);
    }

    public ODocument(OClass iClass) {
        this(iClass != null ? iClass.getName() : null);
    }

    public ODocument(Object[] iFields) {
        this.setup();
        if (iFields != null && iFields.length > 0) {
            for (int i = 0; i < iFields.length; i += 2) {
                this.field(iFields[i].toString(), iFields[i + 1]);
            }
        }
    }

    public ODocument(Map<?, Object> iFieldMap) {
        this.setup();
        if (iFieldMap != null && !iFieldMap.isEmpty()) {
            for (Map.Entry<?, Object> entry : iFieldMap.entrySet()) {
                this.field(entry.getKey().toString(), entry.getValue());
            }
        }
    }

    public ODocument(String iFieldName, Object iFieldValue, Object ... iFields) {
        this(iFields);
        this.field(iFieldName, iFieldValue);
    }

    @Override
    public Optional<OVertex> asVertex() {
        if (this instanceof OVertex) {
            return Optional.of((OVertex)((Object)this));
        }
        OClass type = this.getSchemaClass();
        if (type == null) {
            return Optional.empty();
        }
        if (type.isVertexType()) {
            return Optional.of(new OVertexDelegate(this));
        }
        return Optional.empty();
    }

    @Override
    public Optional<OEdge> asEdge() {
        if (this instanceof OEdge) {
            return Optional.of((OEdge)((Object)this));
        }
        OClass type = this.getSchemaClass();
        if (type == null) {
            return Optional.empty();
        }
        if (type.isEdgeType()) {
            return Optional.of(new OEdgeDelegate(this));
        }
        return Optional.empty();
    }

    @Override
    public boolean isVertex() {
        if (this instanceof OVertex) {
            return true;
        }
        OClass type = this.getSchemaClass();
        if (type == null) {
            return false;
        }
        return type.isVertexType();
    }

    @Override
    public boolean isEdge() {
        if (this instanceof OEdge) {
            return true;
        }
        OClass type = this.getSchemaClass();
        if (type == null) {
            return false;
        }
        return type.isEdgeType();
    }

    @Override
    public Optional<OClass> getSchemaType() {
        return Optional.ofNullable(this.getSchemaClass());
    }

    @Override
    public Set<String> getPropertyNames() {
        String[] fieldNames;
        this.checkForLoading();
        if (this._status == ORecordElement.STATUS.LOADED && this._source != null && ODatabaseRecordThreadLocal.instance().isDefined() && !ODatabaseRecordThreadLocal.instance().get().isClosed() && (fieldNames = this._recordFormat.getFieldNamesRoot(this, this._source)) != null) {
            HashSet<String> result = new HashSet<String>();
            Collections.addAll(result, fieldNames);
            return result;
        }
        this.checkForFields(new String[0]);
        if (this._fields == null || this._fields.size() == 0) {
            return Collections.EMPTY_SET;
        }
        return this._fields.entrySet().stream().filter(s -> ((ODocumentEntry)s.getValue()).exist()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public <RET> RET getProperty(String iFieldName) {
        Object newValue;
        if (iFieldName == null) {
            return null;
        }
        this.checkForLoading();
        Object value = ODocumentHelper.getIdentifiableValue(this, iFieldName);
        if (!iFieldName.startsWith("@") && this._lazyLoad && value instanceof ORID && (((ORID)value).isPersistent() || ((ORID)value).isNew()) && ODatabaseRecordThreadLocal.instance().isDefined() && (newValue = this.getDatabase().load((ORID)value)) != null) {
            this.unTrack((ORID)value);
            this.track((OIdentifiable)newValue);
            value = newValue;
            if (this.isTrackingChanges()) {
                ORecordInternal.setDirtyManager((ORecord)value, this.getDirtyManager());
            }
            ODocumentEntry entry = this._fields.get(iFieldName);
            this.removeCollectionChangeListener(entry, entry.value);
            entry.value = value;
            this.addCollectionChangeListener(entry);
        }
        if (value instanceof OElement) {
            if (((OElement)value).isVertex()) {
                value = ((OElement)value).asVertex().get();
            } else if (((OElement)value).isEdge()) {
                value = ((OElement)value).asEdge().get();
            }
        }
        return (RET)value;
    }

    protected <RET> RET getRawProperty(String iFieldName) {
        if (iFieldName == null) {
            return null;
        }
        this.checkForLoading();
        return (RET)ODocumentHelper.getIdentifiableValue(this, iFieldName);
    }

    @Override
    public void setProperty(String iFieldName, Object iPropertyValue) {
        if (iPropertyValue instanceof OElement && !((OElement)iPropertyValue).getSchemaType().isPresent() && !((OElement)iPropertyValue).getIdentity().isValid()) {
            this.setProperty(iFieldName, iPropertyValue, OType.EMBEDDED);
        } else {
            this.setProperty(iFieldName, iPropertyValue, OCommonConst.EMPTY_TYPES_ARRAY);
        }
    }

    @Override
    public void setProperty(String iPropetyName, Object iPropertyValue, OType ... iFieldType) {
        ORidBag ridBag;
        OType oldType;
        Object oldValue;
        boolean knownProperty;
        if (iPropetyName == null) {
            throw new IllegalArgumentException("Field is null");
        }
        if (iPropetyName.isEmpty()) {
            throw new IllegalArgumentException("Field name is empty");
        }
        if ("@class".equals(iPropetyName)) {
            this.setClassName(iPropertyValue.toString());
            return;
        }
        if ("@rid".equals(iPropetyName)) {
            this._recordId.fromString(iPropertyValue.toString());
            return;
        }
        if ("@version".equals(iPropetyName)) {
            if (iPropertyValue != null) {
                int v = iPropertyValue instanceof Number ? ((Number)iPropertyValue).intValue() : Integer.parseInt(iPropertyValue.toString());
                this._recordVersion = v;
            }
            return;
        }
        this.checkForLoading();
        this.checkForFields(new String[0]);
        ODocumentEntry entry = this._fields.get(iPropetyName);
        if (entry == null) {
            entry = new ODocumentEntry();
            ++this._fieldSize;
            this._fields.put(iPropetyName, entry);
            entry.setCreated(true);
            knownProperty = false;
            oldValue = null;
            oldType = null;
        } else {
            knownProperty = entry.exist();
            oldValue = entry.value;
            oldType = entry.type;
        }
        OType fieldType = this.deriveFieldType(iPropetyName, entry, iFieldType);
        if (iPropertyValue != null && fieldType != null) {
            iPropertyValue = ODocumentHelper.convertField(this, iPropetyName, fieldType, null, iPropertyValue);
        } else if (iPropertyValue instanceof Enum) {
            iPropertyValue = iPropertyValue.toString();
        }
        if (knownProperty) {
            if (iPropertyValue == null) {
                if (oldValue == null) {
                    return;
                }
            } else {
                try {
                    if (iPropertyValue.equals(oldValue) && fieldType == oldType) {
                        if (!(iPropertyValue instanceof ORecordElement)) {
                            this.setDirty();
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    OLogManager.instance().warn((Object)this, "Error on checking the value of property %s against the record %s", e, iPropetyName, this.getIdentity());
                }
            }
        }
        if (oldValue instanceof ORidBag) {
            ridBag = (ORidBag)oldValue;
            ridBag.setOwner(null);
        } else if (oldValue instanceof ODocument) {
            ((ODocument)oldValue).removeOwner(this);
        }
        if (oldValue instanceof OIdentifiable) {
            this.unTrack((OIdentifiable)oldValue);
        }
        if (iPropertyValue != null) {
            if (iPropertyValue instanceof ODocument && OType.EMBEDDED.equals((Object)fieldType)) {
                ODocument embeddedDocument = (ODocument)iPropertyValue;
                ODocumentInternal.addOwner(embeddedDocument, this);
            }
            if (iPropertyValue instanceof OIdentifiable) {
                this.track((OIdentifiable)iPropertyValue);
            }
            if (iPropertyValue instanceof ORidBag) {
                ridBag = (ORidBag)iPropertyValue;
                ridBag.setOwner(null);
                ridBag.setOwner(this);
            }
        }
        if (oldType != fieldType && oldType != null && (iPropertyValue == null || fieldType != null || oldType != OType.getTypeByValue(iPropertyValue))) {
            entry.type = fieldType;
        }
        this.removeCollectionChangeListener(entry, oldValue);
        entry.value = iPropertyValue;
        if (!entry.exist()) {
            entry.setExist(true);
            ++this._fieldSize;
        }
        this.addCollectionChangeListener(entry);
        if (this._status != ORecordElement.STATUS.UNMARSHALLING) {
            this.setDirty();
            if (!entry.isChanged()) {
                entry.original = oldValue;
                entry.setChanged(true);
            }
        }
    }

    @Override
    public <RET> RET removeProperty(String iFieldName) {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        if ("@class".equalsIgnoreCase(iFieldName)) {
            this.setClassName(null);
        } else if ("@rid".equalsIgnoreCase(iFieldName)) {
            this._recordId = new ORecordId();
        }
        ODocumentEntry entry = this._fields.get(iFieldName);
        if (entry == null) {
            return null;
        }
        Object oldValue = entry.value;
        if (entry.exist() && this._trackingChanges) {
            if (entry.original == null) {
                entry.original = entry.value;
            }
            entry.value = null;
            entry.setExist(false);
            entry.setChanged(true);
        } else {
            this._fields.remove(iFieldName);
        }
        --this._fieldSize;
        this.removeCollectionChangeListener(entry, oldValue);
        if (oldValue instanceof OIdentifiable) {
            this.unTrack((OIdentifiable)oldValue);
        }
        if (oldValue instanceof ORidBag) {
            ((ORidBag)oldValue).setOwner(null);
        }
        this.setDirty();
        return (RET)oldValue;
    }

    protected static void validateField(ODocument iRecord, OImmutableProperty p) throws OValidationException {
        Object fieldValue;
        ODocumentEntry entry = iRecord._fields.get(p.getName());
        if (entry != null && entry.exist()) {
            fieldValue = entry.value;
            if (p.isNotNull() && fieldValue == null) {
                throw new OValidationException("The field '" + p.getFullName() + "' cannot be null, record: " + iRecord);
            }
            if (fieldValue != null && p.getRegexp() != null && p.getType().equals((Object)OType.STRING) && !((String)fieldValue).matches(p.getRegexp())) {
                throw new OValidationException("The field '" + p.getFullName() + "' does not match the regular expression '" + p.getRegexp() + "'. Field value is: " + fieldValue + ", record: " + iRecord);
            }
        } else {
            if (p.isMandatory()) {
                throw new OValidationException("The field '" + p.getFullName() + "' is mandatory, but not found on record: " + iRecord);
            }
            fieldValue = null;
        }
        OType type = p.getType();
        if (fieldValue != null && type != null) {
            switch (type) {
                case LINK: {
                    ODocument.validateLink(p, fieldValue, false);
                    break;
                }
                case LINKLIST: {
                    if (!(fieldValue instanceof List)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as LINKLIST but an incompatible type is used. Value: " + fieldValue);
                    }
                    ODocument.validateLinkCollection(p, (Collection)fieldValue, entry);
                    break;
                }
                case LINKSET: {
                    if (!(fieldValue instanceof Set)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as LINKSET but an incompatible type is used. Value: " + fieldValue);
                    }
                    ODocument.validateLinkCollection(p, (Collection)fieldValue, entry);
                    break;
                }
                case LINKMAP: {
                    if (!(fieldValue instanceof Map)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as LINKMAP but an incompatible type is used. Value: " + fieldValue);
                    }
                    ODocument.validateLinkCollection(p, ((Map)fieldValue).values(), entry);
                    break;
                }
                case LINKBAG: {
                    if (!(fieldValue instanceof ORidBag)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as LINKBAG but an incompatible type is used. Value: " + fieldValue);
                    }
                    ODocument.validateLinkCollection(p, (Iterable)fieldValue, entry);
                    break;
                }
                case EMBEDDED: {
                    ODocument.validateEmbedded(p, fieldValue);
                    break;
                }
                case EMBEDDEDLIST: {
                    if (!(fieldValue instanceof List)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as EMBEDDEDLIST but an incompatible type is used. Value: " + fieldValue);
                    }
                    if (p.getLinkedClass() != null) {
                        for (Object object : (List)fieldValue) {
                            ODocument.validateEmbedded(p, object);
                        }
                    } else {
                        if (p.getLinkedType() == null) break;
                        for (Object object : (List)fieldValue) {
                            ODocument.validateType(p, object);
                        }
                    }
                    break;
                }
                case EMBEDDEDSET: {
                    if (!(fieldValue instanceof Set)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as EMBEDDEDSET but an incompatible type is used. Value: " + fieldValue);
                    }
                    if (p.getLinkedClass() != null) {
                        for (Object object : (Set)fieldValue) {
                            ODocument.validateEmbedded(p, object);
                        }
                    } else {
                        if (p.getLinkedType() == null) break;
                        for (Object object : (Set)fieldValue) {
                            ODocument.validateType(p, object);
                        }
                    }
                    break;
                }
                case EMBEDDEDMAP: {
                    if (!(fieldValue instanceof Map)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as EMBEDDEDMAP but an incompatible type is used. Value: " + fieldValue);
                    }
                    if (p.getLinkedClass() != null) {
                        for (Map.Entry entry2 : ((Map)fieldValue).entrySet()) {
                            ODocument.validateEmbedded(p, entry2.getValue());
                        }
                    } else {
                        if (p.getLinkedType() == null) break;
                        for (Map.Entry entry3 : ((Map)fieldValue).entrySet()) {
                            ODocument.validateType(p, entry3.getValue());
                        }
                    }
                    break;
                }
            }
        }
        if (p.getMin() != null && fieldValue != null) {
            String min = p.getMin();
            if (p.getMinComparable().compareTo(fieldValue) > 0) {
                switch (p.getType()) {
                    case STRING: {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains fewer characters than " + min + " requested");
                    }
                    case DATE: 
                    case DATETIME: {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains the date " + fieldValue + " which precedes the first acceptable date (" + min + ")");
                    }
                    case BINARY: {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains fewer bytes than " + min + " requested");
                    }
                    case LINKLIST: 
                    case LINKSET: 
                    case LINKMAP: 
                    case EMBEDDEDLIST: 
                    case EMBEDDEDSET: 
                    case EMBEDDEDMAP: {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains fewer items than " + min + " requested");
                    }
                }
                throw new OValidationException("The field '" + p.getFullName() + "' is less than " + min);
            }
        }
        if (p.getMaxComparable() != null && fieldValue != null) {
            String max = p.getMax();
            if (p.getMaxComparable().compareTo(fieldValue) < 0) {
                switch (p.getType()) {
                    case STRING: {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains more characters than " + max + " requested");
                    }
                    case DATE: 
                    case DATETIME: {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains the date " + fieldValue + " which is after the last acceptable date (" + max + ")");
                    }
                    case BINARY: {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains more bytes than " + max + " requested");
                    }
                    case LINKLIST: 
                    case LINKSET: 
                    case LINKMAP: 
                    case EMBEDDEDLIST: 
                    case EMBEDDEDSET: 
                    case EMBEDDEDMAP: {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains more items than " + max + " requested");
                    }
                }
                throw new OValidationException("The field '" + p.getFullName() + "' is greater than " + max);
            }
        }
        if (p.isReadonly() && !ORecordVersionHelper.isTombstone(iRecord.getVersion()) && entry != null && (entry.changed || entry.timeLine != null) && !entry.created) {
            boolean bl;
            Object orgVal = entry.original;
            boolean bl2 = bl = fieldValue != null ? OType.isSimpleType(fieldValue) : OType.isSimpleType(orgVal);
            if (bl || fieldValue != null && orgVal == null || fieldValue == null && orgVal != null || fieldValue != null && !fieldValue.equals(orgVal)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is immutable and cannot be altered. Field value is: " + entry.value);
            }
        }
    }

    protected static void validateLinkCollection(OProperty property, Iterable<Object> values, ODocumentEntry value) {
        if (property.getLinkedClass() != null) {
            if (value.timeLine != null) {
                List<OMultiValueChangeEvent<Object, Object>> event = value.timeLine.getMultiValueChangeEvents();
                for (OMultiValueChangeEvent<Object, Object> object : event) {
                    if (object.getChangeType() != OMultiValueChangeEvent.OChangeType.ADD && (object.getChangeType() != OMultiValueChangeEvent.OChangeType.UPDATE || object.getValue() == null)) continue;
                    ODocument.validateLink(property, object.getValue(), OSecurityShared.ALLOW_FIELDS.contains(property.getName()));
                }
            } else {
                boolean autoconvert = false;
                if (values instanceof ORecordLazyMultiValue) {
                    autoconvert = ((ORecordLazyMultiValue)((Object)values)).isAutoConvertToRecord();
                    ((ORecordLazyMultiValue)((Object)values)).setAutoConvertToRecord(false);
                }
                for (Object object : values) {
                    ODocument.validateLink(property, object, OSecurityShared.ALLOW_FIELDS.contains(property.getName()));
                }
                if (values instanceof ORecordLazyMultiValue) {
                    ((ORecordLazyMultiValue)((Object)values)).setAutoConvertToRecord(autoconvert);
                }
            }
        }
    }

    protected static void validateType(OProperty p, Object value) {
        if (value != null && OType.convert(value, p.getLinkedType().getDefaultJavaType()) == null) {
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " of type '" + (Object)((Object)p.getLinkedType()) + "' but the value is " + value);
        }
    }

    protected static void validateLink(OProperty p, Object fieldValue, boolean allowNull) {
        Object linkedRecord;
        ORID rid;
        if (fieldValue == null) {
            if (allowNull) {
                return;
            }
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but contains a null record (probably a deleted record?)");
        }
        if (!(fieldValue instanceof OIdentifiable)) {
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but the value is not a record or a record-id");
        }
        OClass schemaClass = p.getLinkedClass();
        if (schemaClass != null && !schemaClass.isSubClassOf("OIdentity") && !schemaClass.hasPolymorphicClusterId((rid = ((OIdentifiable)fieldValue).getIdentity()).getClusterId()) && (linkedRecord = ((OIdentifiable)fieldValue).getRecord()) != null) {
            if (!(linkedRecord instanceof ODocument)) {
                throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " of type '" + schemaClass + "' but the value is the record " + linkedRecord.getIdentity() + " that is not a document");
            }
            ODocument doc = (ODocument)linkedRecord;
            if (doc.getImmutableSchemaClass() != null && !schemaClass.isSuperClassOf(doc.getImmutableSchemaClass())) {
                throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " of type '" + schemaClass.getName() + "' but the value is the document " + linkedRecord.getIdentity() + " of class '" + doc.getImmutableSchemaClass() + "'");
            }
        }
    }

    protected static void validateEmbedded(OProperty p, Object fieldValue) {
        if (fieldValue == null) {
            return;
        }
        if (fieldValue instanceof ORecordId) {
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but the value is the RecordID " + fieldValue);
        }
        if (fieldValue instanceof OIdentifiable) {
            OIdentifiable embedded = (OIdentifiable)fieldValue;
            if (embedded.getIdentity().isValid()) {
                throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but the value is a document with the valid RecordID " + fieldValue);
            }
            OClass embeddedClass = p.getLinkedClass();
            if (embeddedClass != null) {
                Object embeddedRecord = embedded.getRecord();
                if (!(embeddedRecord instanceof ODocument)) {
                    throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " with linked class '" + embeddedClass + "' but the record was not a document");
                }
                ODocument doc = (ODocument)embeddedRecord;
                if (doc.getImmutableSchemaClass() == null) {
                    throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " with linked class '" + embeddedClass + "' but the record has no class");
                }
                if (!doc.getImmutableSchemaClass().isSubClassOf(embeddedClass)) {
                    throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " with linked class '" + embeddedClass + "' but the record is of class '" + doc.getImmutableSchemaClass().getName() + "' that is not a subclass of that");
                }
                doc.validate();
            }
        } else {
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but an incompatible type is used. Value: " + fieldValue);
        }
    }

    public ODocument copy() {
        return (ODocument)this.copyTo(new ODocument());
    }

    @Override
    public ORecordAbstract copyTo(ORecordAbstract iDestination) {
        this.checkForFields(new String[0]);
        ODocument destination = (ODocument)iDestination;
        super.copyTo(iDestination);
        destination._ordered = this._ordered;
        destination._className = this._className;
        destination._immutableSchemaVersion = -1;
        destination._immutableClazz = null;
        destination._trackingChanges = this._trackingChanges;
        destination._owners = this._owners != null ? new ArrayList<WeakReference<ORecordElement>>(this._owners) : null;
        if (this._fields != null) {
            destination._fields = this._fields instanceof LinkedHashMap ? new LinkedHashMap() : new HashMap();
            for (Map.Entry<String, ODocumentEntry> entry : this._fields.entrySet()) {
                ODocumentEntry docEntry = entry.getValue().clone();
                destination._fields.put(entry.getKey(), docEntry);
                docEntry.value = ODocumentHelper.cloneValue(destination, entry.getValue().value);
            }
        } else {
            destination._fields = null;
        }
        destination._fieldSize = this._fieldSize;
        destination.addAllMultiValueChangeListeners();
        destination._dirty = this._dirty;
        destination._contentChanged = this._contentChanged;
        return destination;
    }

    public ORecord placeholder() {
        ODocument cloned = new ODocument();
        cloned._source = null;
        cloned._recordId = this._recordId;
        cloned._status = ORecordElement.STATUS.NOT_LOADED;
        cloned._dirty = false;
        cloned._contentChanged = false;
        return cloned;
    }

    @Override
    public boolean detach() {
        this.deserializeFields(new String[0]);
        boolean fullyDetached = true;
        if (this._fields != null) {
            for (Map.Entry<String, ODocumentEntry> entry : this._fields.entrySet()) {
                Object fieldValue = entry.getValue().value;
                if (fieldValue instanceof ORecord) {
                    if (((ORecord)fieldValue).getIdentity().isNew()) {
                        fullyDetached = false;
                    } else {
                        entry.getValue().value = ((ORecord)fieldValue).getIdentity();
                    }
                }
                if (!(fieldValue instanceof ODetachable) || ((ODetachable)fieldValue).detach()) continue;
                fullyDetached = false;
            }
        }
        return fullyDetached;
    }

    public ODocument load(String iFetchPlan) {
        return this.load(iFetchPlan, false);
    }

    public ODocument load(String iFetchPlan, boolean iIgnoreCache) {
        Object result;
        try {
            result = this.getDatabase().load(this, iFetchPlan, iIgnoreCache);
        }
        catch (Exception e) {
            throw OException.wrapException(new ORecordNotFoundException(this.getIdentity()), e);
        }
        if (result == null) {
            throw new ORecordNotFoundException(this.getIdentity());
        }
        return (ODocument)result;
    }

    @Deprecated
    public ODocument load(String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone) {
        Object result;
        try {
            result = this.getDatabase().load(this, iFetchPlan, iIgnoreCache, loadTombstone, OStorage.LOCKING_STRATEGY.DEFAULT);
        }
        catch (Exception e) {
            throw OException.wrapException(new ORecordNotFoundException(this.getIdentity()), e);
        }
        if (result == null) {
            throw new ORecordNotFoundException(this.getIdentity());
        }
        return (ODocument)result;
    }

    @Override
    public ODocument reload(String fetchPlan, boolean ignoreCache) {
        super.reload(fetchPlan, ignoreCache);
        if (!this._lazyLoad) {
            this.checkForLoading();
            this.checkForFields(new String[0]);
        }
        return this;
    }

    public boolean hasSameContentOf(ODocument iOther) {
        ODatabaseDocumentInternal currentDb = ODatabaseRecordThreadLocal.instance().getIfDefined();
        return ODocumentHelper.hasSameContentOf(this, currentDb, iOther, currentDb, null);
    }

    @Override
    public byte[] toStream() {
        if (this._recordFormat == null) {
            this.setup();
        }
        return this.toStream(false);
    }

    public Map<String, Object> toMap() {
        String className;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String field : this.fieldNames()) {
            map.put(field, this.field(field));
        }
        ORID id = this.getIdentity();
        if (id.isValid()) {
            map.put("@rid", id);
        }
        if ((className = this.getClassName()) != null) {
            map.put("@class", className);
        }
        return map;
    }

    @Override
    public String toString() {
        return this.toString(new HashSet<ORecord>());
    }

    @Deprecated
    public void fromString(String iValue) {
        this._dirty = true;
        this._contentChanged = true;
        try {
            this._source = iValue.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSerializationException("Error reading content from string"), e);
        }
        this.removeAllCollectionChangeListeners();
        this._fields = null;
        this._fieldSize = 0;
    }

    @Override
    public String[] fieldNames() {
        String[] fieldNames;
        this.checkForLoading();
        if (this._status == ORecordElement.STATUS.LOADED && this._source != null && ODatabaseRecordThreadLocal.instance().isDefined() && !ODatabaseRecordThreadLocal.instance().get().isClosed() && (fieldNames = this._recordFormat.getFieldNamesRoot(this, this._source)) != null) {
            return fieldNames;
        }
        this.checkForFields(new String[0]);
        if (this._fields == null || this._fields.size() == 0) {
            return EMPTY_STRINGS;
        }
        ArrayList<String> names = new ArrayList<String>(this._fields.size());
        for (Map.Entry<String, ODocumentEntry> entry : this._fields.entrySet()) {
            if (!entry.getValue().exist()) continue;
            names.add(entry.getKey());
        }
        return names.toArray(new String[names.size()]);
    }

    private Set<String> arrayToSet(String[] fieldNames) {
        HashSet<String> result = new HashSet<String>();
        Collections.addAll(result, fieldNames);
        return result;
    }

    @Override
    public Object[] fieldValues() {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        Object[] res = new Object[this._fields.size()];
        int i = 0;
        for (ODocumentEntry entry : this._fields.values()) {
            res[i++] = entry.value;
        }
        return res;
    }

    public <RET> RET rawField(String iFieldName) {
        if (iFieldName == null || iFieldName.length() == 0) {
            return null;
        }
        this.checkForLoading();
        if (!this.checkForFields(iFieldName)) {
            return null;
        }
        if (!this._allowChainedAccess || iFieldName.charAt(0) != '@' && OStringSerializerHelper.indexOf(iFieldName, 0, '.', '[') == -1) {
            ODocumentEntry entry = this._fields.get(iFieldName);
            if (entry != null && entry.exist()) {
                return (RET)entry.value;
            }
            return null;
        }
        return ODocumentHelper.getFieldValue(this, iFieldName);
    }

    public Object eval(String iExpression) {
        return this.eval(iExpression, null);
    }

    public Object eval(String iExpression, OCommandContext iContext) {
        return new OSQLPredicate(iExpression).evaluate(this, null, iContext);
    }

    @Override
    public <RET> RET field(String iFieldName) {
        Object newValue;
        RET value = this.rawField(iFieldName);
        if (!iFieldName.startsWith("@") && this._lazyLoad && value instanceof ORID && (((ORID)value).isPersistent() || ((ORID)value).isNew()) && ODatabaseRecordThreadLocal.instance().isDefined() && (newValue = this.getDatabase().load((ORID)value)) != null) {
            this.unTrack((ORID)value);
            this.track((OIdentifiable)newValue);
            value = newValue;
            if (this.isTrackingChanges()) {
                ORecordInternal.setDirtyManager((ORecord)value, this.getDirtyManager());
            }
            if (!iFieldName.contains(".")) {
                ODocumentEntry entry = this._fields.get(iFieldName);
                this.removeCollectionChangeListener(entry, entry.value);
                entry.value = value;
                this.addCollectionChangeListener(entry);
            }
        }
        return value;
    }

    public <RET> RET field(String iFieldName, Class<?> iFieldType) {
        RET value = this.rawField(iFieldName);
        if (value != null) {
            value = ODocumentHelper.convertField(this, iFieldName, OType.getTypeByClass(iFieldType), iFieldType, value);
        }
        return value;
    }

    @Override
    public <RET> RET field(String iFieldName, OType iFieldType) {
        OType original;
        Object value = this.field(iFieldName);
        if (iFieldType != null && iFieldType != (original = this.fieldType(iFieldName))) {
            if (original == null && iFieldType == (original = OType.getTypeByValue(value))) {
                return value;
            }
            Object newValue = iFieldType == OType.BINARY && value instanceof String ? OStringSerializerHelper.getBinaryContent(value) : (iFieldType == OType.DATE && value instanceof Long ? (Object)new Date((Long)value) : ((iFieldType == OType.EMBEDDEDSET || iFieldType == OType.LINKSET) && value instanceof List ? (Object)Collections.unmodifiableSet((Set)ODocumentHelper.convertField(this, iFieldName, iFieldType, null, value)) : ((iFieldType == OType.EMBEDDEDLIST || iFieldType == OType.LINKLIST) && value instanceof Set ? (Object)Collections.unmodifiableList((List)ODocumentHelper.convertField(this, iFieldName, iFieldType, null, value)) : ((iFieldType == OType.EMBEDDEDMAP || iFieldType == OType.LINKMAP) && value instanceof Map ? (Object)Collections.unmodifiableMap((Map)ODocumentHelper.convertField(this, iFieldName, iFieldType, null, value)) : (Object)OType.convert(value, iFieldType.getDefaultJavaType())))));
            if (newValue != null) {
                value = newValue;
            }
        }
        return value;
    }

    @Override
    public ODocument field(String iFieldName, Object iPropertyValue) {
        return this.field(iFieldName, iPropertyValue, OCommonConst.EMPTY_TYPES_ARRAY);
    }

    public ODocument fields(String iFieldName, Object iFieldValue, Object ... iFields) {
        if (iFields != null && iFields.length % 2 != 0) {
            throw new IllegalArgumentException("Fields must be passed in pairs as name and value");
        }
        this.field(iFieldName, iFieldValue);
        if (iFields != null && iFields.length > 0) {
            for (int i = 0; i < iFields.length; i += 2) {
                this.field(iFields[i].toString(), iFields[i + 1]);
            }
        }
        return this;
    }

    @Deprecated
    public ODocument fields(Map<String, Object> iMap) {
        return this.fromMap(iMap);
    }

    public ODocument fromMap(Map<String, ?> iMap) {
        if (iMap != null) {
            for (Map.Entry<String, ?> entry : iMap.entrySet()) {
                this.field(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Override
    public ODocument field(String iFieldName, Object iPropertyValue, OType ... iFieldType) {
        ORidBag ridBag;
        OType oldType;
        Object oldValue;
        boolean knownProperty;
        boolean lastIsArray;
        if (iFieldName == null) {
            throw new IllegalArgumentException("Field is null");
        }
        if (iFieldName.isEmpty()) {
            throw new IllegalArgumentException("Field name is empty");
        }
        if ("@class".equals(iFieldName)) {
            this.setClassName(iPropertyValue.toString());
            return this;
        }
        if ("@rid".equals(iFieldName)) {
            this._recordId.fromString(iPropertyValue.toString());
            return this;
        }
        if ("@version".equals(iFieldName)) {
            if (iPropertyValue != null) {
                int v = iPropertyValue instanceof Number ? ((Number)iPropertyValue).intValue() : Integer.parseInt(iPropertyValue.toString());
                this._recordVersion = v;
            }
            return this;
        }
        int lastDotSep = this._allowChainedAccess ? iFieldName.lastIndexOf(46) : -1;
        int lastArraySep = this._allowChainedAccess ? iFieldName.lastIndexOf(91) : -1;
        int lastSep = Math.max(lastArraySep, lastDotSep);
        boolean bl = lastIsArray = lastArraySep > lastDotSep;
        if (lastSep > -1) {
            Object subObject = this.field(iFieldName.substring(0, lastSep));
            if (subObject != null) {
                String subFieldName;
                String string = subFieldName = lastIsArray ? iFieldName.substring(lastSep) : iFieldName.substring(lastSep + 1);
                if (subObject instanceof ODocument) {
                    ((ODocument)subObject).field(subFieldName, iPropertyValue);
                    return ((ODocument)subObject).isEmbedded() ? this : subObject;
                }
                if (subObject instanceof Map) {
                    ((Map)subObject).put(subFieldName, iPropertyValue);
                } else if (OMultiValue.isMultiValue(subObject)) {
                    if ((subObject instanceof List || subObject.getClass().isArray()) && lastIsArray) {
                        int subFieldNameLen = subFieldName.length();
                        if (subFieldName.charAt(subFieldNameLen - 1) != ']') {
                            throw new IllegalArgumentException("Missed closing ']'");
                        }
                        String indexPart = subFieldName.substring(1, subFieldNameLen - 1);
                        Object indexPartObject = ODocumentHelper.getIndexPart(null, indexPart);
                        String indexAsString = indexPartObject == null ? null : indexPartObject.toString();
                        try {
                            int index = Integer.parseInt(indexAsString);
                            OMultiValue.setValue(subObject, iPropertyValue, index);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("List / array subscripts must resolve to integer values.", e);
                        }
                    } else {
                        for (Object subObjectItem : OMultiValue.getMultiValueIterable(subObject)) {
                            if (subObjectItem instanceof ODocument) {
                                if (!((ODocument)subObjectItem).isEmbedded()) {
                                    throw new IllegalArgumentException("Property '" + iFieldName + "' points to linked collection of items. You can only change embedded documents in this way");
                                }
                                ((ODocument)subObjectItem).field(subFieldName, iPropertyValue);
                                continue;
                            }
                            if (!(subObjectItem instanceof Map)) continue;
                            ((Map)subObjectItem).put(subFieldName, iPropertyValue);
                        }
                    }
                    return this;
                }
            } else {
                throw new IllegalArgumentException("Property '" + iFieldName.substring(0, lastSep) + "' is null, is possible to set a value with dotted notation only on not null property");
            }
            return null;
        }
        iFieldName = this.checkFieldName(iFieldName);
        this.checkForLoading();
        this.checkForFields(new String[0]);
        ODocumentEntry entry = this._fields.get(iFieldName);
        if (entry == null) {
            entry = new ODocumentEntry();
            ++this._fieldSize;
            this._fields.put(iFieldName, entry);
            entry.setCreated(true);
            knownProperty = false;
            oldValue = null;
            oldType = null;
        } else {
            knownProperty = entry.exist();
            oldValue = entry.value;
            oldType = entry.type;
        }
        OType fieldType = this.deriveFieldType(iFieldName, entry, iFieldType);
        if (iPropertyValue != null && fieldType != null) {
            iPropertyValue = ODocumentHelper.convertField(this, iFieldName, fieldType, null, iPropertyValue);
        } else if (iPropertyValue instanceof Enum) {
            iPropertyValue = iPropertyValue.toString();
        }
        if (knownProperty) {
            if (iPropertyValue == null) {
                if (oldValue == null) {
                    return this;
                }
            } else {
                try {
                    if (iPropertyValue.equals(oldValue)) {
                        if (fieldType == oldType) {
                            if (!(iPropertyValue instanceof ORecordElement)) {
                                this.setDirty();
                            }
                            return this;
                        }
                    } else if (iPropertyValue instanceof byte[] && Arrays.equals((byte[])iPropertyValue, (byte[])oldValue)) {
                        return this;
                    }
                }
                catch (Exception e) {
                    OLogManager.instance().warn((Object)this, "Error on checking the value of property %s against the record %s", e, iFieldName, this.getIdentity());
                }
            }
        }
        if (oldValue instanceof ORidBag) {
            ridBag = (ORidBag)oldValue;
            ridBag.setOwner(null);
        } else if (oldValue instanceof ODocument) {
            ((ODocument)oldValue).removeOwner(this);
        }
        if (oldValue instanceof OIdentifiable) {
            this.unTrack((OIdentifiable)oldValue);
        }
        if (iPropertyValue != null) {
            if (iPropertyValue instanceof ODocument) {
                ODocument embeddedDocument;
                if (OType.EMBEDDED.equals((Object)fieldType)) {
                    embeddedDocument = (ODocument)iPropertyValue;
                    ODocumentInternal.addOwner(embeddedDocument, this);
                } else if (OType.LINK.equals((Object)fieldType)) {
                    embeddedDocument = (ODocument)iPropertyValue;
                    ODocumentInternal.removeOwner(embeddedDocument, this);
                }
            }
            if (iPropertyValue instanceof OIdentifiable) {
                this.track((OIdentifiable)iPropertyValue);
            }
            if (iPropertyValue instanceof ORidBag) {
                ridBag = (ORidBag)iPropertyValue;
                ridBag.setOwner(null);
                ridBag.setOwner(this);
            }
        }
        if (oldType != fieldType && oldType != null && (iPropertyValue == null || fieldType != null || oldType != OType.getTypeByValue(iPropertyValue))) {
            entry.type = fieldType;
        }
        this.removeCollectionChangeListener(entry, oldValue);
        entry.value = iPropertyValue;
        if (!entry.exist()) {
            entry.setExist(true);
            ++this._fieldSize;
        }
        this.addCollectionChangeListener(entry);
        if (this._status != ORecordElement.STATUS.UNMARSHALLING) {
            this.setDirty();
            if (!entry.isChanged()) {
                entry.original = oldValue;
                entry.setChanged(true);
            }
        }
        return this;
    }

    @Override
    public Object removeField(String iFieldName) {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        if ("@class".equalsIgnoreCase(iFieldName)) {
            this.setClassName(null);
        } else if ("@rid".equalsIgnoreCase(iFieldName)) {
            this._recordId = new ORecordId();
        }
        ODocumentEntry entry = this._fields.get(iFieldName);
        if (entry == null) {
            return null;
        }
        Object oldValue = entry.value;
        if (entry.exist() && this._trackingChanges) {
            if (entry.original == null) {
                entry.original = entry.value;
            }
            entry.value = null;
            entry.setExist(false);
            entry.setChanged(true);
        } else {
            this._fields.remove(iFieldName);
        }
        --this._fieldSize;
        this.removeCollectionChangeListener(entry, oldValue);
        if (oldValue instanceof OIdentifiable) {
            this.unTrack((OIdentifiable)oldValue);
        }
        if (oldValue instanceof ORidBag) {
            ((ORidBag)oldValue).setOwner(null);
        }
        this.setDirty();
        return oldValue;
    }

    public ODocument merge(ODocument iOther, boolean iUpdateOnlyMode, boolean iMergeSingleItemsOfMultiValueFields) {
        iOther.checkForLoading();
        iOther.checkForFields(new String[0]);
        if (this._className == null && iOther.getImmutableSchemaClass() != null) {
            this._className = iOther.getImmutableSchemaClass().getName();
        }
        return this.mergeMap(iOther._fields, iUpdateOnlyMode, iMergeSingleItemsOfMultiValueFields);
    }

    public ODocument merge(Map<String, Object> iOther, boolean iUpdateOnlyMode, boolean iMergeSingleItemsOfMultiValueFields) {
        throw new UnsupportedOperationException();
    }

    public String[] getDirtyFields() {
        if (this._fields == null || this._fields.isEmpty()) {
            return EMPTY_STRINGS;
        }
        HashSet<String> dirtyFields = new HashSet<String>();
        for (Map.Entry<String, ODocumentEntry> entry : this._fields.entrySet()) {
            if (!entry.getValue().isChanged() && entry.getValue().timeLine == null) continue;
            dirtyFields.add(entry.getKey());
        }
        return dirtyFields.toArray(new String[dirtyFields.size()]);
    }

    public Object getOriginalValue(String iFieldName) {
        ODocumentEntry entry;
        if (this._fields != null && (entry = this._fields.get(iFieldName)) != null) {
            return entry.original;
        }
        return null;
    }

    public OMultiValueChangeTimeLine<Object, Object> getCollectionTimeLine(String iFieldName) {
        ODocumentEntry entry = this._fields != null ? this._fields.get(iFieldName) : null;
        return entry != null ? entry.timeLine : null;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        if (this._fields == null) {
            return OEmptyMapEntryIterator.INSTANCE;
        }
        final Iterator<Map.Entry<String, ODocumentEntry>> iterator = this._fields.entrySet().iterator();
        return new Iterator<Map.Entry<String, Object>>(){
            private Map.Entry<String, ODocumentEntry> current;
            private boolean read = true;

            @Override
            public boolean hasNext() {
                while (iterator.hasNext()) {
                    this.current = (Map.Entry)iterator.next();
                    if (!this.current.getValue().exist()) continue;
                    this.read = false;
                    return true;
                }
                return false;
            }

            @Override
            public Map.Entry<String, Object> next() {
                if (this.read && !this.hasNext()) {
                    iterator.next();
                }
                Map.Entry<String, Object> toRet = new Map.Entry<String, Object>(){
                    private Map.Entry<String, ODocumentEntry> intern;
                    {
                        this.intern = current;
                    }

                    @Override
                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Object getValue() {
                        return this.intern.getValue().value;
                    }

                    @Override
                    public String getKey() {
                        return this.intern.getKey();
                    }
                };
                this.read = true;
                return toRet;
            }

            @Override
            public void remove() {
                if (ODocument.this._trackingChanges) {
                    if (this.current.getValue().isChanged()) {
                        this.current.getValue().original = this.current.getValue().value;
                    }
                    this.current.getValue().value = null;
                    this.current.getValue().setExist(false);
                    this.current.getValue().setChanged(true);
                } else {
                    iterator.remove();
                }
                --ODocument.this._fieldSize;
                ODocument.this.removeCollectionChangeListener(this.current.getValue(), this.current.getValue().value);
            }
        };
    }

    @Override
    public boolean containsField(String iFieldName) {
        if (iFieldName == null) {
            return false;
        }
        this.checkForLoading();
        this.checkForFields(iFieldName);
        ODocumentEntry entry = this._fields.get(iFieldName);
        return entry != null && entry.exist();
    }

    public boolean hasOwners() {
        return this._owners != null && !this._owners.isEmpty();
    }

    @Override
    public ORecordElement getOwner() {
        if (this._owners == null) {
            return null;
        }
        for (WeakReference<ORecordElement> _owner : this._owners) {
            ORecordElement e = (ORecordElement)_owner.get();
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public Iterable<ORecordElement> getOwners() {
        if (this._owners == null) {
            return Collections.emptyList();
        }
        ArrayList<ORecordElement> result = new ArrayList<ORecordElement>();
        for (WeakReference<ORecordElement> o : this._owners) {
            if (o.get() == null) continue;
            result.add((ORecordElement)o.get());
        }
        return result;
    }

    @Override
    public ORecordAbstract setDirty() {
        ODatabaseDocumentInternal database;
        ORecordElement owner;
        if (this._owners != null) {
            for (WeakReference<ORecordElement> o : this._owners) {
                ORecordElement e = (ORecordElement)o.get();
                if (e == null) continue;
                e.setDirty();
            }
        } else if (!this.isDirty()) {
            this.getDirtyManager().setDirty(this);
        }
        this.checkForFields(new String[0]);
        super.setDirty();
        boolean addToChangedList = false;
        if (!this.isEmbedded()) {
            owner = this;
        } else {
            for (owner = this.getOwner(); owner != null && owner.getOwner() != null; owner = owner.getOwner()) {
            }
        }
        if (owner instanceof ODocument && ((ODocument)owner).isTrackingChanges() && ((ODocument)owner).getIdentity().isPersistent()) {
            addToChangedList = true;
        }
        if (addToChangedList && (database = this.getDatabaseIfDefined()) != null) {
            OBasicTransaction transaction = database.getMicroOrRegularTransaction();
            transaction.addChangedDocument(this);
        }
        return this;
    }

    @Override
    public void setDirtyNoChanged() {
        if (this._owners != null) {
            for (WeakReference<ORecordElement> o : this._owners) {
                ORecordElement e = (ORecordElement)o.get();
                if (e == null) continue;
                e.setDirtyNoChanged();
            }
        }
        this.getDirtyManager().setDirty(this);
        this.checkForFields(new String[0]);
        super.setDirtyNoChanged();
    }

    @Override
    public ODocument fromStream(byte[] iRecordBuffer) {
        this.removeAllCollectionChangeListeners();
        this._fields = null;
        this._fieldSize = 0;
        this._contentChanged = false;
        this._schema = null;
        this.fetchSchemaIfCan();
        super.fromStream(iRecordBuffer);
        if (!this._lazyLoad) {
            this.checkForLoading();
            this.checkForFields(new String[0]);
        }
        return this;
    }

    public OType fieldType(String iFieldName) {
        this.checkForLoading();
        this.checkForFields(iFieldName);
        ODocumentEntry entry = this._fields.get(iFieldName);
        if (entry != null) {
            return entry.type;
        }
        return null;
    }

    @Override
    public ODocument unload() {
        super.unload();
        this.internalReset();
        return this;
    }

    @Override
    public ODocument clear() {
        super.clear();
        this.internalReset();
        this._owners = null;
        return this;
    }

    @Override
    public ODocument reset() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (db != null && db.getTransaction().isActive()) {
            throw new IllegalStateException("Cannot reset documents during a transaction. Create a new one each time");
        }
        super.reset();
        this._className = null;
        this._immutableClazz = null;
        this._immutableSchemaVersion = -1;
        this.internalReset();
        this._owners = null;
        return this;
    }

    public ODocument undo() {
        if (!this._trackingChanges) {
            throw new OConfigurationException("Cannot undo the document because tracking of changes is disabled");
        }
        if (this._fields != null) {
            Iterator<Map.Entry<String, ODocumentEntry>> vals = this._fields.entrySet().iterator();
            while (vals.hasNext()) {
                Map.Entry<String, ODocumentEntry> next = vals.next();
                ODocumentEntry val = next.getValue();
                if (val.created) {
                    vals.remove();
                    continue;
                }
                if (!val.changed) continue;
                val.value = val.original;
                val.changed = false;
                val.original = null;
                val.exist = true;
            }
            this._fieldSize = this._fields.size();
        }
        return this;
    }

    public ODocument undo(String field) {
        ODocumentEntry value;
        if (!this._trackingChanges) {
            throw new OConfigurationException("Cannot undo the document because tracking of changes is disabled");
        }
        if (this._fields != null && (value = this._fields.get(field)) != null) {
            if (value.created) {
                this._fields.remove(field);
            }
            if (value.changed) {
                value.value = value.original;
                value.original = null;
                value.changed = false;
                value.exist = true;
            }
        }
        return this;
    }

    public boolean isLazyLoad() {
        return this._lazyLoad;
    }

    public void setLazyLoad(boolean iLazyLoad) {
        this._lazyLoad = iLazyLoad;
        this.checkForFields(new String[0]);
        if (this._fields != null) {
            for (Map.Entry<String, ODocumentEntry> field : this._fields.entrySet()) {
                if (!(field.getValue().value instanceof ORecordLazyMultiValue)) continue;
                ((ORecordLazyMultiValue)field.getValue().value).setAutoConvertToRecord(false);
            }
        }
    }

    public boolean isTrackingChanges() {
        return this._trackingChanges;
    }

    public ODocument setTrackingChanges(boolean iTrackingChanges) {
        this._trackingChanges = iTrackingChanges;
        if (!iTrackingChanges && this._fields != null) {
            Iterator<Map.Entry<String, ODocumentEntry>> iter = this._fields.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, ODocumentEntry> cur = iter.next();
                if (!cur.getValue().exist()) {
                    iter.remove();
                    continue;
                }
                cur.getValue().setCreated(false);
                cur.getValue().setChanged(false);
                cur.getValue().original = null;
                cur.getValue().timeLine = null;
            }
            this.removeAllCollectionChangeListeners();
        } else {
            this.addAllMultiValueChangeListeners();
        }
        return this;
    }

    protected void clearTrackData() {
        if (this._fields != null) {
            Iterator<Map.Entry<String, ODocumentEntry>> iter = this._fields.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, ODocumentEntry> cur = iter.next();
                if (!cur.getValue().exist()) {
                    iter.remove();
                    continue;
                }
                cur.getValue().setCreated(false);
                cur.getValue().setChanged(false);
                cur.getValue().original = null;
                cur.getValue().timeLine = null;
                if (cur.getValue().changeListener != null || !(cur.getValue().value instanceof OTrackedMultiValue)) continue;
                this.addCollectionChangeListener(cur.getValue());
            }
        }
    }

    public boolean isOrdered() {
        return this._ordered;
    }

    public ODocument setOrdered(boolean iOrdered) {
        this._ordered = iOrdered;
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return this == obj || this._recordId.isValid();
    }

    @Override
    public int hashCode() {
        if (this._recordId.isValid()) {
            return super.hashCode();
        }
        return System.identityHashCode(this);
    }

    @Override
    public int fields() {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        return this._fieldSize;
    }

    public boolean isEmpty() {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        return this._fields == null || this._fields.isEmpty();
    }

    public ODocument fromJSON(String iSource, String iOptions) {
        return (ODocument)super.fromJSON(iSource, iOptions);
    }

    public ODocument fromJSON(String iSource) {
        return (ODocument)super.fromJSON(iSource);
    }

    public ODocument fromJSON(InputStream iContentResult) throws IOException {
        return (ODocument)super.fromJSON(iContentResult);
    }

    public ODocument fromJSON(String iSource, boolean needReload) {
        return (ODocument)super.fromJSON(iSource, needReload);
    }

    public boolean isEmbedded() {
        return this._owners != null && !this._owners.isEmpty();
    }

    public ODocument setFieldType(String iFieldName, OType iFieldType) {
        ODocumentEntry entry;
        this.checkForLoading();
        this.checkForFields(iFieldName);
        if (iFieldType != null) {
            if (this._fields == null) {
                this._fields = this._ordered ? new LinkedHashMap() : new HashMap();
            }
            ODocumentEntry entry2 = this.getOrCreate(iFieldName);
            if (entry2.type != iFieldType) {
                this.field(iFieldName, this.field(iFieldName), iFieldType);
            }
        } else if (this._fields != null && (entry = this._fields.get(iFieldName)) != null) {
            entry.type = null;
        }
        return this;
    }

    @Override
    public ODocument save() {
        return (ODocument)this.save(null, false);
    }

    @Override
    public ODocument save(String iClusterName) {
        return (ODocument)this.save(iClusterName, false);
    }

    @Override
    public ORecordAbstract save(String iClusterName, boolean forceCreate) {
        return (ORecordAbstract)this.getDatabase().save(this, iClusterName, ODatabase.OPERATION_MODE.SYNCHRONOUS, forceCreate, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deserializeFields(String ... iFields) {
        ArrayList<String> additional = null;
        if (this._source == null) {
            return true;
        }
        if (iFields != null && iFields.length > 0) {
            for (int i = 0; i < iFields.length; ++i) {
                int pos;
                String f = iFields[i];
                if (f == null || f.startsWith("@")) continue;
                int pos1 = f.indexOf(91);
                int pos2 = f.indexOf(46);
                if (pos1 <= -1 && pos2 <= -1) continue;
                int n = pos = pos1 > -1 ? pos1 : pos2;
                if (pos2 > -1 && pos2 < pos) {
                    pos = pos2;
                }
                if (additional == null) {
                    additional = new ArrayList<String>();
                }
                additional.add(f.substring(0, pos));
            }
            if (additional != null && iFields != null) {
                String[] copy = new String[iFields.length + additional.size()];
                System.arraycopy(iFields, 0, copy, 0, iFields.length);
                int next = iFields.length;
                for (String s : additional) {
                    copy[next++] = s;
                }
                iFields = copy;
            }
            if (this._fields != null && !this._fields.isEmpty()) {
                boolean allFound = true;
                for (String f : iFields) {
                    if (f == null || f.startsWith("@") || this._fields.containsKey(f)) continue;
                    allFound = false;
                    break;
                }
                if (allFound) {
                    return true;
                }
            }
        }
        if (this._recordFormat == null) {
            this.setup();
        }
        this._status = ORecordElement.STATUS.UNMARSHALLING;
        try {
            this._recordFormat.fromStream(this._source, this, iFields);
        }
        finally {
            this._status = ORecordElement.STATUS.LOADED;
        }
        if (iFields != null && iFields.length > 0) {
            for (String field : iFields) {
                if (field == null || !field.startsWith("@")) continue;
                return true;
            }
            if (this._fields != null && !this._fields.isEmpty()) {
                for (String f : iFields) {
                    if (f == null || !this._fields.containsKey(f)) continue;
                    return true;
                }
            }
            return false;
        }
        if (this._source != null) {
            this._source = null;
        }
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        ORecordSerializer serializer = ORecordSerializerFactory.instance().getFormat("onet_ser_v0");
        byte[] idBuffer = this._recordId.toStream();
        stream.writeInt(-1);
        stream.writeInt(idBuffer.length);
        stream.write(idBuffer);
        stream.writeInt(this._recordVersion);
        byte[] content = serializer.toStream(this, false);
        stream.writeInt(content.length);
        stream.write(content);
        stream.writeBoolean(this._dirty);
        stream.writeObject(serializer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        int i = stream.readInt();
        int size = i < 0 ? stream.readInt() : i;
        byte[] idBuffer = new byte[size];
        stream.readFully(idBuffer);
        this._recordId.fromStream(idBuffer);
        this._recordVersion = stream.readInt();
        int len = stream.readInt();
        byte[] content = new byte[len];
        stream.readFully(content);
        this._dirty = stream.readBoolean();
        ORecordSerializer serializer = this._recordFormat;
        if (i < 0) {
            String str = (String)stream.readObject();
            serializer = ORecordSerializerFactory.instance().getFormat(str);
        }
        this._status = ORecordElement.STATUS.UNMARSHALLING;
        try {
            serializer.fromStream(content, this, null);
        }
        finally {
            this._status = ORecordElement.STATUS.LOADED;
        }
    }

    public boolean isAllowChainedAccess() {
        return this._allowChainedAccess;
    }

    public ODocument setAllowChainedAccess(boolean _allowChainedAccess) {
        this._allowChainedAccess = _allowChainedAccess;
        return this;
    }

    @Override
    public void setClassNameIfExists(String iClassName) {
        OClass _clazz;
        this._immutableClazz = null;
        this._immutableSchemaVersion = -1;
        this._className = iClassName;
        if (iClassName == null) {
            return;
        }
        ODatabaseDocumentInternal db = this.getDatabaseIfDefined();
        if (db != null && (_clazz = ((OMetadataInternal)db.getMetadata()).getImmutableSchemaSnapshot().getClass(iClassName)) != null) {
            this._className = _clazz.getName();
            this.convertFieldsToClass(_clazz);
        }
    }

    @Override
    public OClass getSchemaClass() {
        if (this._className == null) {
            this.fetchClassName();
        }
        if (this._className == null) {
            return null;
        }
        ODatabaseDocumentInternal databaseRecord = this.getDatabaseIfDefined();
        if (databaseRecord != null) {
            return databaseRecord.getMetadata().getSchema().getClass(this._className);
        }
        return null;
    }

    @Override
    public String getClassName() {
        if (this._className == null) {
            this.fetchClassName();
        }
        return this._className;
    }

    @Override
    public void setClassName(String className) {
        this._immutableClazz = null;
        this._immutableSchemaVersion = -1;
        this._className = className;
        if (className == null) {
            return;
        }
        ODatabaseDocumentInternal db = this.getDatabaseIfDefined();
        if (db != null) {
            OMetadataInternal metadata = (OMetadataInternal)db.getMetadata();
            this._immutableClazz = (OImmutableClass)metadata.getImmutableSchemaSnapshot().getClass(className);
            OClass clazz = this._immutableClazz != null ? this._immutableClazz : metadata.getSchema().getOrCreateClass(className);
            if (clazz != null) {
                this._className = clazz.getName();
                this.convertFieldsToClass(clazz);
            }
        }
    }

    @Override
    public void validate() throws OValidationException {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        this.autoConvertValues();
        if (ODatabaseRecordThreadLocal.instance().isDefined() && !this.getDatabase().isValidationEnabled()) {
            return;
        }
        OImmutableClass immutableSchemaClass = this.getImmutableSchemaClass();
        if (immutableSchemaClass != null) {
            if (immutableSchemaClass.isStrictMode()) {
                for (String f : this.fieldNames()) {
                    if (immutableSchemaClass.getProperty(f) != null) continue;
                    throw new OValidationException("Found additional field '" + (String)f + "'. It cannot be added because the schema class '" + immutableSchemaClass.getName() + "' is defined as STRICT");
                }
            }
            for (OProperty p : immutableSchemaClass.properties()) {
                ODocument.validateField(this, (OImmutableProperty)p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String toString(Set<ORecord> inspected) {
        if (inspected.contains(this)) {
            return "<recursion:rid=" + (this._recordId != null ? this._recordId : "null") + ">";
        }
        inspected.add(this);
        boolean saveDirtyStatus = this._dirty;
        boolean oldUpdateContent = this._contentChanged;
        try {
            String clsName;
            StringBuilder buffer = new StringBuilder(128);
            this.checkForFields(new String[0]);
            ODatabaseDocumentInternal db = this.getDatabaseIfDefined();
            if (db != null && !db.isClosed() && (clsName = this.getClassName()) != null) {
                buffer.append(clsName);
            }
            if (this._recordId != null && this._recordId.isValid()) {
                buffer.append(this._recordId);
            }
            boolean first = true;
            for (Map.Entry<String, ODocumentEntry> f : this._fields.entrySet()) {
                buffer.append(first ? (char)'{' : ',');
                buffer.append(f.getKey());
                buffer.append(':');
                if (f.getValue().value == null) {
                    buffer.append("null");
                } else if (f.getValue().value instanceof Collection || f.getValue().value instanceof Map || f.getValue().value.getClass().isArray()) {
                    buffer.append('[');
                    buffer.append(OMultiValue.getSize(f.getValue().value));
                    buffer.append(']');
                } else if (f.getValue().value instanceof ORecord) {
                    ORecord record = (ORecord)f.getValue().value;
                    if (record.getIdentity().isValid()) {
                        record.getIdentity().toString(buffer);
                    } else if (record instanceof ODocument) {
                        buffer.append(((ODocument)record).toString(inspected));
                    } else {
                        buffer.append(record.toString());
                    }
                } else {
                    buffer.append(f.getValue().value);
                }
                if (!first) continue;
                first = false;
            }
            if (!first) {
                buffer.append('}');
            }
            if (this._recordId != null && this._recordId.isValid()) {
                buffer.append(" v");
                buffer.append(this._recordVersion);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            this._dirty = saveDirtyStatus;
            this._contentChanged = oldUpdateContent;
        }
    }

    protected ODocument mergeMap(Map<String, ODocumentEntry> iOther, boolean iUpdateOnlyMode, boolean iMergeSingleItemsOfMultiValueFields) {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        this._source = null;
        for (String f : iOther.keySet()) {
            ODocumentEntry docEntry = iOther.get(f);
            if (!docEntry.exist()) continue;
            Object otherValue = docEntry.value;
            ODocumentEntry curValue = this._fields.get(f);
            if (curValue != null && curValue.exist()) {
                Object value = curValue.value;
                if (iMergeSingleItemsOfMultiValueFields) {
                    boolean autoConvert = false;
                    if (otherValue instanceof OAutoConvertToRecord) {
                        autoConvert = ((OAutoConvertToRecord)otherValue).isAutoConvertToRecord();
                        ((OAutoConvertToRecord)otherValue).setAutoConvertToRecord(false);
                    }
                    if (value instanceof Map) {
                        Map map = (Map)value;
                        Map otherMap = (Map)otherValue;
                        for (Map.Entry entry : otherMap.entrySet()) {
                            map.put(entry.getKey(), entry.getValue());
                        }
                        if (!(otherValue instanceof OAutoConvertToRecord)) continue;
                        ((OAutoConvertToRecord)otherValue).setAutoConvertToRecord(autoConvert);
                        continue;
                    }
                    if (OMultiValue.isMultiValue(value) && !(value instanceof ORidBag)) {
                        for (Object item : OMultiValue.getMultiValueIterable(otherValue)) {
                            if (OMultiValue.contains(value, item)) continue;
                            OMultiValue.add(value, item);
                        }
                        if (!(otherValue instanceof OAutoConvertToRecord)) continue;
                        ((OAutoConvertToRecord)otherValue).setAutoConvertToRecord(autoConvert);
                        continue;
                    }
                }
                boolean bagsMerged = false;
                if (value instanceof ORidBag && otherValue instanceof ORidBag) {
                    bagsMerged = ((ORidBag)value).tryMerge((ORidBag)otherValue, iMergeSingleItemsOfMultiValueFields);
                }
                if ((bagsMerged || value == null || value.equals(otherValue)) && (value != null || otherValue == null)) continue;
                this.setProperty(f, otherValue);
                continue;
            }
            this.setProperty(f, otherValue);
        }
        if (!iUpdateOnlyMode) {
            for (String f : this.fieldNames()) {
                if (iOther.containsKey(f) && iOther.get(f).exist()) continue;
                this.removeField(f);
            }
        }
        return this;
    }

    @Override
    protected ORecordAbstract fill(ORID iRid, int iVersion, byte[] iBuffer, boolean iDirty) {
        this._schema = null;
        this.fetchSchemaIfCan();
        return super.fill(iRid, iVersion, iBuffer, iDirty);
    }

    @Override
    protected ORecordAbstract fill(ORID iRid, int iVersion, byte[] iBuffer, boolean iDirty, ODatabaseDocumentInternal db) {
        this._schema = null;
        this.fetchSchemaIfCan(db);
        return super.fill(iRid, iVersion, iBuffer, iDirty, db);
    }

    @Override
    protected void clearSource() {
        super.clearSource();
        this._schema = null;
    }

    protected OGlobalProperty getGlobalPropertyById(int id) {
        OGlobalProperty prop;
        if (this._schema == null) {
            OMetadataInternal metadata = this.getDatabase().getMetadata();
            this._schema = metadata.getImmutableSchemaSnapshot();
        }
        if ((prop = this._schema.getGlobalPropertyById(id)) == null) {
            ODatabaseDocumentInternal db = this.getDatabase();
            if (db == null || db.isClosed()) {
                throw new ODatabaseException("Cannot unmarshall the document because no database is active, use detach for use the document outside the database session scope");
            }
            OMetadataInternal metadata = (OMetadataInternal)db.getMetadata();
            if (metadata.getImmutableSchemaSnapshot() != null) {
                metadata.clearThreadLocalSchemaSnapshot();
            }
            metadata.reload();
            metadata.makeThreadLocalSchemaSnapshot();
            this._schema = metadata.getImmutableSchemaSnapshot();
            prop = this._schema.getGlobalPropertyById(id);
        }
        return prop;
    }

    protected void fillClassIfNeed(String iClassName) {
        if (this._className == null) {
            this._immutableClazz = null;
            this._immutableSchemaVersion = -1;
            this._className = iClassName;
        }
    }

    protected OImmutableClass getImmutableSchemaClass() {
        return this.getImmutableSchemaClass(null);
    }

    protected OImmutableClass getImmutableSchemaClass(ODatabaseDocumentInternal database) {
        if (this._immutableClazz == null) {
            if (this._className == null) {
                this.fetchClassName();
            }
            if (this._className != null) {
                if (database == null) {
                    database = this.getDatabaseIfDefined();
                }
                if (database != null && !database.isClosed()) {
                    OImmutableSchema immutableSchema = database.getMetadata().getImmutableSchemaSnapshot();
                    if (immutableSchema == null) {
                        return null;
                    }
                    this._immutableSchemaVersion = immutableSchema.getVersion();
                    this._immutableClazz = (OImmutableClass)immutableSchema.getClass(this._className);
                }
            }
        }
        return this._immutableClazz;
    }

    protected void rawField(String iFieldName, Object iFieldValue, OType iFieldType) {
        if (this._fields == null) {
            this._fields = this._ordered ? new LinkedHashMap() : new HashMap();
        }
        ODocumentEntry entry = this.getOrCreate(iFieldName);
        this.removeCollectionChangeListener(entry, entry.value);
        entry.value = iFieldValue;
        entry.type = iFieldType;
        this.addCollectionChangeListener(entry);
        if (iFieldValue instanceof OIdentifiable && !((OIdentifiable)iFieldValue).getIdentity().isPersistent()) {
            this.track((OIdentifiable)iFieldValue);
        }
    }

    protected ODocumentEntry getOrCreate(String key) {
        ODocumentEntry entry = this._fields.get(key);
        if (entry == null) {
            entry = new ODocumentEntry();
            ++this._fieldSize;
            this._fields.put(key, entry);
        }
        return entry;
    }

    protected boolean rawContainsField(String iFiledName) {
        return this._fields != null && this._fields.containsKey(iFiledName);
    }

    protected void autoConvertValues() {
        OImmutableClass clazz = this.getImmutableSchemaClass();
        if (clazz != null) {
            for (OProperty prop : clazz.properties()) {
                Object value;
                OType type = prop.getType();
                OType linkedType = prop.getLinkedType();
                OClass linkedClass = prop.getLinkedClass();
                if (type == OType.EMBEDDED && linkedClass != null) {
                    this.convertToEmbeddedType(prop);
                    continue;
                }
                ODocumentEntry entry = this._fields.get(prop.getName());
                if (entry == null || !entry.created && !entry.changed || (value = entry.value) == null) continue;
                try {
                    Object values;
                    OTrackedMap map;
                    if (type == OType.LINKBAG && entry.value != null && !(entry.value instanceof ORidBag) && entry.value instanceof Collection) {
                        ORidBag newValue = new ORidBag();
                        for (Object o : (Collection)entry.value) {
                            if (!(o instanceof OIdentifiable)) {
                                throw new OValidationException("Invalid value in ridbag: " + o);
                            }
                            newValue.add((OIdentifiable)o);
                        }
                        entry.value = newValue;
                    }
                    if (type == OType.LINKMAP && entry.value instanceof Map) {
                        map = (OTrackedMap)entry.value;
                        ORecordLazyMap newMap = new ORecordLazyMap(this);
                        boolean changed = false;
                        for (Map.Entry stringObjectEntry : map.entrySet()) {
                            Object val = stringObjectEntry.getValue();
                            if (OMultiValue.isMultiValue(val) && OMultiValue.getSize(val) == 1) {
                                if ((val = OMultiValue.getFirstValue(val)) instanceof OResult) {
                                    val = ((OResult)val).getIdentity().orElse(null);
                                }
                                changed = true;
                            }
                            newMap.put(stringObjectEntry.getKey(), val);
                        }
                        if (changed) {
                            entry.value = newMap;
                        }
                    }
                    if (linkedType == null) continue;
                    if (type == OType.EMBEDDEDLIST) {
                        OTrackedList<Object> list = new OTrackedList<Object>(this);
                        values = (Collection)value;
                        Iterator iterator = values.iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            list.add(OType.convert(e, linkedType.getDefaultJavaType()));
                        }
                        entry.value = list;
                        this.replaceListenerOnAutoconvert(entry, value);
                        continue;
                    }
                    if (type == OType.EMBEDDEDMAP) {
                        map = new OTrackedMap(this);
                        values = (Map)value;
                        for (Map.Entry entry2 : values.entrySet()) {
                            map.put(entry2.getKey(), OType.convert(entry2.getValue(), linkedType.getDefaultJavaType()));
                        }
                        entry.value = map;
                        this.replaceListenerOnAutoconvert(entry, value);
                        continue;
                    }
                    if (type != OType.EMBEDDEDSET) continue;
                    OTrackedSet set = new OTrackedSet(this);
                    values = (Collection)value;
                    Iterator iterator = values.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        set.add(OType.convert(e, linkedType.getDefaultJavaType()));
                    }
                    entry.value = set;
                    this.replaceListenerOnAutoconvert(entry, value);
                }
                catch (Exception e) {
                    throw OException.wrapException(new OValidationException("impossible to convert value of field \"" + prop.getName() + "\""), e);
                }
            }
        }
    }

    private void convertToEmbeddedType(OProperty prop) {
        block10: {
            ODocumentEntry entry = this._fields.get(prop.getName());
            OClass linkedClass = prop.getLinkedClass();
            if (entry == null || linkedClass == null) {
                return;
            }
            if (!entry.created && !entry.changed) {
                return;
            }
            Object value = entry.value;
            if (value == null) {
                return;
            }
            try {
                if (value instanceof ODocument) {
                    OClass docClass = ((ODocument)value).getSchemaClass();
                    if (docClass == null) {
                        ((ODocument)value).setClass(linkedClass);
                    } else if (!docClass.isSubClassOf(linkedClass)) {
                        throw new OValidationException("impossible to convert value of field \"" + prop.getName() + "\", incompatible with " + linkedClass);
                    }
                    break block10;
                }
                if (value instanceof Map) {
                    this.removeCollectionChangeListener(entry, value);
                    ODocument newValue = new ODocument(linkedClass);
                    newValue.fromMap((Map)value);
                    entry.value = newValue;
                    newValue.addOwner(this);
                    break block10;
                }
                throw new OValidationException("impossible to convert value of field \"" + prop.getName() + "\"");
            }
            catch (Exception e) {
                throw OException.wrapException(new OValidationException("impossible to convert value of field \"" + prop.getName() + "\""), e);
            }
        }
    }

    private void replaceListenerOnAutoconvert(ODocumentEntry entry, Object oldValue) {
        if (entry.changeListener != null) {
            OTrackedMultiValue oldMultiValue = (OTrackedMultiValue)oldValue;
            oldMultiValue.removeRecordChangeListener(entry.changeListener);
            ((OTrackedMultiValue)entry.value).addChangeListener(entry.changeListener);
        } else {
            OSimpleMultiValueChangeListener listener = new OSimpleMultiValueChangeListener(this, entry);
            ((OTrackedMultiValue)entry.value).addChangeListener(listener);
            entry.changeListener = listener;
        }
    }

    protected byte[] toStream(boolean iOnlyDelta) {
        ORecordElement.STATUS prev = this._status;
        this._status = ORecordElement.STATUS.MARSHALLING;
        try {
            if (this._source == null) {
                this._source = this._recordFormat.toStream(this, iOnlyDelta);
            }
        }
        finally {
            this._status = prev;
        }
        this.invokeListenerEvent(ORecordListener.EVENT.MARSHALL);
        return this._source;
    }

    @Override
    protected byte getRecordType() {
        return 100;
    }

    protected void addOwner(ORecordElement iOwner) {
        if (iOwner == null) {
            return;
        }
        if (this._owners == null) {
            this._owners = new ArrayList<WeakReference<ORecordElement>>();
            if (this._dirtyManager != null && this.getIdentity().isNew()) {
                this._dirtyManager.removeNew(this);
            }
        }
        boolean found = false;
        Iterator<WeakReference<ORecordElement>> ref = this._owners.iterator();
        while (ref.hasNext()) {
            ORecordElement e = (ORecordElement)ref.next().get();
            if (e == iOwner) {
                found = true;
                break;
            }
            if (e != null) continue;
            ref.remove();
        }
        if (!found) {
            this._owners.add(new WeakReference<ORecordElement>(iOwner));
        }
    }

    protected void removeOwner(ORecordElement iRecordElement) {
        if (this._owners != null) {
            for (int i = 0; i < this._owners.size(); ++i) {
                ORecordElement e = (ORecordElement)this._owners.get(i).get();
                if (e != iRecordElement) continue;
                this._owners.remove(i);
                break;
            }
        }
    }

    protected void convertAllMultiValuesToTrackedVersions() {
        if (this._fields == null) {
            return;
        }
        for (Map.Entry<String, ODocumentEntry> fieldEntry : this._fields.entrySet()) {
            OImmutableClass _clazz;
            Object fieldValue = fieldEntry.getValue().value;
            if (fieldValue instanceof ORidBag) {
                ((ORidBag)fieldValue).checkAndConvert();
            }
            if (!(fieldValue instanceof Collection) && !(fieldValue instanceof Map) && !(fieldValue instanceof ODocument)) continue;
            if (this.addCollectionChangeListener(fieldEntry.getValue())) {
                if (fieldEntry.getValue().timeLine == null || fieldEntry.getValue().timeLine.getMultiValueChangeEvents().isEmpty()) continue;
                this.checkTimelineTrackable(fieldEntry.getValue().timeLine, (OTrackedMultiValue)fieldEntry.getValue().value);
                continue;
            }
            if (fieldValue instanceof ODocument && ((ODocument)fieldValue).isEmbedded()) {
                ((ODocument)fieldValue).convertAllMultiValuesToTrackedVersions();
                continue;
            }
            OType fieldType = fieldEntry.getValue().type;
            if (fieldType == null && (_clazz = this.getImmutableSchemaClass()) != null) {
                OProperty prop = _clazz.getProperty(fieldEntry.getKey());
                OType oType = fieldType = prop != null ? prop.getType() : null;
            }
            if (fieldType == null) {
                fieldType = OType.getTypeByValue(fieldValue);
            }
            ORecordLazyMultiValue newValue = null;
            switch (fieldType) {
                case EMBEDDEDLIST: {
                    if (!(fieldValue instanceof List)) break;
                    newValue = new OTrackedList(this);
                    this.fillTrackedCollection((Collection<Object>)((Object)newValue), (Collection)fieldValue);
                    break;
                }
                case EMBEDDEDSET: {
                    if (!(fieldValue instanceof Set)) break;
                    newValue = new OTrackedSet(this);
                    this.fillTrackedCollection((Collection<Object>)((Object)newValue), (Collection)fieldValue);
                    break;
                }
                case EMBEDDEDMAP: {
                    if (!(fieldValue instanceof Map)) break;
                    newValue = new OTrackedMap(this);
                    this.fillTrackedMap((Map)((Object)newValue), (Map)fieldValue);
                    break;
                }
                case LINKLIST: {
                    if (!(fieldValue instanceof List)) break;
                    newValue = new ORecordLazyList(this, (Collection)fieldValue);
                    break;
                }
                case LINKSET: {
                    if (!(fieldValue instanceof Set)) break;
                    newValue = new ORecordLazySet(this, (Collection)fieldValue);
                    break;
                }
                case LINKMAP: {
                    if (!(fieldValue instanceof Map)) break;
                    newValue = new ORecordLazyMap(this, (Map)fieldValue);
                    break;
                }
                case LINKBAG: {
                    if (!(fieldValue instanceof Collection)) break;
                    ORidBag bag = new ORidBag();
                    bag.setOwner(this);
                    bag.addAll((Collection)fieldValue);
                    newValue = bag;
                    break;
                }
            }
            if (newValue == null) continue;
            this.addCollectionChangeListener(fieldEntry.getValue());
            fieldEntry.getValue().value = newValue;
            if (fieldType == OType.LINKSET || fieldType == OType.LINKLIST) {
                boolean pre = ((OAutoConvertToRecord)newValue).isAutoConvertToRecord();
                ((OAutoConvertToRecord)newValue).setAutoConvertToRecord(false);
                for (OIdentifiable rec : (Collection)((Object)newValue)) {
                    if (!(rec instanceof ODocument)) continue;
                    ((ODocument)rec).convertAllMultiValuesToTrackedVersions();
                }
                ((OAutoConvertToRecord)newValue).setAutoConvertToRecord(pre);
                continue;
            }
            if (fieldType != OType.LINKMAP) continue;
            boolean pre = ((OAutoConvertToRecord)newValue).isAutoConvertToRecord();
            ((OAutoConvertToRecord)newValue).setAutoConvertToRecord(false);
            for (OIdentifiable rec : ((Map)((Object)newValue)).values()) {
                if (!(rec instanceof ODocument)) continue;
                ((ODocument)rec).convertAllMultiValuesToTrackedVersions();
            }
            ((OAutoConvertToRecord)newValue).setAutoConvertToRecord(pre);
        }
    }

    private void checkTimelineTrackable(OMultiValueChangeTimeLine<Object, Object> timeLine, OTrackedMultiValue origin) {
        List<OMultiValueChangeEvent<Object, Object>> events = timeLine.getMultiValueChangeEvents();
        for (OMultiValueChangeEvent<Object, Object> event : events) {
            OMultiValueChangeTimeLine nestedTimeline;
            Object value = event.getValue();
            if (event.getChangeType() == OMultiValueChangeEvent.OChangeType.ADD && !(value instanceof OTrackedMultiValue)) {
                if (value instanceof Collection) {
                    OTrackedList<Object> newCollection = value instanceof List ? new OTrackedList(this) : new OTrackedSet(this);
                    this.fillTrackedCollection(newCollection, (Collection)value);
                    origin.replace(event, newCollection);
                    continue;
                }
                if (!(value instanceof Map)) continue;
                OTrackedMap<Object> newMap = new OTrackedMap<Object>(this);
                this.fillTrackedMap(newMap, (Map)value);
                origin.replace(event, newMap);
                continue;
            }
            if (event.getChangeType() != OMultiValueChangeEvent.OChangeType.NESTED || (nestedTimeline = ((ONestedMultiValueChangeEvent)event).getTimeLine()) == null) continue;
            this.checkTimelineTrackable(nestedTimeline, (OTrackedMultiValue)value);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fillTrackedCollection(Collection<Object> dest, Collection<Object> source) {
        for (Object object : source) {
            void var4_4;
            if (object instanceof ODocument) {
                ((ODocument)object).convertAllMultiValuesToTrackedVersions();
            } else if (object instanceof List) {
                OTrackedList<Object> newList = new OTrackedList<Object>(this);
                this.fillTrackedCollection(newList, (Collection)object);
                OTrackedList<Object> oTrackedList = newList;
            } else if (object instanceof Set) {
                OTrackedSet<Object> newSet = new OTrackedSet<Object>(this);
                this.fillTrackedCollection(newSet, (Collection)object);
                OTrackedSet<Object> oTrackedSet = newSet;
            } else if (object instanceof Map) {
                OTrackedMap<Object> newMap = new OTrackedMap<Object>(this);
                this.fillTrackedMap(newMap, (Map)object);
                OTrackedMap<Object> oTrackedMap = newMap;
            }
            dest.add(var4_4);
        }
    }

    private void fillTrackedMap(Map<Object, Object> dest, Map<Object, Object> source) {
        for (Map.Entry<Object, Object> cur : source.entrySet()) {
            Cloneable value = cur.getValue();
            if (value instanceof ODocument) {
                ((ODocument)((Object)value)).convertAllMultiValuesToTrackedVersions();
            } else if (cur.getValue() instanceof List) {
                OTrackedList<Object> newList = new OTrackedList<Object>(this);
                this.fillTrackedCollection(newList, (Collection<Object>)((Object)value));
                value = newList;
            } else if (value instanceof Set) {
                OTrackedSet<Object> newSet = new OTrackedSet<Object>(this);
                this.fillTrackedCollection(newSet, (Collection<Object>)((Object)value));
                value = newSet;
            } else if (value instanceof Map) {
                OTrackedMap<Object> newMap = new OTrackedMap<Object>(this);
                this.fillTrackedMap(newMap, (Map)((Object)value));
                value = newMap;
            }
            dest.put(cur.getKey(), value);
        }
    }

    protected void internalReset() {
        this.removeAllCollectionChangeListeners();
        if (this._fields != null) {
            this._fields.clear();
        }
        this._fieldSize = 0;
    }

    protected boolean checkForFields(String ... iFields) {
        if (this._fields == null) {
            Map<Object, Object> map = this._fields = this._ordered ? new LinkedHashMap() : new HashMap();
        }
        if (this._status == ORecordElement.STATUS.LOADED && this._source != null) {
            return this.deserializeFields(iFields);
        }
        return true;
    }

    @Override
    protected void setup() {
        super.setup();
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (db != null) {
            this._recordFormat = db.getSerializer();
        }
        if (this._recordFormat == null) {
            this._recordFormat = ODatabaseDocumentTx.getDefaultSerializer();
        }
    }

    protected String checkFieldName(String iFieldName) {
        Character c = OSchemaShared.checkFieldNameIfValid(iFieldName);
        if (c != null) {
            throw new IllegalArgumentException("Invalid field name '" + iFieldName + "'. Character '" + c + "' is invalid");
        }
        return iFieldName;
    }

    protected void setClass(OClass iClass) {
        if (iClass != null && iClass.isAbstract()) {
            throw new OSchemaException("Cannot create a document of the abstract class '" + iClass + "'");
        }
        this._className = iClass == null ? null : iClass.getName();
        this._immutableClazz = null;
        this._immutableSchemaVersion = -1;
        if (iClass != null) {
            this.convertFieldsToClass(iClass);
        }
    }

    protected Set<Map.Entry<String, ODocumentEntry>> getRawEntries() {
        this.checkForFields(new String[0]);
        return this._fields == null ? new HashSet() : this._fields.entrySet();
    }

    private void fetchSchemaIfCan() {
        ODatabaseDocumentInternal db;
        if (this._schema == null && (db = ODatabaseRecordThreadLocal.instance().getIfDefined()) != null && !db.isClosed()) {
            OMetadataInternal metadata = db.getMetadata();
            this._schema = metadata.getImmutableSchemaSnapshot();
        }
    }

    private void fetchSchemaIfCan(ODatabaseDocumentInternal db) {
        if (this._schema == null && db != null && !db.isClosed()) {
            OMetadataInternal metadata = db.getMetadata();
            this._schema = metadata.getImmutableSchemaSnapshot();
        }
    }

    private void fetchClassName() {
        ODatabaseDocumentInternal database = this.getDatabaseIfDefinedInternal();
        if (database != null && database.getStorageVersions() != null) {
            if (this._recordId.getClusterId() < 0) {
                this.checkForLoading();
                this.checkForFields("@class");
            } else {
                OClass _clazz;
                OImmutableSchema schema = database.getMetadata().getImmutableSchemaSnapshot();
                if (schema != null && (_clazz = schema.getClassByClusterId(this._recordId.getClusterId())) != null) {
                    this._className = _clazz.getName();
                }
            }
        } else {
            this.checkForLoading();
            this.checkForFields("@class");
        }
    }

    protected void autoConvertFieldsToClass(ODatabaseDocumentInternal database) {
        OClass klazz;
        if (this._className != null && (klazz = database.getMetadata().getImmutableSchemaSnapshot().getClass(this._className)) != null) {
            this.convertFieldsToClass(klazz);
        }
    }

    private void convertFieldsToClass(OClass _clazz) {
        for (OProperty prop : _clazz.properties()) {
            ODocumentEntry entry;
            ODocumentEntry oDocumentEntry = entry = this._fields != null ? this._fields.get(prop.getName()) : null;
            if (entry != null && entry.exist()) {
                if (entry.type != null && entry.type == prop.getType()) continue;
                boolean preChanged = entry.changed;
                boolean preCreated = entry.created;
                this.field(prop.getName(), entry.value, prop.getType());
                if (!this._recordId.isNew()) continue;
                entry.changed = preChanged;
                entry.created = preCreated;
                continue;
            }
            String defValue = prop.getDefaultValue();
            if (defValue == null || this.containsField(prop.getName())) continue;
            Object curFieldValue = OSQLHelper.parseDefaultValue(this, defValue);
            Object fieldValue = ODocumentHelper.convertField(this, prop.getName(), prop.getType(), null, curFieldValue);
            this.rawField(prop.getName(), fieldValue, prop.getType());
        }
    }

    private OType deriveFieldType(String iFieldName, ODocumentEntry entry, OType[] iFieldType) {
        OProperty prop;
        OType fieldType;
        if (iFieldType != null && iFieldType.length == 1) {
            entry.type = iFieldType[0];
            fieldType = iFieldType[0];
        } else {
            fieldType = null;
        }
        OImmutableClass _clazz = this.getImmutableSchemaClass();
        if (_clazz != null && (prop = _clazz.getProperty(iFieldName)) != null) {
            entry.property = prop;
            fieldType = prop.getType();
            if (fieldType != OType.ANY) {
                entry.type = fieldType;
            }
        }
        return fieldType;
    }

    private boolean addCollectionChangeListener(ODocumentEntry entry) {
        if (!(entry.value instanceof OTrackedMultiValue)) {
            return false;
        }
        if (entry.changeListener == null) {
            OSimpleMultiValueChangeListener listener = new OSimpleMultiValueChangeListener(this, entry);
            ((OTrackedMultiValue)entry.value).addChangeListener(listener);
            entry.changeListener = listener;
        }
        return true;
    }

    private void removeAllCollectionChangeListeners() {
        if (this._fields == null) {
            return;
        }
        for (Map.Entry<String, ODocumentEntry> field : this._fields.entrySet()) {
            this.removeCollectionChangeListener(field.getValue(), field.getValue().value);
        }
    }

    private void addAllMultiValueChangeListeners() {
        if (this._fields == null) {
            return;
        }
        for (Map.Entry<String, ODocumentEntry> field : this._fields.entrySet()) {
            this.addCollectionChangeListener(field.getValue());
        }
    }

    private void removeCollectionChangeListener(ODocumentEntry entry, Object fieldValue) {
        if (entry != null && entry.changeListener != null) {
            OSimpleMultiValueChangeListener<Object, Object> changeListener = entry.changeListener;
            entry.changeListener = null;
            entry.timeLine = null;
            if (!(fieldValue instanceof OTrackedMultiValue)) {
                return;
            }
            OTrackedMultiValue multiValue = (OTrackedMultiValue)fieldValue;
            multiValue.removeRecordChangeListener(changeListener);
        }
    }

    protected void checkClass(ODatabaseDocumentInternal database) {
        OImmutableSchema immutableSchema;
        if (this._className == null) {
            this.fetchClassName();
        }
        if ((immutableSchema = database.getMetadata().getImmutableSchemaSnapshot()) == null) {
            return;
        }
        if (this._immutableClazz == null) {
            this._immutableSchemaVersion = immutableSchema.getVersion();
            this._immutableClazz = (OImmutableClass)immutableSchema.getClass(this._className);
        } else if (this._immutableSchemaVersion < immutableSchema.getVersion()) {
            this._immutableSchemaVersion = immutableSchema.getVersion();
            this._immutableClazz = (OImmutableClass)immutableSchema.getClass(this._className);
        }
    }

    @Override
    protected void track(OIdentifiable id) {
        if (this.isTrackingChanges() && id.getIdentity().getClusterId() != -2) {
            super.track(id);
        }
    }

    @Override
    protected void unTrack(OIdentifiable id) {
        if (this.isTrackingChanges() && id.getIdentity().getClusterId() != -2) {
            super.unTrack(id);
        }
    }
}

