/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OAndBlock;
import com.orientechnologies.orient.core.sql.parser.OBetweenCondition;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OBinaryCondition;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OCollection;
import com.orientechnologies.orient.core.sql.parser.OEqualsCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OGeOperator;
import com.orientechnologies.orient.core.sql.parser.OGtOperator;
import com.orientechnologies.orient.core.sql.parser.OLeOperator;
import com.orientechnologies.orient.core.sql.parser.OLtOperator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DeleteFromIndexStep
extends AbstractExecutionStep {
    protected final OIndex index;
    private final OBinaryCondition additional;
    private final OBooleanExpression ridCondition;
    private final boolean orderAsc;
    Map.Entry<Object, OIdentifiable> nextEntry = null;
    OBooleanExpression condition;
    private boolean inited = false;
    private OIndexCursor cursor;
    private long cost = 0L;

    public DeleteFromIndexStep(OIndex<?> index, OBooleanExpression condition, OBinaryCondition additionalRangeCondition, OBooleanExpression ridCondition, OCommandContext ctx, boolean profilingEnabled) {
        this(index, condition, additionalRangeCondition, ridCondition, true, ctx, profilingEnabled);
    }

    public DeleteFromIndexStep(OIndex<?> index, OBooleanExpression condition, OBinaryCondition additionalRangeCondition, OBooleanExpression ridCondition, boolean orderAsc, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.index = index;
        this.condition = condition;
        this.additional = additionalRangeCondition;
        this.ridCondition = ridCondition;
        this.orderAsc = orderAsc;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        this.init();
        return new OResultSet(){
            int localCount = 0;

            @Override
            public boolean hasNext() {
                return this.localCount < nRecords && DeleteFromIndexStep.this.nextEntry != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                long begin = DeleteFromIndexStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    if (!this.hasNext()) {
                        throw new IllegalStateException();
                    }
                    Map.Entry<Object, OIdentifiable> entry = DeleteFromIndexStep.this.nextEntry;
                    OResultInternal result = new OResultInternal();
                    OIdentifiable value = entry.getValue();
                    DeleteFromIndexStep.this.index.remove(entry.getKey(), value);
                    ++this.localCount;
                    DeleteFromIndexStep.this.nextEntry = DeleteFromIndexStep.this.loadNextEntry(ctx);
                    OResultInternal oResultInternal = result;
                    return oResultInternal;
                }
                finally {
                    if (DeleteFromIndexStep.this.profilingEnabled) {
                        DeleteFromIndexStep.this.cost = DeleteFromIndexStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private synchronized void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        long begin = this.profilingEnabled ? System.nanoTime() : 0L;
        try {
            this.init(this.condition);
            this.nextEntry = this.loadNextEntry(this.ctx);
        }
        finally {
            if (this.profilingEnabled) {
                this.cost += System.nanoTime() - begin;
            }
        }
    }

    private Map.Entry<Object, OIdentifiable> loadNextEntry(OCommandContext commandContext) {
        Map.Entry<Object, OIdentifiable> result = this.cursor.nextEntry();
        while (result != null) {
            if (this.ridCondition == null) {
                return result;
            }
            OResultInternal res = new OResultInternal();
            res.setProperty("rid", result.getValue());
            if (this.ridCondition.evaluate(res, commandContext)) {
                return result;
            }
            result = this.cursor.nextEntry();
        }
        return null;
    }

    private void init(OBooleanExpression condition) {
        if (this.index.getDefinition() == null) {
            return;
        }
        if (condition == null) {
            this.processFlatIteration();
        } else if (condition instanceof OBinaryCondition) {
            this.processBinaryCondition();
        } else if (condition instanceof OBetweenCondition) {
            this.processBetweenCondition();
        } else if (condition instanceof OAndBlock) {
            this.processAndBlock();
        } else {
            throw new OCommandExecutionException("search for index for " + condition + " is not supported yet");
        }
    }

    private void processAndBlock() {
        OCollection fromKey = this.indexKeyFrom((OAndBlock)this.condition, this.additional);
        OCollection toKey = this.indexKeyTo((OAndBlock)this.condition, this.additional);
        boolean fromKeyIncluded = this.indexKeyFromIncluded((OAndBlock)this.condition, this.additional);
        boolean toKeyIncluded = this.indexKeyToIncluded((OAndBlock)this.condition, this.additional);
        this.init(fromKey, fromKeyIncluded, toKey, toKeyIncluded);
    }

    private void processFlatIteration() {
        this.cursor = this.isOrderAsc() ? this.index.cursor() : this.index.descCursor();
    }

    private void init(OCollection fromKey, boolean fromKeyIncluded, OCollection toKey, boolean toKeyIncluded) {
        Object secondValue = fromKey.execute((OResult)null, this.ctx);
        Object thirdValue = toKey.execute((OResult)null, this.ctx);
        OIndexDefinition indexDef = this.index.getDefinition();
        if (this.index.supportsOrderedIterations()) {
            this.cursor = this.index.iterateEntriesBetween(this.toBetweenIndexKey(indexDef, secondValue), fromKeyIncluded, this.toBetweenIndexKey(indexDef, thirdValue), toKeyIncluded, this.isOrderAsc());
        } else if (this.additional == null && this.allEqualities((OAndBlock)this.condition)) {
            this.cursor = this.index.iterateEntries(this.toIndexKey(indexDef, secondValue), this.isOrderAsc());
        } else {
            throw new UnsupportedOperationException("Cannot evaluate " + this.condition + " on index " + this.index);
        }
    }

    private boolean allEqualities(OAndBlock condition) {
        if (condition == null) {
            return false;
        }
        for (OBooleanExpression exp : condition.getSubBlocks()) {
            if (exp instanceof OBinaryCondition) {
                if (!(((OBinaryCondition)exp).getOperator() instanceof OEqualsCompareOperator)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void processBetweenCondition() {
        OIndexDefinition definition = this.index.getDefinition();
        OExpression key = ((OBetweenCondition)this.condition).getFirst();
        if (!key.toString().equalsIgnoreCase("key")) {
            throw new OCommandExecutionException("search for index for " + this.condition + " is not supported yet");
        }
        OExpression second = ((OBetweenCondition)this.condition).getSecond();
        OExpression third = ((OBetweenCondition)this.condition).getThird();
        Object secondValue = second.execute((OResult)null, this.ctx);
        Object thirdValue = third.execute((OResult)null, this.ctx);
        this.cursor = this.index.iterateEntriesBetween(this.toBetweenIndexKey(definition, secondValue), true, this.toBetweenIndexKey(definition, thirdValue), true, this.isOrderAsc());
    }

    private void processBinaryCondition() {
        OIndexDefinition definition = this.index.getDefinition();
        OBinaryCompareOperator operator = ((OBinaryCondition)this.condition).getOperator();
        OExpression left = ((OBinaryCondition)this.condition).getLeft();
        if (!left.toString().equalsIgnoreCase("key")) {
            throw new OCommandExecutionException("search for index for " + this.condition + " is not supported yet");
        }
        Object rightValue = ((OBinaryCondition)this.condition).getRight().execute((OResult)null, this.ctx);
        this.cursor = this.createCursor(operator, definition, rightValue, this.ctx);
    }

    private Collection toIndexKey(OIndexDefinition definition, Object rightValue) {
        if (definition.getFields().size() == 1 && rightValue instanceof Collection) {
            rightValue = ((Collection)rightValue).iterator().next();
        }
        if (!((rightValue = rightValue instanceof List ? definition.createValue((List)rightValue) : definition.createValue(rightValue)) instanceof Collection)) {
            rightValue = Collections.singleton(rightValue);
        }
        return (Collection)rightValue;
    }

    private Object toBetweenIndexKey(OIndexDefinition definition, Object rightValue) {
        if (definition.getFields().size() == 1 && rightValue instanceof Collection) {
            rightValue = ((Collection)rightValue).iterator().next();
        }
        rightValue = definition.createValue(rightValue);
        if (definition.getFields().size() > 1 && !(rightValue instanceof Collection)) {
            rightValue = Collections.singleton(rightValue);
        }
        return rightValue;
    }

    private OIndexCursor createCursor(OBinaryCompareOperator operator, OIndexDefinition definition, Object value, OCommandContext ctx) {
        boolean orderAsc = this.isOrderAsc();
        if (operator instanceof OEqualsCompareOperator) {
            return this.index.iterateEntries(this.toIndexKey(definition, value), orderAsc);
        }
        if (operator instanceof OGeOperator) {
            return this.index.iterateEntriesMajor(value, true, orderAsc);
        }
        if (operator instanceof OGtOperator) {
            return this.index.iterateEntriesMajor(value, false, orderAsc);
        }
        if (operator instanceof OLeOperator) {
            return this.index.iterateEntriesMinor(value, true, orderAsc);
        }
        if (operator instanceof OLtOperator) {
            return this.index.iterateEntriesMinor(value, false, orderAsc);
        }
        throw new OCommandExecutionException("search for index for " + this.condition + " is not supported yet");
    }

    protected boolean isOrderAsc() {
        return this.orderAsc;
    }

    private OCollection indexKeyFrom(OAndBlock keyCondition, OBinaryCondition additional) {
        OCollection result = new OCollection(-1);
        for (OBooleanExpression exp : keyCondition.getSubBlocks()) {
            if (exp instanceof OBinaryCondition) {
                OBinaryCondition binaryCond = (OBinaryCondition)exp;
                OBinaryCompareOperator operator = binaryCond.getOperator();
                if (operator instanceof OEqualsCompareOperator || operator instanceof OGtOperator || operator instanceof OGeOperator) {
                    result.add(binaryCond.getRight());
                    continue;
                }
                if (additional == null) continue;
                result.add(additional.getRight());
                continue;
            }
            throw new UnsupportedOperationException("Cannot execute index query with " + exp);
        }
        return result;
    }

    private OCollection indexKeyTo(OAndBlock keyCondition, OBinaryCondition additional) {
        OCollection result = new OCollection(-1);
        for (OBooleanExpression exp : keyCondition.getSubBlocks()) {
            if (exp instanceof OBinaryCondition) {
                OBinaryCondition binaryCond = (OBinaryCondition)exp;
                OBinaryCompareOperator operator = binaryCond.getOperator();
                if (operator instanceof OEqualsCompareOperator || operator instanceof OLtOperator || operator instanceof OLeOperator) {
                    result.add(binaryCond.getRight());
                    continue;
                }
                if (additional == null) continue;
                result.add(additional.getRight());
                continue;
            }
            throw new UnsupportedOperationException("Cannot execute index query with " + exp);
        }
        return result;
    }

    private boolean indexKeyFromIncluded(OAndBlock keyCondition, OBinaryCondition additional) {
        OBooleanExpression exp = keyCondition.getSubBlocks().get(keyCondition.getSubBlocks().size() - 1);
        if (exp instanceof OBinaryCondition) {
            OBinaryCompareOperator additionalOperator;
            OBinaryCompareOperator operator = ((OBinaryCondition)exp).getOperator();
            OBinaryCompareOperator oBinaryCompareOperator = additionalOperator = additional == null ? null : additional.getOperator();
            if (this.isGreaterOperator(operator)) {
                return this.isIncludeOperator(operator);
            }
            return additionalOperator == null || this.isIncludeOperator(additionalOperator) && this.isGreaterOperator(additionalOperator);
        }
        throw new UnsupportedOperationException("Cannot execute index query with " + exp);
    }

    private boolean isGreaterOperator(OBinaryCompareOperator operator) {
        if (operator == null) {
            return false;
        }
        return operator instanceof OGeOperator || operator instanceof OGtOperator;
    }

    private boolean isLessOperator(OBinaryCompareOperator operator) {
        if (operator == null) {
            return false;
        }
        return operator instanceof OLeOperator || operator instanceof OLtOperator;
    }

    private boolean isIncludeOperator(OBinaryCompareOperator operator) {
        if (operator == null) {
            return false;
        }
        return operator instanceof OGeOperator || operator instanceof OLeOperator;
    }

    private boolean indexKeyToIncluded(OAndBlock keyCondition, OBinaryCondition additional) {
        OBooleanExpression exp = keyCondition.getSubBlocks().get(keyCondition.getSubBlocks().size() - 1);
        if (exp instanceof OBinaryCondition) {
            OBinaryCompareOperator additionalOperator;
            OBinaryCompareOperator operator = ((OBinaryCondition)exp).getOperator();
            OBinaryCompareOperator oBinaryCompareOperator = additionalOperator = additional == null ? null : additional.getOperator();
            if (this.isLessOperator(operator)) {
                return this.isIncludeOperator(operator);
            }
            return additionalOperator == null || this.isIncludeOperator(additionalOperator) && this.isLessOperator(additionalOperator);
        }
        throw new UnsupportedOperationException("Cannot execute index query with " + exp);
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String result = OExecutionStepInternal.getIndent(depth, indent) + "+ DELETE FROM INDEX " + this.index.getName();
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        result = result + (this.condition == null ? "" : "\n" + OExecutionStepInternal.getIndent(depth, indent) + "  " + this.condition + (this.additional == null ? "" : " and " + this.additional));
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

