/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OCluster;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class FindReferencesStep
extends AbstractExecutionStep {
    private final List<OIdentifier> classes;
    private final List<OCluster> clusters;
    boolean inited = false;
    Set<ORID> ridsToFind;
    ORecordIteratorCluster currentIterator;
    Iterator<ORecordIteratorCluster> clusterIterators;
    OResultInternal nextResult;

    public FindReferencesStep(List<OIdentifier> classes, List<OCluster> clusters, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.classes = classes;
        this.clusters = clusters;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, int nRecords) throws OTimeoutException {
        if (!this.inited) {
            this.init(ctx, nRecords);
        }
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return FindReferencesStep.this.nextResult != null;
            }

            @Override
            public OResult next() {
                if (FindReferencesStep.this.nextResult == null) {
                    throw new IllegalStateException();
                }
                OResultInternal result = FindReferencesStep.this.nextResult;
                FindReferencesStep.this.fetchNext(ctx);
                return result;
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private void init(OCommandContext ctx, int nRecords) {
        this.fetchRidsToFind(ctx, nRecords);
        this.initClusterIterators(ctx);
        this.fetchNext(ctx);
        this.inited = true;
    }

    /*
     * Unable to fully structure code
     */
    private void fetchNext(OCommandContext ctx) {
        this.nextResult = null;
        block0: while (true) {
            if (this.currentIterator == null || !this.currentIterator.hasNext()) {
                if (!this.clusterIterators.hasNext()) {
                    return;
                }
                this.currentIterator = this.clusterIterators.next();
                continue;
            }
            rec = this.currentIterator.next();
            if (!(rec instanceof ODocument)) continue;
            x = new OResultInternal();
            x.setElement((OIdentifiable)rec);
            var4_4 = this.ridsToFind.iterator();
            do {
                if (var4_4.hasNext()) ** break;
                continue block0;
            } while ((resultForRecord = FindReferencesStep.checkObject(Collections.singleton(rid = var4_4.next()), x, (ORecord)rec, "")).size() <= 0);
            break;
        }
        this.nextResult = new OResultInternal();
        this.nextResult.setProperty("rid", rid);
        this.nextResult.setProperty("referredBy", rec);
        this.nextResult.setProperty("fields", resultForRecord);
    }

    private void initClusterIterators(OCommandContext ctx) {
        ODatabaseInternal db = (ODatabaseInternal)ctx.getDatabase();
        HashSet<String> targetClusterNames = new HashSet<String>();
        if (!(this.classes != null && this.classes.size() != 0 || this.clusters != null && this.clusters.size() != 0)) {
            targetClusterNames.addAll(ctx.getDatabase().getClusterNames());
        } else if (this.clusters != null) {
            for (OCluster c : this.clusters) {
                if (c.getClusterName() != null) {
                    targetClusterNames.add(c.getClusterName());
                    continue;
                }
                String clusterName2 = db.getClusterNameById(c.getClusterNumber());
                if (clusterName2 == null) {
                    throw new OCommandExecutionException("Cluster not found: " + c.getClusterNumber());
                }
                targetClusterNames.add(clusterName2);
            }
            OSchema schema = db.getMetadata().getSchema();
            for (OIdentifier className : this.classes) {
                OClass clazz = schema.getClass(className.getStringValue());
                if (clazz == null) {
                    throw new OCommandExecutionException("Class not found: " + className);
                }
                for (int clusterId : clazz.getPolymorphicClusterIds()) {
                    targetClusterNames.add(db.getClusterNameById(clusterId));
                }
            }
        }
        List iterators = targetClusterNames.stream().map(clusterName -> new ORecordIteratorCluster((ODatabaseDocumentInternal)db, db.getClusterIdByName((String)clusterName))).collect(Collectors.toList());
        this.clusterIterators = iterators.iterator();
    }

    private void fetchRidsToFind(OCommandContext ctx, int nRecords) {
        this.ridsToFind = new HashSet<ORID>();
        OExecutionStepInternal prevStep = this.getPrev().get();
        OResultSet nextSlot = prevStep.syncPull(ctx, nRecords);
        while (nextSlot.hasNext()) {
            while (nextSlot.hasNext()) {
                OResult nextRes = nextSlot.next();
                if (!nextRes.isElement()) continue;
                this.ridsToFind.add(nextRes.getElement().get().getIdentity());
            }
            nextSlot = prevStep.syncPull(ctx, nRecords);
        }
    }

    private static List<String> checkObject(Set<ORID> iSourceRIDs, Object value, ORecord iRootObject, String prefix) {
        if (value instanceof OResult) {
            return FindReferencesStep.checkRoot(iSourceRIDs, (OResult)value, iRootObject, prefix).stream().map(y -> value + "." + y).collect(Collectors.toList());
        }
        if (value instanceof OIdentifiable) {
            return FindReferencesStep.checkRecord(iSourceRIDs, (OIdentifiable)value, iRootObject, prefix).stream().map(y -> value + "." + y).collect(Collectors.toList());
        }
        if (value instanceof Collection) {
            return FindReferencesStep.checkCollection(iSourceRIDs, (Collection)value, iRootObject, prefix).stream().map(y -> value + "." + y).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            return FindReferencesStep.checkMap(iSourceRIDs, (Map)value, iRootObject, prefix).stream().map(y -> value + "." + y).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private static List<String> checkCollection(Set<ORID> iSourceRIDs, Collection<?> values, ORecord iRootObject, String prefix) {
        Iterator<Object> it = values instanceof ORecordLazyMultiValue ? ((ORecordLazyMultiValue)((Object)values)).rawIterator() : values.iterator();
        ArrayList<String> result = new ArrayList<String>();
        while (it.hasNext()) {
            result.addAll(FindReferencesStep.checkObject(iSourceRIDs, it.next(), iRootObject, prefix));
        }
        return result;
    }

    private static List<String> checkMap(Set<ORID> iSourceRIDs, Map<?, ?> values, ORecord iRootObject, String prefix) {
        Iterator<OIdentifiable> it = values instanceof ORecordLazyMap ? ((ORecordLazyMap)values).rawIterator() : values.values().iterator();
        ArrayList<String> result = new ArrayList<String>();
        while (it.hasNext()) {
            result.addAll(FindReferencesStep.checkObject(iSourceRIDs, it.next(), iRootObject, prefix));
        }
        return result;
    }

    private static List<String> checkRecord(Set<ORID> iSourceRIDs, OIdentifiable value, ORecord iRootObject, String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        if (iSourceRIDs.contains(value.getIdentity())) {
            result.add(prefix);
        } else if (!value.getIdentity().isValid() && value.getRecord() instanceof ODocument) {
            ODocument doc = (ODocument)value.getRecord();
            for (String fieldName : doc.fieldNames()) {
                Object fieldValue = doc.field(fieldName);
                result.addAll(FindReferencesStep.checkObject(iSourceRIDs, fieldValue, iRootObject, prefix + "." + fieldName));
            }
        }
        return result;
    }

    private static List<String> checkRoot(Set<ORID> iSourceRIDs, OResult value, ORecord iRootObject, String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        for (String fieldName : value.getPropertyNames()) {
            Object fieldValue = value.getProperty(fieldName);
            result.addAll(FindReferencesStep.checkObject(iSourceRIDs, fieldValue, iRootObject, prefix + "." + fieldName));
        }
        return result;
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ FIND REFERENCES\n");
        result.append(spaces);
        if ((this.classes == null || this.classes.isEmpty()) && (this.clusters == null || this.clusters.isEmpty())) {
            result.append("  (all db)");
        } else {
            if (this.classes != null && this.classes.size() > 0) {
                result.append("  classes: " + this.classes);
            }
            if (this.clusters != null && this.clusters.size() > 0) {
                result.append("  classes: " + this.clusters);
            }
        }
        return result.toString();
    }
}

