/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.PatternNode;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class MatchFirstStep
extends AbstractExecutionStep {
    private final PatternNode node;
    OInternalExecutionPlan executionPlan;
    Iterator<OResult> iterator;
    OResultSet subResultSet;

    public MatchFirstStep(OCommandContext context, PatternNode node, boolean profilingEnabled) {
        this(context, node, null, profilingEnabled);
    }

    public MatchFirstStep(OCommandContext context, PatternNode node, OInternalExecutionPlan subPlan, boolean profilingEnabled) {
        super(context, profilingEnabled);
        this.node = node;
        this.executionPlan = subPlan;
    }

    @Override
    public void reset() {
        this.iterator = null;
        this.subResultSet = null;
        if (this.executionPlan != null) {
            this.executionPlan.reset(this.getContext());
        }
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        this.init(ctx);
        return new OResultSet(){
            int currentCount = 0;

            @Override
            public boolean hasNext() {
                if (this.currentCount >= nRecords) {
                    return false;
                }
                if (MatchFirstStep.this.iterator != null) {
                    return MatchFirstStep.this.iterator.hasNext();
                }
                return MatchFirstStep.this.subResultSet.hasNext();
            }

            @Override
            public OResult next() {
                if (this.currentCount >= nRecords) {
                    throw new IllegalStateException();
                }
                OResultInternal result = new OResultInternal();
                if (MatchFirstStep.this.iterator != null) {
                    result.setProperty(MatchFirstStep.this.getAlias(), MatchFirstStep.this.iterator.next());
                } else {
                    result.setProperty(MatchFirstStep.this.getAlias(), MatchFirstStep.this.subResultSet.next());
                }
                ctx.setVariable("$matched", result);
                ++this.currentCount;
                return result;
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private Object toResult(OIdentifiable nextElement) {
        OResultInternal result = new OResultInternal();
        result.setElement(nextElement);
        return result;
    }

    private void init(OCommandContext ctx) {
        if (this.iterator == null && this.subResultSet == null) {
            String alias = this.getAlias();
            Object matchedNodes = ctx.getVariable("$$OrientDB_Prefetched_Alias_Prefix__" + alias);
            if (matchedNodes != null) {
                this.initFromPrefetch(matchedNodes);
            } else {
                this.initFromExecutionPlan(ctx);
            }
        }
    }

    private void initFromExecutionPlan(OCommandContext ctx) {
        this.subResultSet = new OLocalResultSet(this.executionPlan);
    }

    private void initFromPrefetch(Object matchedNodes) {
        Set<Object> possibleResults = matchedNodes instanceof Iterable ? (Set<Object>)matchedNodes : Collections.singleton(matchedNodes);
        this.iterator = possibleResults.iterator();
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ SET \n");
        result.append(spaces);
        result.append("   ");
        result.append(this.getAlias());
        if (this.executionPlan != null) {
            result.append("\n");
            result.append(spaces);
            result.append("  AS\n");
            result.append(this.executionPlan.prettyPrint(depth + 1, indent));
        }
        return result.toString();
    }

    private String getAlias() {
        return this.node.alias;
    }
}

