/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.CheckClassTypeStep;
import com.orientechnologies.orient.core.sql.executor.CheckClusterTypeStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInsertExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInsertExecutionPlanner;
import com.orientechnologies.orient.core.sql.parser.OCluster;
import com.orientechnologies.orient.core.sql.parser.OCreateVertexStatement;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import java.util.ArrayList;

public class OCreateVertexExecutionPlanner
extends OInsertExecutionPlanner {
    public OCreateVertexExecutionPlanner(OCreateVertexStatement statement) {
        this.targetClass = statement.getTargetClass() == null ? null : statement.getTargetClass().copy();
        this.targetClusterName = statement.getTargetClusterName() == null ? null : statement.getTargetClusterName().copy();
        OCluster oCluster = this.targetCluster = statement.getTargetCluster() == null ? null : statement.getTargetCluster().copy();
        if (this.targetClass == null && this.targetCluster == null && this.targetClusterName == null) {
            this.targetClass = new OIdentifier("V");
        }
        this.insertBody = statement.getInsertBody() == null ? null : statement.getInsertBody().copy();
        this.returnStatement = statement.getReturnStatement() == null ? null : statement.getReturnStatement().copy();
    }

    @Override
    public OInsertExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        OInsertExecutionPlan prev = super.createExecutionPlan(ctx, enableProfiling);
        ArrayList<OExecutionStep> steps = new ArrayList<OExecutionStep>(prev.getSteps());
        OInsertExecutionPlan result = new OInsertExecutionPlan(ctx);
        this.handleCheckType(result, ctx, enableProfiling);
        for (OExecutionStep step : steps) {
            result.chain((OExecutionStepInternal)step);
        }
        return result;
    }

    private void handleCheckType(OInsertExecutionPlan result, OCommandContext ctx, boolean profilingEnabled) {
        if (this.targetClass != null) {
            result.chain(new CheckClassTypeStep(this.targetClass.getStringValue(), "V", ctx, profilingEnabled));
        }
        if (this.targetClusterName != null) {
            result.chain(new CheckClusterTypeStep(this.targetClusterName.getStringValue(), "V", ctx, profilingEnabled));
        }
        if (this.targetCluster != null) {
            result.chain(new CheckClusterTypeStep(this.targetCluster, "V", ctx, profilingEnabled));
        }
    }
}

