/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.graph;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionConfigurableAbstract;
import java.util.ArrayList;

public abstract class OSQLFunctionMove
extends OSQLFunctionConfigurableAbstract {
    public static final String NAME = "move";

    public OSQLFunctionMove() {
        super(NAME, 1, 2);
    }

    public OSQLFunctionMove(String iName, int iMin, int iMax) {
        super(iName, iMin, iMax);
    }

    protected abstract Object move(ODatabase var1, OIdentifiable var2, String[] var3);

    @Override
    public String getSyntax() {
        return "Syntax error: " + this.name + "([<labels>])";
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParameters, OCommandContext iContext) {
        final ODatabase db = iContext != null ? iContext.getDatabase() : ODatabaseRecordThreadLocal.instance().getIfDefined();
        final String[] labels = iParameters != null && iParameters.length > 0 && iParameters[0] != null ? OMultiValue.array(iParameters, String.class, new OCallable<Object, Object>(){

            @Override
            public Object call(Object iArgument) {
                return OIOUtils.getStringContent(iArgument);
            }
        }) : null;
        return OSQLEngine.foreachRecord(new OCallable<Object, OIdentifiable>(){

            @Override
            public Object call(OIdentifiable iArgument) {
                return OSQLFunctionMove.this.move(db, iArgument, labels);
            }
        }, iThis, iContext);
    }

    protected Object v2v(ODatabase graph, OIdentifiable iRecord, ODirection iDirection, String[] iLabels) {
        OElement rec = (OElement)iRecord.getRecord();
        if (rec != null && rec.isVertex()) {
            return rec.asVertex().get().getVertices(iDirection, iLabels);
        }
        return null;
    }

    protected Object v2e(ODatabase graph, OIdentifiable iRecord, ODirection iDirection, String[] iLabels) {
        OElement rec = (OElement)iRecord.getRecord();
        if (rec != null && rec.isVertex()) {
            return rec.asVertex().get().getEdges(iDirection, iLabels);
        }
        return null;
    }

    protected Object e2v(ODatabase graph, OIdentifiable iRecord, ODirection iDirection, String[] iLabels) {
        OElement rec = (OElement)iRecord.getRecord();
        if (rec.isEdge()) {
            if (iDirection == ODirection.BOTH) {
                ArrayList<OVertex> results = new ArrayList<OVertex>();
                results.add(rec.asEdge().get().getVertex(ODirection.OUT));
                results.add(rec.asEdge().get().getVertex(ODirection.IN));
                return results;
            }
            return rec.asEdge().get().getVertex(iDirection);
        }
        return null;
    }
}

