/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.misc;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class OSQLFunctionSysdate
extends OSQLFunctionAbstract {
    public static final String NAME = "sysdate";
    private final Date now = new Date();
    private SimpleDateFormat format;

    public OSQLFunctionSysdate() {
        super(NAME, 0, 2);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        if (iParams.length == 0) {
            return this.now;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat((String)iParams[0]);
            if (iParams.length == 2) {
                this.format.setTimeZone(TimeZone.getTimeZone(iParams[1].toString()));
            } else {
                this.format.setTimeZone(ODateHelper.getDatabaseTimeZone());
            }
        }
        return this.format.format(this.now);
    }

    public boolean aggregateResults(Object[] configuredParameters) {
        return false;
    }

    @Override
    public String getSyntax() {
        return "sysdate([<format>] [,<timezone>])";
    }

    @Override
    public Object getResult() {
        return null;
    }
}

