/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OMathExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.Map;
import java.util.Set;

public class OArrayNumberSelector
extends SimpleNode {
    OInputParameter inputValue;
    OMathExpression expressionValue;
    Integer integer;

    public OArrayNumberSelector(int id) {
        super(id);
    }

    public OArrayNumberSelector(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.inputValue != null) {
            this.inputValue.toString(params, builder);
        } else if (this.expressionValue != null) {
            this.expressionValue.toString(params, builder);
        } else if (this.integer != null) {
            builder.append(this.integer);
        }
    }

    public Integer getValue(OIdentifiable iCurrentRecord, Object iResult, OCommandContext ctx) {
        Object result = null;
        if (this.inputValue != null) {
            result = this.inputValue.getValue(ctx.getInputParameters());
        } else if (this.expressionValue != null) {
            result = this.expressionValue.execute(iCurrentRecord, ctx);
        } else if (this.integer != null) {
            result = this.integer;
        }
        if (result == null) {
            return null;
        }
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        return null;
    }

    public Integer getValue(OResult iCurrentRecord, Object iResult, OCommandContext ctx) {
        Object result = null;
        if (this.inputValue != null) {
            result = this.inputValue.getValue(ctx.getInputParameters());
        } else if (this.expressionValue != null) {
            result = this.expressionValue.execute(iCurrentRecord, ctx);
        } else if (this.integer != null) {
            result = this.integer;
        }
        if (result == null) {
            return null;
        }
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        return null;
    }

    public boolean needsAliases(Set<String> aliases) {
        if (this.expressionValue != null) {
            return this.expressionValue.needsAliases(aliases);
        }
        return false;
    }

    @Override
    public OArrayNumberSelector copy() {
        OArrayNumberSelector result = new OArrayNumberSelector(-1);
        result.inputValue = this.inputValue == null ? null : this.inputValue.copy();
        result.expressionValue = this.expressionValue == null ? null : this.expressionValue.copy();
        result.integer = this.integer;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OArrayNumberSelector that = (OArrayNumberSelector)o;
        if (this.inputValue != null ? !this.inputValue.equals(that.inputValue) : that.inputValue != null) {
            return false;
        }
        if (this.expressionValue != null ? !this.expressionValue.equals(that.expressionValue) : that.expressionValue != null) {
            return false;
        }
        return this.integer != null ? this.integer.equals(that.integer) : that.integer == null;
    }

    public int hashCode() {
        int result = this.inputValue != null ? this.inputValue.hashCode() : 0;
        result = 31 * result + (this.expressionValue != null ? this.expressionValue.hashCode() : 0);
        result = 31 * result + (this.integer != null ? this.integer.hashCode() : 0);
        return result;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        if (this.expressionValue != null) {
            this.expressionValue.extractSubQueries(collector);
        }
    }

    public boolean refersToParent() {
        return this.expressionValue != null && this.expressionValue.refersToParent();
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.inputValue != null) {
            result.setProperty("inputValue", this.inputValue.serialize());
        }
        if (this.expressionValue != null) {
            result.setProperty("expressionValue", this.expressionValue.serialize());
        }
        result.setProperty("integer", this.integer);
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("inputValue") != null) {
            this.inputValue = OInputParameter.deserializeFromOResult((OResult)fromResult.getProperty("inputValue"));
        }
        if (fromResult.getProperty("toSelector") != null) {
            this.expressionValue = new OMathExpression(-1);
            this.expressionValue.deserialize((OResult)fromResult.getProperty("expressionValue"));
        }
        this.integer = (Integer)fromResult.getProperty("integer");
    }
}

