/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassEmbedded;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OCreatePropertyAttributeStatement;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class OCreatePropertyStatement
extends ODDLStatement {
    public OIdentifier className;
    public OIdentifier propertyName;
    boolean ifNotExists = false;
    public OIdentifier propertyType;
    public OIdentifier linkedType;
    public boolean unsafe = false;
    public List<OCreatePropertyAttributeStatement> attributes = new ArrayList<OCreatePropertyAttributeStatement>();

    public OCreatePropertyStatement(int id) {
        super(id);
    }

    public OCreatePropertyStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "create property");
        result.setProperty("className", this.className.getStringValue());
        result.setProperty("propertyName", this.propertyName.getStringValue());
        this.executeInternal(ctx, result);
        OInternalResultSet rs = new OInternalResultSet();
        rs.add(result);
        return rs;
    }

    private void executeInternal(OCommandContext ctx, OResultInternal result) {
        ODatabase db = ctx.getDatabase();
        OClassEmbedded clazz = (OClassEmbedded)db.getMetadata().getSchema().getClass(this.className.getStringValue());
        if (clazz == null) {
            throw new OCommandExecutionException("Class not found: " + this.className.getStringValue());
        }
        if (clazz.getProperty(this.propertyName.getStringValue()) != null) {
            if (this.ifNotExists) {
                return;
            }
            throw new OCommandExecutionException("Property " + this.className.getStringValue() + "." + this.propertyName.getStringValue() + " already exists");
        }
        OType type = OType.valueOf(this.propertyType.getStringValue().toUpperCase(Locale.ENGLISH));
        if (type == null) {
            throw new OCommandExecutionException("Invalid property type: " + this.propertyType.getStringValue());
        }
        OClass linkedClass = null;
        OType linkedType = null;
        if (this.linkedType != null) {
            String linked = this.linkedType.getStringValue();
            linkedClass = db.getMetadata().getSchema().getClass(linked);
            if (linkedClass == null) {
                linkedType = OType.valueOf(linked.toUpperCase(Locale.ENGLISH));
            }
        }
        OPropertyImpl internalProp = (OPropertyImpl)clazz.addProperty(this.propertyName.getStringValue(), type, linkedType, linkedClass, this.unsafe);
        for (OCreatePropertyAttributeStatement attr : this.attributes) {
            Object val = attr.setOnProperty(internalProp, ctx);
            result.setProperty(attr.settingName.getStringValue(), val);
        }
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("CREATE PROPERTY ");
        this.className.toString(params, builder);
        builder.append(".");
        this.propertyName.toString(params, builder);
        if (this.ifNotExists) {
            builder.append(" IF NOT EXISTS");
        }
        builder.append(" ");
        this.propertyType.toString(params, builder);
        if (this.linkedType != null) {
            builder.append(" ");
            this.linkedType.toString(params, builder);
        }
        if (!this.attributes.isEmpty()) {
            builder.append(" (");
            for (int i = 0; i < this.attributes.size(); ++i) {
                OCreatePropertyAttributeStatement att = this.attributes.get(i);
                att.toString(params, builder);
                if (i >= this.attributes.size() - 1) continue;
                builder.append(", ");
            }
            builder.append(")");
        }
        if (this.unsafe) {
            builder.append(" UNSAFE");
        }
    }

    @Override
    public OCreatePropertyStatement copy() {
        OCreatePropertyStatement result = new OCreatePropertyStatement(-1);
        result.className = this.className == null ? null : this.className.copy();
        result.propertyName = this.propertyName == null ? null : this.propertyName.copy();
        result.propertyType = this.propertyType == null ? null : this.propertyType.copy();
        result.linkedType = this.linkedType == null ? null : this.linkedType.copy();
        result.unsafe = this.unsafe;
        result.ifNotExists = this.ifNotExists;
        result.attributes = this.attributes == null ? null : this.attributes.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCreatePropertyStatement that = (OCreatePropertyStatement)o;
        if (this.unsafe != that.unsafe) {
            return false;
        }
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.propertyName != null ? !this.propertyName.equals(that.propertyName) : that.propertyName != null) {
            return false;
        }
        if (this.propertyType != null ? !this.propertyType.equals(that.propertyType) : that.propertyType != null) {
            return false;
        }
        if (this.linkedType != null ? !this.linkedType.equals(that.linkedType) : that.linkedType != null) {
            return false;
        }
        if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) {
            return false;
        }
        return this.ifNotExists == that.ifNotExists;
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.propertyName != null ? this.propertyName.hashCode() : 0);
        result = 31 * result + (this.propertyType != null ? this.propertyType.hashCode() : 0);
        result = 31 * result + (this.linkedType != null ? this.linkedType.hashCode() : 0);
        result = 31 * result + (this.unsafe ? 1 : 0);
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        return result;
    }
}

