/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OGroupBy
extends SimpleNode {
    protected List<OExpression> items = new ArrayList<OExpression>();

    public OGroupBy(int id) {
        super(id);
    }

    public OGroupBy(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("GROUP BY ");
        for (int i = 0; i < this.items.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            this.items.get(i).toString(params, builder);
        }
    }

    public List<OExpression> getItems() {
        return this.items;
    }

    @Override
    public OGroupBy copy() {
        OGroupBy result = new OGroupBy(-1);
        result.items = this.items.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OGroupBy oGroupBy = (OGroupBy)o;
        return !(this.items != null ? !this.items.equals(oGroupBy.items) : oGroupBy.items != null);
    }

    public int hashCode() {
        return this.items != null ? this.items.hashCode() : 0;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        for (OExpression item : this.items) {
            item.extractSubQueries(collector);
        }
    }

    public boolean refersToParent() {
        for (OExpression item : this.items) {
            if (!item.refersToParent()) continue;
            return true;
        }
        return false;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.items != null) {
            result.setProperty("items", this.items.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("items") != null) {
            List ser = (List)fromResult.getProperty("items");
            this.items = new ArrayList<OExpression>();
            for (OResult r : ser) {
                OExpression exp = new OExpression(-1);
                exp.deserialize(r);
                this.items.add(exp);
            }
        }
    }
}

