/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.AggregateProjectionSplit;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.Map;
import java.util.Set;

public class OJsonItem {
    protected OIdentifier leftIdentifier;
    protected String leftString;
    protected OExpression right;

    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.leftIdentifier != null) {
            builder.append("\"");
            this.leftIdentifier.toString(params, builder);
            builder.append("\"");
        }
        if (this.leftString != null) {
            builder.append("\"");
            builder.append(OExpression.encode(this.leftString));
            builder.append("\"");
        }
        builder.append(": ");
        this.right.toString(params, builder);
    }

    public String getLeftValue() {
        if (this.leftString != null) {
            return this.leftString;
        }
        if (this.leftIdentifier != null) {
            return this.leftIdentifier.getStringValue();
        }
        return null;
    }

    public boolean needsAliases(Set<String> aliases) {
        if (aliases.contains(this.leftIdentifier.getStringValue())) {
            return true;
        }
        return this.right.needsAliases(aliases);
    }

    public boolean isAggregate() {
        return this.right.isAggregate();
    }

    public OJsonItem splitForAggregation(AggregateProjectionSplit aggregateSplit, OCommandContext ctx) {
        if (this.isAggregate()) {
            OJsonItem item = new OJsonItem();
            item.leftIdentifier = this.leftIdentifier;
            item.leftString = this.leftString;
            item.right = this.right.splitForAggregation(aggregateSplit, ctx);
            return item;
        }
        return this;
    }

    public OJsonItem copy() {
        OJsonItem result = new OJsonItem();
        result.leftIdentifier = this.leftIdentifier == null ? null : this.leftIdentifier.copy();
        result.leftString = this.leftString;
        result.right = this.right.copy();
        return result;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        this.right.extractSubQueries(collector);
    }

    public boolean refersToParent() {
        return this.right != null && this.right.refersToParent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OJsonItem oJsonItem = (OJsonItem)o;
        if (this.leftIdentifier != null ? !this.leftIdentifier.equals(oJsonItem.leftIdentifier) : oJsonItem.leftIdentifier != null) {
            return false;
        }
        if (this.leftString != null ? !this.leftString.equals(oJsonItem.leftString) : oJsonItem.leftString != null) {
            return false;
        }
        return this.right != null ? this.right.equals(oJsonItem.right) : oJsonItem.right == null;
    }

    public int hashCode() {
        int result = this.leftIdentifier != null ? this.leftIdentifier.hashCode() : 0;
        result = 31 * result + (this.leftString != null ? this.leftString.hashCode() : 0);
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("leftIdentifier", this.leftIdentifier.serialize());
        result.setProperty("leftString", this.leftString);
        result.setProperty("right", this.right.serialize());
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("leftIdentifier") != null) {
            this.leftIdentifier = OIdentifier.deserialize((OResult)fromResult.getProperty("leftIdentifier"));
        }
        if (fromResult.getProperty("leftString") != null) {
            this.leftString = (String)fromResult.getProperty("leftString");
        }
        if (fromResult.getProperty("right") != null) {
            this.right = new OExpression(-1);
            this.right.deserialize((OResult)fromResult.getProperty("right"));
        }
    }
}

