/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OUnwind
extends SimpleNode {
    protected List<OIdentifier> items = new ArrayList<OIdentifier>();

    public OUnwind(int id) {
        super(id);
    }

    public OUnwind(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("UNWIND ");
        for (int i = 0; i < this.items.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            this.items.get(i).toString(params, builder);
        }
    }

    @Override
    public OUnwind copy() {
        OUnwind result = new OUnwind(-1);
        result.items = this.items.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OUnwind oUnwind = (OUnwind)o;
        return !(this.items != null ? !this.items.equals(oUnwind.items) : oUnwind.items != null);
    }

    public int hashCode() {
        return this.items != null ? this.items.hashCode() : 0;
    }

    public List<OIdentifier> getItems() {
        return this.items;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.items != null) {
            result.setProperty("items", this.items.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("items") != null) {
            List ser = (List)fromResult.getProperty("items");
            this.items = new ArrayList<OIdentifier>();
            for (OResult r : ser) {
                OIdentifier exp = OIdentifier.deserialize(r);
                this.items.add(exp);
            }
        }
    }
}

