/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.jna.ONative;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.OWALFile;
import com.sun.jna.LastErrorException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class OWALFdFile
implements OWALFile {
    private final int fd;
    private final int blockSize;

    OWALFdFile(int fd, int blockSize) {
        this.fd = fd;
        this.blockSize = blockSize;
    }

    @Override
    public void force(boolean forceMetadata) throws IOException {
        try {
            ONative.instance().fsync(this.fd);
        }
        catch (LastErrorException e) {
            throw new IOException("Can not perform force sync.", e);
        }
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException {
        if (buffer.limit() % this.blockSize != 0) {
            throw new IOException("In direct IO mode, size of the written buffers should be quantified by block size (block size : " + this.blockSize + ", buffer size: " + buffer.limit() + " )");
        }
        try {
            int written = (int)ONative.instance().write(this.fd, buffer, buffer.remaining());
            buffer.position(buffer.position() + written);
            return written;
        }
        catch (LastErrorException e) {
            throw new IOException("Error during writing of data to file", e);
        }
    }

    @Override
    public long position() throws IOException {
        try {
            return ONative.instance().lseek(this.fd, 0L, 1);
        }
        catch (LastErrorException e) {
            throw new IOException("Can not retrieve position of file", e);
        }
    }

    @Override
    public void position(long position) throws IOException {
        if (position % (long)this.blockSize != 0L) {
            throw new IOException("In direct IO mode, position of the file should be quantified by block size (block size : " + this.blockSize + ", position : " + position + " )");
        }
        try {
            ONative.instance().lseek(this.fd, position, 0);
        }
        catch (LastErrorException e) {
            throw new IOException("Can not set position of file", e);
        }
    }

    @Override
    public void readBuffer(ByteBuffer buffer) throws IOException {
        if (buffer.limit() % this.blockSize != 0) {
            throw new IOException("In direct IO mode, size of the written buffers should be quantified by block size (block size : " + this.blockSize + ", buffer size: " + buffer.limit() + " )");
        }
        OIOUtils.readByteBuffer(buffer, this.fd);
    }

    @Override
    public void close() throws IOException {
        try {
            ONative.instance().close(this.fd);
        }
        catch (LastErrorException e) {
            throw new IOException("Error during closing the file", e);
        }
    }
}

