/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.hashindex.local;

import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndexDictionary;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexFullText;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexNotUnique;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.index.engine.OIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.index.engine.OHashTableIndexEngine;
import com.orientechnologies.orient.core.storage.index.engine.ORemoteIndexEngine;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OHashIndexFactory
implements OIndexFactory {
    private static final Set<String> TYPES;
    public static final String HASH_INDEX_ALGORITHM = "HASH_INDEX";
    private static final Set<String> ALGORITHMS;

    @Override
    public Set<String> getTypes() {
        return TYPES;
    }

    @Override
    public Set<String> getAlgorithms() {
        return ALGORITHMS;
    }

    @Override
    public OIndexInternal<?> createIndex(String name, OStorage storage, String indexType, String algorithm, String valueContainerAlgorithm, ODocument metadata, int version) throws OConfigurationException {
        if (version < 0) {
            version = this.getLastVersion(algorithm);
        }
        if (valueContainerAlgorithm == null) {
            valueContainerAlgorithm = "NONE";
        }
        int binaryFormatVersion = storage.getConfiguration().getBinaryFormatVersion();
        if (OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexUnique(name, indexType, algorithm, version, (OAbstractPaginatedStorage)storage.getUnderlying(), valueContainerAlgorithm, metadata, binaryFormatVersion);
        }
        if (OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexNotUnique(name, indexType, algorithm, version, (OAbstractPaginatedStorage)storage.getUnderlying(), valueContainerAlgorithm, metadata, binaryFormatVersion);
        }
        if (OClass.INDEX_TYPE.FULLTEXT_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexFullText(name, indexType, algorithm, version, (OAbstractPaginatedStorage)storage.getUnderlying(), valueContainerAlgorithm, metadata, binaryFormatVersion);
        }
        if (OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexDictionary(name, indexType, algorithm, version, (OAbstractPaginatedStorage)storage.getUnderlying(), valueContainerAlgorithm, metadata, binaryFormatVersion);
        }
        throw new OConfigurationException("Unsupported type: " + indexType);
    }

    @Override
    public int getLastVersion(String algorithm) {
        return 2;
    }

    @Override
    public OBaseIndexEngine createIndexEngine(String algoritm, String name, Boolean durableInNonTxMode, OStorage storage, int version, int apiVersion, boolean multivalue, Map<String, String> engineProperties) {
        OIndexEngine indexEngine;
        String storageType = storage.getType();
        if (storageType.equals("memory") || storageType.equals("plocal")) {
            indexEngine = new OHashTableIndexEngine(name, (OAbstractPaginatedStorage)storage, version);
        } else if (storageType.equals("distributed")) {
            indexEngine = new OHashTableIndexEngine(name, (OAbstractPaginatedStorage)storage.getUnderlying(), version);
        } else if (storageType.equals("remote")) {
            indexEngine = new ORemoteIndexEngine(name);
        } else {
            throw new OIndexException("Unsupported storage type: " + storageType);
        }
        return indexEngine;
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add(OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.toString());
        types.add(OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX.toString());
        types.add(OClass.INDEX_TYPE.FULLTEXT_HASH_INDEX.toString());
        types.add(OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.toString());
        TYPES = Collections.unmodifiableSet(types);
        HashSet<String> algorithms = new HashSet<String>();
        algorithms.add(HASH_INDEX_ALGORITHM);
        ALGORITHMS = Collections.unmodifiableSet(algorithms);
    }
}

