/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms;

import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.DataSourceMetadata;
import com.arcadeanalytics.provider.DataSourceMetadataProvider;
import com.arcadeanalytics.provider.TypeClass;
import com.arcadeanalytics.provider.TypeProperty;
import com.arcadeanalytics.provider.rdbms.context.Statistics;
import com.arcadeanalytics.provider.rdbms.dbengine.DBQueryEngine;
import com.arcadeanalytics.provider.rdbms.factory.DataTypeHandlerFactory;
import com.arcadeanalytics.provider.rdbms.factory.NameResolverFactory;
import com.arcadeanalytics.provider.rdbms.factory.StrategyFactory;
import com.arcadeanalytics.provider.rdbms.mapper.rdbms.ER2GraphMapper;
import com.arcadeanalytics.provider.rdbms.mapper.rdbms.classmapper.EVClassMapper;
import com.arcadeanalytics.provider.rdbms.mapper.rdbms.classmapper.EntityClassMapper;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Entity;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Relationship;
import com.arcadeanalytics.provider.rdbms.model.graphmodel.EdgeType;
import com.arcadeanalytics.provider.rdbms.model.graphmodel.GraphModel;
import com.arcadeanalytics.provider.rdbms.model.graphmodel.ModelProperty;
import com.arcadeanalytics.provider.rdbms.model.graphmodel.VertexType;
import com.arcadeanalytics.provider.rdbms.nameresolver.NameResolver;
import com.arcadeanalytics.provider.rdbms.persistence.handler.DBMSDataTypeHandler;
import com.arcadeanalytics.provider.rdbms.persistence.util.QueryResult;
import com.arcadeanalytics.provider.rdbms.persistence.util.RelationshipQueryResult;
import com.arcadeanalytics.provider.rdbms.strategy.WorkflowStrategy;
import com.arcadeanalytics.provider.rdbms.strategy.rdbms.AbstractDBMSModelBuildingStrategy;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/arcadeanalytics/provider/rdbms/RDBMSMetadataProvider;", "Lcom/arcadeanalytics/provider/DataSourceMetadataProvider;", "()V", "fetchMetadata", "Lcom/arcadeanalytics/provider/DataSourceMetadata;", "dataSource", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "getMapper", "Lcom/arcadeanalytics/provider/rdbms/mapper/rdbms/ER2GraphMapper;", "dbQueryEngine", "Lcom/arcadeanalytics/provider/rdbms/dbengine/DBQueryEngine;", "supportedDataSourceTypes", "", "", "arcade-connectors-rdbms"})
public final class RDBMSMetadataProvider
implements DataSourceMetadataProvider {
    @NotNull
    public Set<String> supportedDataSourceTypes() {
        return SetsKt.setOf((Object[])new String[]{"RDBMS_POSTGRESQL", "RDBMS_MYSQL", "RDBMS_MSSQLSERVER", "RDBMS_HSQL", "RDBMS_ORACLE", "RDBMS_DATA_WORLD"});
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DataSourceMetadata fetchMetadata(@NotNull DataSourceInfo dataSource) {
        Iterable $this$mapTo$iv$iv;
        Pair pair;
        Iterator queryResult;
        Object object;
        Iterable destination$iv$iv3;
        TypeClass it;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        GraphModel graphModel;
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        DBQueryEngine dbQueryEngine = new DBQueryEngine(dataSource, 300);
        ER2GraphMapper mapper = this.getMapper(dbQueryEngine, dataSource);
        GraphModel graphModel2 = graphModel = mapper.getGraphModel();
        Intrinsics.checkNotNullExpressionValue((Object)graphModel2, (String)"graphModel");
        List<VertexType> list = graphModel2.getVerticesType();
        Intrinsics.checkNotNullExpressionValue(list, (String)"graphModel.verticesType");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            ResultSet countResult;
            void $this$mapTo$iv$iv32;
            VertexType vertexType = (VertexType)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            Set<ModelProperty> set = v2.getAllProperties();
            Intrinsics.checkNotNullExpressionValue(set, (String)"it.allProperties");
            Iterable $this$map$iv2 = set;
            boolean $i$f$map22 = false;
            Iterable iterable2 = $this$map$iv2;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv32) {
                void prop;
                ModelProperty modelProperty = (ModelProperty)item$iv$iv2;
                object = destination$iv$iv3;
                boolean bl2 = false;
                void v4 = prop;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"prop");
                String string = v4.getName();
                String string2 = prop.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"prop.name");
                String string3 = prop.getOrientdbType();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"prop.orientdbType");
                Pair pair2 = TuplesKt.to((Object)string, (Object)new TypeProperty(string2, string3));
                object.add(pair2);
            }
            Map props = MapsKt.toMap((Iterable)((List)destination$iv$iv3));
            long cardinality = 0L;
            if (dataSource.getAggregationEnabled()) {
                if (!it.isFromJoinTable()) {
                    Unit unit;
                    List<EVClassMapper> list2 = mapper.getVertexType2EVClassMappers().get(it);
                    if (list2 != null && (list2 = list2.get(0)) != null && (list2 = ((EntityClassMapper)((Object)list2)).getEntity()) != null && (list2 = ((Entity)((Object)list2)).getName()) != null) {
                        List<EVClassMapper> $i$f$map22 = list2;
                        boolean $this$mapTo$iv$iv32 = false;
                        boolean destination$iv$iv3 = false;
                        List<EVClassMapper> tableName = $i$f$map22;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)dbQueryEngine.countTableRecords((String)((Object)tableName)), (String)"dbQueryEngine.countTableRecords(tableName)");
                        Intrinsics.checkNotNullExpressionValue((Object)((QueryResult)((Object)queryResult)).getResult(), (String)"queryResult.result");
                        if (countResult.next()) {
                            cardinality = countResult.getLong(1);
                        }
                        ((QueryResult)((Object)queryResult)).close();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                }
            } else {
                List<EVClassMapper> list3 = mapper.getVertexType2EVClassMappers().get(it);
                String $i$f$map22 = list3 != null && (list3 = list3.get(0)) != null && (list3 = ((EntityClassMapper)((Object)list3)).getEntity()) != null ? ((Entity)((Object)list3)).getName() : null;
                boolean $this$mapTo$iv$iv32 = false;
                boolean destination$iv$iv3 = false;
                String tableName = $i$f$map22;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)dbQueryEngine.countTableRecords(tableName), (String)"dbQueryEngine.countTableRecords(tableName)");
                Intrinsics.checkNotNullExpressionValue((Object)((QueryResult)((Object)queryResult)).getResult(), (String)"queryResult.result");
                if (countResult.next()) {
                    cardinality = countResult.getLong(1);
                }
                ((QueryResult)((Object)queryResult)).close();
            }
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            pair = new TypeClass(string, cardinality, props);
            collection.add(pair);
        }
        $this$map$iv = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (TypeClass)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            pair = TuplesKt.to((Object)it.getName(), (Object)it);
            collection.add(pair);
        }
        Map nodesClasses = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        List<EdgeType> list4 = graphModel.getEdgesType();
        Intrinsics.checkNotNullExpressionValue(list4, (String)"graphModel.edgesType");
        Iterable $this$map$iv3 = list4;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ResultSet countResult;
            RelationshipQueryResult queryResult2;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            LinkedList<Relationship> mappedRelationships;
            String edgeTypeName;
            VertexType $this$mapTo$iv$iv4;
            void edgeType;
            EdgeType bl = (EdgeType)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl5 = false;
            void v13 = edgeType;
            Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"edgeType");
            Set<ModelProperty> set = v13.getAllProperties();
            Intrinsics.checkNotNullExpressionValue(set, (String)"edgeType.allProperties");
            Iterable $this$map$iv4 = set;
            boolean $i$f$map4 = false;
            destination$iv$iv3 = $this$map$iv4;
            Collection destination$iv$iv52 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo4 = false;
            queryResult = $this$mapTo$iv$iv4.iterator();
            while (queryResult.hasNext()) {
                void prop;
                Object item$iv$iv3 = queryResult.next();
                object = (ModelProperty)item$iv$iv3;
                Collection collection2 = destination$iv$iv52;
                boolean bl6 = false;
                void v15 = prop;
                Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"prop");
                String string = v15.getName();
                String string4 = prop.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"prop.name");
                String string5 = prop.getOrientdbType();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"prop.orientdbType");
                Pair pair3 = TuplesKt.to((Object)string, (Object)new TypeProperty(string4, string5));
                collection2.add(pair3);
            }
            Map props = MapsKt.toMap((Iterable)((List)destination$iv$iv52));
            Intrinsics.checkNotNullExpressionValue((Object)edgeType.getName(), (String)"edgeType.name");
            long cardinality = 0L;
            if (dataSource.getAggregationEnabled()) {
                if (edgeType.isAggregatorEdge()) {
                    Unit unit;
                    if (mapper.getJoinVertexTypeByAggregatorEdgeName(edgeTypeName) != null) {
                        ResultSet countResult2;
                        QueryResult queryResult3;
                        Entity joinTable;
                        boolean destination$iv$iv52 = false;
                        $i$f$mapTo4 = false;
                        VertexType $this$run = $this$mapTo$iv$iv4;
                        boolean bl7 = false;
                        Entity entity = joinTable = mapper.getEntityByVertexType($this$run, 0);
                        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"joinTable");
                        Intrinsics.checkNotNullExpressionValue((Object)dbQueryEngine.countTableRecords(entity.getName()), (String)"dbQueryEngine.countTableRecords(joinTable.name)");
                        Intrinsics.checkNotNullExpressionValue((Object)queryResult3.getResult(), (String)"queryResult.result");
                        if (countResult2.next()) {
                            cardinality += countResult2.getLong(1);
                        }
                        queryResult3.close();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                } else {
                    Unit unit;
                    LinkedList<Relationship> linkedList = mappedRelationships = mapper.getEdgeType2relationships().get(edgeType);
                    if (linkedList != null) {
                        $this$forEach$iv = linkedList;
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Relationship it2 = (Relationship)element$iv;
                            boolean bl8 = false;
                            Relationship relationship = it2;
                            Intrinsics.checkNotNullExpressionValue((Object)relationship, (String)"it");
                            Entity entity = relationship.getForeignEntity();
                            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"it.foreignEntity");
                            if (entity.isAggregableJoinTable()) continue;
                            Intrinsics.checkNotNullExpressionValue((Object)dbQueryEngine.computeRelationshipCardinality(it2, dataSource, edgeTypeName), (String)"dbQueryEngine.computeRel\u2026dataSource, edgeTypeName)");
                            Intrinsics.checkNotNullExpressionValue((Object)queryResult2.getResult(), (String)"queryResult.result");
                            if (countResult.next()) {
                                cardinality += countResult.getLong(1);
                            }
                            queryResult2.close();
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                }
            } else {
                Unit unit;
                LinkedList<Relationship> linkedList = mappedRelationships = mapper.getEdgeType2relationships().get(edgeType);
                if (linkedList != null) {
                    $this$forEach$iv = linkedList;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Relationship rel = (Relationship)element$iv;
                        boolean bl9 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)dbQueryEngine.computeRelationshipCardinality(rel, dataSource, edgeTypeName), (String)"dbQueryEngine.computeRel\u2026dataSource, edgeTypeName)");
                        Intrinsics.checkNotNullExpressionValue((Object)queryResult2.getResult(), (String)"queryResult.result");
                        if (countResult.next()) {
                            cardinality += countResult.getLong(1);
                        }
                        queryResult2.close();
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            String string = edgeType.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"edgeType.name");
            pair = new TypeClass(string, cardinality, props);
            collection.add(pair);
        }
        $this$map$iv3 = (List)destination$iv$iv4;
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv3;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            TypeClass edgeType = (TypeClass)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            pair = TuplesKt.to((Object)it3.getName(), (Object)it3);
            collection.add(pair);
        }
        Map edgesClasses = MapsKt.toMap((Iterable)((List)destination$iv$iv4));
        dbQueryEngine.close();
        return new DataSourceMetadata(nodesClasses, edgesClasses);
    }

    private final ER2GraphMapper getMapper(DBQueryEngine dbQueryEngine, DataSourceInfo dataSource) {
        ER2GraphMapper mapper;
        Statistics statistics = new Statistics();
        boolean aggregate = dataSource.getAggregationEnabled();
        String chosenStrategy = aggregate ? "interactive-aggr" : "interactive";
        DataTypeHandlerFactory dataTypeHandlerFactory = new DataTypeHandlerFactory();
        DBMSDataTypeHandler handler = dataTypeHandlerFactory.buildDataTypeHandler(dataSource.getType());
        NameResolverFactory nameResolverFactory = new NameResolverFactory();
        NameResolver nameResolver = nameResolverFactory.buildNameResolver("original");
        StrategyFactory strategyFactory = new StrategyFactory();
        WorkflowStrategy workflowStrategy = strategyFactory.buildStrategy(chosenStrategy);
        if (workflowStrategy == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.arcadeanalytics.provider.rdbms.strategy.rdbms.AbstractDBMSModelBuildingStrategy");
        }
        ER2GraphMapper eR2GraphMapper = mapper = ((AbstractDBMSModelBuildingStrategy)workflowStrategy).createSchemaMapper(dataSource, null, "basicDBMapper", null, nameResolver, handler, null, null, chosenStrategy, dbQueryEngine, statistics);
        if (eR2GraphMapper == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.arcadeanalytics.provider.rdbms.mapper.rdbms.ER2GraphMapper");
        }
        return eR2GraphMapper;
    }
}

