/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.dataprovider;

import com.arcadeanalytics.provider.DataSourceGraphDataProvider;
import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.GraphData;
import com.arcadeanalytics.provider.rdbms.context.Statistics;
import com.arcadeanalytics.provider.rdbms.dataprovider.DataFetcher;
import com.arcadeanalytics.provider.rdbms.dbengine.DBQueryEngine;
import com.arcadeanalytics.provider.rdbms.exception.RDBMSProviderAggregationException;
import com.arcadeanalytics.provider.rdbms.exception.RDBMSProviderIOException;
import com.arcadeanalytics.provider.rdbms.exception.RDBMSProviderOperationNotAllowedException;
import com.arcadeanalytics.provider.rdbms.exception.RDBMSProviderRuntimeException;
import com.arcadeanalytics.provider.rdbms.factory.DataTypeHandlerFactory;
import com.arcadeanalytics.provider.rdbms.factory.NameResolverFactory;
import com.arcadeanalytics.provider.rdbms.factory.StrategyFactory;
import com.arcadeanalytics.provider.rdbms.mapper.rdbms.AggregatorEdge;
import com.arcadeanalytics.provider.rdbms.mapper.rdbms.ER2GraphMapper;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Attribute;
import com.arcadeanalytics.provider.rdbms.model.dbschema.CanonicalRelationship;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Entity;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Relationship;
import com.arcadeanalytics.provider.rdbms.model.graphmodel.EdgeType;
import com.arcadeanalytics.provider.rdbms.model.graphmodel.ElementType;
import com.arcadeanalytics.provider.rdbms.model.graphmodel.VertexType;
import com.arcadeanalytics.provider.rdbms.nameresolver.NameResolver;
import com.arcadeanalytics.provider.rdbms.persistence.handler.DBMSDataTypeHandler;
import com.arcadeanalytics.provider.rdbms.persistence.util.DBSourceConnection;
import com.arcadeanalytics.provider.rdbms.persistence.util.QueryResult;
import com.arcadeanalytics.provider.rdbms.persistence.util.RelationshipQueryResult;
import com.arcadeanalytics.provider.rdbms.strategy.rdbms.AbstractDBMSModelBuildingStrategy;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBMSDataProvider
implements DataSourceGraphDataProvider {
    private final Logger log = LoggerFactory.getLogger(RDBMSDataProvider.class);
    private final DataFetcher dataFetcher = new DataFetcher();
    private final Statistics statistics = new Statistics();
    private DBQueryEngine dbQueryEngine;
    private String datasourceId;

    public void prepareMapperAndDataFetcher(DataSourceInfo datasource) {
        ER2GraphMapper mapper;
        this.datasourceId = Optional.ofNullable(datasource.getId()).orElse(-1L).toString();
        this.dbQueryEngine = new DBQueryEngine(datasource, 300);
        Boolean aggregate = Optional.ofNullable(datasource.isAggregationEnabled()).orElse(false);
        String chosenStrategy = aggregate != false ? "interactive-aggr" : "interactive";
        DataTypeHandlerFactory dataTypeHandlerFactory = new DataTypeHandlerFactory();
        DBMSDataTypeHandler handler = dataTypeHandlerFactory.buildDataTypeHandler(datasource.getType());
        NameResolverFactory nameResolverFactory = new NameResolverFactory();
        NameResolver nameResolver = nameResolverFactory.buildNameResolver("original");
        StrategyFactory strategyFactory = new StrategyFactory();
        try {
            mapper = ((AbstractDBMSModelBuildingStrategy)strategyFactory.buildStrategy(chosenStrategy)).createSchemaMapper(datasource, null, "basicDBMapper", null, nameResolver, handler, null, null, chosenStrategy, this.dbQueryEngine, this.statistics);
        }
        catch (RDBMSProviderIOException e) {
            throw new RuntimeException(e);
        }
        this.dataFetcher.setMapper(mapper);
    }

    public GraphData fetchData(DataSourceInfo datasource, String query, int limit) {
        GraphData data;
        query = this.fixQuery(datasource, query);
        this.log.info("query datasource {} with '{}'", (Object)datasource.getId(), (Object)query);
        this.prepareMapperAndDataFetcher(datasource);
        QueryResult queryResult = null;
        LinkedList<RelationshipQueryResult> outCountResults = new LinkedList();
        LinkedList<RelationshipQueryResult> inCountResults = new LinkedList();
        try {
            Iterator originalQuery = query;
            String[] queryWords = ((String)((Object)originalQuery)).split(" ");
            int indexOfTableNameWord = 0;
            for (int i = 0; i < queryWords.length; ++i) {
                if (!queryWords[i].equalsIgnoreCase("from")) continue;
                indexOfTableNameWord = i + 1;
                break;
            }
            String tableName = queryWords[indexOfTableNameWord];
            Entity entity = this.dataFetcher.getMapper().getEntityByNameIgnoreCase(tableName);
            Boolean isAggregationEnabled = Optional.ofNullable(datasource.isAggregationEnabled()).orElse(false);
            if (isAggregationEnabled.booleanValue() && entity.isAggregableJoinTable()) {
                VertexType aggregatedVertexType = this.dataFetcher.getMapper().getVertexTypeByEntity(entity);
                AggregatorEdge edgeType = this.dataFetcher.getMapper().getAggregatorEdgeByJoinVertexTypeName(aggregatedVertexType.getName());
                throw new RDBMSProviderAggregationException("Wrong query content: the requested table was aggregated into the " + edgeType.getEdgeType().getName() + " edge class.");
            }
            queryResult = this.dbQueryEngine.scanTableAndOrder(query, limit, entity, datasource);
            if (isAggregationEnabled.booleanValue()) {
                Map<String, List<RelationshipQueryResult>> direction2countQueryResults = this.getRelationshipsCountAggregationCase(datasource, entity);
                outCountResults = direction2countQueryResults.get("out");
                inCountResults = direction2countQueryResults.get("in");
            } else {
                outCountResults = this.getOutRelationshipsCount(datasource, entity);
                inCountResults = this.getInRelationshipsCount(datasource, entity);
            }
            data = this.dataFetcher.mapResultSet(queryResult, entity, outCountResults, inCountResults);
        }
        catch (Exception e) {
            throw new RDBMSProviderRuntimeException(e);
        }
        finally {
            if (queryResult != null) {
                queryResult.close();
            }
            for (RelationshipQueryResult outRelationshipsQueryResult : outCountResults) {
                if (outRelationshipsQueryResult == null) continue;
                outRelationshipsQueryResult.close();
            }
            for (RelationshipQueryResult inRelationshipsQueryResult : inCountResults) {
                if (inRelationshipsQueryResult == null) continue;
                inRelationshipsQueryResult.close();
            }
        }
        this.dbQueryEngine.close();
        return data;
    }

    private String fixQuery(DataSourceInfo datasource, String query) {
        try {
            boolean notFound;
            Select select = (Select)CCJSqlParserUtil.parse(query);
            PlainSelect plain = (PlainSelect)select.getSelectBody();
            if (datasource.getType().equals("RDBMS_DATA_WORLD") && (notFound = plain.getSelectItems().stream().filter(item -> item instanceof SelectExpressionItem).map(item -> ((SelectExpressionItem)item).getExpression()).filter(expression -> expression instanceof Column).map(column -> ((Column)column).getColumnName()).filter(name -> name.equals("raw_index")).collect(Collectors.toList()).isEmpty())) {
                this.log.debug("fixing query to DW, add 'row_index' column");
                plain.addSelectItems(new SelectExpressionItem(new Column("row_index")));
            }
            query = plain.toString();
        }
        catch (JSQLParserException jSQLParserException) {
            // empty catch block
        }
        return query;
    }

    public GraphData expand(DataSourceInfo datasource, String[] roots, String direction, String edgeClassName, int maxTraversal) {
        if (StringUtils.isEmpty(edgeClassName)) {
            throw new RDBMSProviderOperationNotAllowedException("Cannot perform a traverse all operation over a Relational Datasource.");
        }
        this.prepareMapperAndDataFetcher(datasource);
        QueryResult queryResult = null;
        LinkedList<RelationshipQueryResult> outCountResults = new LinkedList();
        LinkedList<RelationshipQueryResult> inCountResults = new LinkedList();
        LinkedList<GraphData> graphDataCollection = new LinkedList<GraphData>();
        try {
            Iterator edgeClass = this.dataFetcher.getMapper().getGraphModel().getEdgeTypeByName(edgeClassName);
            if (!((EdgeType)((Object)edgeClass)).isAggregatorEdge()) {
                List mappedRelationships = this.dataFetcher.getMapper().getEdgeType2relationships().get(edgeClass);
                HashSet<Entity> rootEntitiesInQuery = new HashSet<Entity>();
                for (String rootId : roots) {
                    int entityId = Integer.parseInt(rootId.split("_")[0]);
                    rootEntitiesInQuery.add(this.dataFetcher.getMapper().getDataBaseSchema().getEntityByPosition(entityId));
                }
                mappedRelationships = mappedRelationships.stream().filter(r -> {
                    Entity rootEntity = null;
                    if (direction.equals("in")) {
                        rootEntity = r.getParentEntity();
                    } else if (direction.equals("out")) {
                        rootEntity = r.getForeignEntity();
                    }
                    return rootEntitiesInQuery.contains(rootEntity);
                }).collect(Collectors.toList());
                List<Attribute> filteringColumns = null;
                for (Relationship currRelationship : mappedRelationships) {
                    Entity enteringEntity = null;
                    Entity rootEntity = null;
                    if (direction.equals("in")) {
                        enteringEntity = currRelationship.getForeignEntity();
                        rootEntity = currRelationship.getParentEntity();
                        filteringColumns = currRelationship.getFromColumns();
                    } else if (direction.equals("out")) {
                        enteringEntity = currRelationship.getParentEntity();
                        rootEntity = currRelationship.getForeignEntity();
                        filteringColumns = currRelationship.getToColumns();
                    }
                    int rootEntityId = rootEntity.getSchemaPosition();
                    int enteringEntityId = enteringEntity.getSchemaPosition();
                    List<String> rootNodeIds = Arrays.asList(roots).stream().filter(id -> {
                        int tableId = Integer.parseInt(id.split("_")[0]);
                        return tableId == rootEntityId || tableId == enteringEntityId;
                    }).map(id -> id.substring(id.indexOf("_") + 1)).collect(Collectors.toList());
                    queryResult = this.dbQueryEngine.expandRelationship(enteringEntity, rootEntity, currRelationship.getFromColumns(), currRelationship.getToColumns(), rootNodeIds, direction, datasource);
                    List<String> newNodeIds = new ArrayList<String>(rootNodeIds);
                    String[] idParts = rootNodeIds.get(0).split("_");
                    if (idParts.length > 1) {
                        Integer idTargetIndexToExtract = null;
                        if (direction.equals("out")) {
                            idTargetIndexToExtract = currRelationship.getFromColumns().get(0).getOrdinalPosition() - 1;
                        } else if (direction.equals("in")) {
                            idTargetIndexToExtract = currRelationship.getToColumns().get(0).getOrdinalPosition() - 1;
                        }
                        if (idTargetIndexToExtract != null) {
                            int index = idTargetIndexToExtract;
                            newNodeIds = newNodeIds.stream().map(id -> {
                                String[] splits = id.split("_");
                                return splits[index];
                            }).collect(Collectors.toList());
                        }
                    }
                    outCountResults = this.getOutRelationshipsCount(datasource, enteringEntity, filteringColumns, newNodeIds);
                    inCountResults = this.getInRelationshipsCount(datasource, enteringEntity, filteringColumns, newNodeIds);
                    GraphData enteringNodesGraphData = this.dataFetcher.mapResultSet(queryResult, enteringEntity, outCountResults, inCountResults);
                    graphDataCollection.add(enteringNodesGraphData);
                    GraphData enteringEdgesGraphData = this.dataFetcher.buildEdgesFromJoinResultAndRelationship(queryResult, currRelationship, direction);
                    graphDataCollection.add(enteringEdgesGraphData);
                }
            } else {
                edgeClass = this.dataFetcher.getMapper().getAggregatorEdgeByEdgeTypeName(edgeClassName).getEdgeType();
                VertexType joinVertexType = this.dataFetcher.getMapper().getJoinVertexTypeByAggregatorEdge(((ElementType)((Object)edgeClass)).getName());
                Entity joinTable = this.dataFetcher.getMapper().getEntityByVertexType(joinVertexType);
                LinkedList<CanonicalRelationship> joinTableRelationships = new LinkedList<CanonicalRelationship>(joinTable.getOutCanonicalRelationships());
                if (joinTableRelationships.size() != 2) {
                    throw new RDBMSProviderAggregationException("Wrong relationships mapping: the aggregated " + joinTable.getName() + " join table does not have 2 out relationships to represent the N-N relationship.");
                }
                Relationship firstJoinTableRelationship = null;
                Relationship secondJoinTableRelationship = null;
                Entity firstExternalEntity = null;
                Entity secondExternalEntity = null;
                if (direction.equals("out")) {
                    firstJoinTableRelationship = (Relationship)joinTableRelationships.get(0);
                    secondJoinTableRelationship = (Relationship)joinTableRelationships.get(1);
                    firstExternalEntity = firstJoinTableRelationship.getParentEntity();
                    secondExternalEntity = secondJoinTableRelationship.getParentEntity();
                } else if (direction.equals("in")) {
                    firstJoinTableRelationship = (Relationship)joinTableRelationships.get(1);
                    secondJoinTableRelationship = (Relationship)joinTableRelationships.get(0);
                    firstExternalEntity = firstJoinTableRelationship.getParentEntity();
                    secondExternalEntity = secondJoinTableRelationship.getParentEntity();
                }
                List<String> rootNodeIds = Arrays.asList(roots).stream().map(id -> id.substring(id.indexOf("_") + 1)).collect(Collectors.toList());
                QueryResult joinTableRecordsResult = this.dbQueryEngine.expandRelationship(joinTable, firstExternalEntity, firstJoinTableRelationship.getFromColumns(), firstJoinTableRelationship.getToColumns(), rootNodeIds, direction, datasource);
                GraphData enteringEdgesGraphData = this.dataFetcher.buildEdgesFromJoinTableRecords(joinTableRecordsResult, edgeClassName, firstExternalEntity, joinTable, secondExternalEntity, direction);
                graphDataCollection.add(enteringEdgesGraphData);
                rootNodeIds = enteringEdgesGraphData.getEdges().stream().map(cytoData -> {
                    String id = cytoData.getData().getId();
                    id = id.substring(id.indexOf("_") + 1);
                    return id;
                }).collect(Collectors.toList());
                queryResult = this.dbQueryEngine.expandRelationship(secondExternalEntity, joinTable, secondJoinTableRelationship.getFromColumns(), secondJoinTableRelationship.getToColumns(), rootNodeIds, direction, datasource);
                Map<String, List<RelationshipQueryResult>> direction2countQueryResults = this.getRelationshipsCountAggregationCase(datasource, secondExternalEntity);
                outCountResults = direction2countQueryResults.get("out");
                inCountResults = direction2countQueryResults.get("in");
                GraphData enteringNodesGraphData = this.dataFetcher.mapResultSet(queryResult, secondExternalEntity, outCountResults, inCountResults);
                graphDataCollection.add(enteringNodesGraphData);
            }
        }
        catch (Exception e) {
            throw new RDBMSProviderRuntimeException(e);
        }
        finally {
            if (queryResult != null) {
                queryResult.close();
            }
            for (RelationshipQueryResult outRelationshipsQueryResult : outCountResults) {
                if (outRelationshipsQueryResult == null) continue;
                outRelationshipsQueryResult.close();
            }
            for (RelationshipQueryResult inRelationshipsQueryResult : inCountResults) {
                if (inRelationshipsQueryResult == null) continue;
                inRelationshipsQueryResult.close();
            }
        }
        this.dbQueryEngine.close();
        GraphData graphData = this.collectGraphDatasInSingle(graphDataCollection);
        return graphData;
    }

    public GraphData load(DataSourceInfo datasource, String[] ids) {
        this.prepareMapperAndDataFetcher(datasource);
        LinkedHashMap<Entity, List<String>> tableName2ids = new LinkedHashMap<Entity, List<String>>();
        for (String currentId : ids) {
            int tableId = Integer.parseInt(currentId.split("_")[0]);
            Entity currentTable = this.dataFetcher.getMapper().getEntityBySchemaPosition(tableId);
            if (!tableName2ids.containsKey(currentTable)) {
                LinkedList currentIds = new LinkedList();
                tableName2ids.put(currentTable, currentIds);
            }
            currentId = currentId.substring(currentId.indexOf("_") + 1);
            ((List)tableName2ids.get(currentTable)).add(currentId);
        }
        List<String> queryDtos = this.dbQueryEngine.buildLoadQueries(tableName2ids);
        LinkedList<GraphData> graphDataCollection = new LinkedList<GraphData>();
        for (String currentQueryDto : queryDtos) {
            GraphData currGraphData = this.fetchData(datasource, currentQueryDto, ids.length);
            graphDataCollection.add(currGraphData);
        }
        this.dbQueryEngine.close();
        GraphData graphData = this.collectGraphDatasInSingle(graphDataCollection);
        return graphData;
    }

    public GraphData loadFromClass(DataSourceInfo datasource, String className, int limit) {
        String query = "select " + className + ".* from " + className + " limit " + limit;
        return this.fetchData(datasource, query, limit);
    }

    public GraphData loadFromClass(DataSourceInfo datasource, String className, String propName, String propertyValue, int limit) {
        String query = "select " + className + ".* from " + className + " where " + propName + " = '" + propertyValue + "' limit " + limit;
        return this.fetchData(datasource, query, limit);
    }

    public boolean testConnection(DataSourceInfo datasource) {
        try (Connection connection = DBSourceConnection.getConnection(datasource);){
            this.log.info("connection works fine:: '{}' ", (Object)datasource.getId());
        }
        catch (Exception e) {
            throw new RDBMSProviderRuntimeException(e);
        }
        return true;
    }

    private GraphData collectGraphDatasInSingle(List<GraphData> graphDataCollection) {
        LinkedHashMap nodeClasses = new LinkedHashMap();
        LinkedHashMap edgeClasses = new LinkedHashMap();
        LinkedHashSet nodes = new LinkedHashSet();
        LinkedHashSet edges = new LinkedHashSet();
        for (GraphData currentGraphData : graphDataCollection) {
            nodes.addAll(currentGraphData.getNodes());
            edges.addAll(currentGraphData.getEdges());
            nodeClasses.putAll(currentGraphData.getNodesClasses());
            edgeClasses.putAll(currentGraphData.getEdgesClasses());
        }
        return new GraphData(nodeClasses, edgeClasses, nodes, edges, false);
    }

    public List<RelationshipQueryResult> getOutRelationshipsCount(DataSourceInfo datasource, Entity entity) {
        return this.getOutRelationshipsCount(datasource, entity, null, null);
    }

    public List<RelationshipQueryResult> getOutRelationshipsCount(DataSourceInfo datasource, Entity entity, List<Attribute> filteringColumns, List<String> filteringRootNodeIds) {
        LinkedList<RelationshipQueryResult> countResults = new LinkedList<RelationshipQueryResult>();
        for (Relationship relationship : entity.getAllOutCanonicalRelationships()) {
            String relationshipName = this.dataFetcher.getMapper().getRelationship2edgeType().get(relationship).getName();
            try {
                RelationshipQueryResult queryResult = this.dbQueryEngine.performConnectionCountQueryGroupedByElement(relationship, "foreignTable", filteringColumns, filteringRootNodeIds, datasource, relationshipName);
                countResults.add(queryResult);
            }
            catch (SQLException e) {
                this.log.error("unable to get OUT relationship count for :: " + relationship, (Throwable)e);
            }
        }
        return countResults;
    }

    public List<RelationshipQueryResult> getInRelationshipsCount(DataSourceInfo datasource, Entity entity) {
        return this.getInRelationshipsCount(datasource, entity, null, null);
    }

    public List<RelationshipQueryResult> getInRelationshipsCount(DataSourceInfo datasource, Entity entity, List<Attribute> filteringColumns, List<String> filteringRootNodeIds) {
        LinkedList<RelationshipQueryResult> countResults = new LinkedList<RelationshipQueryResult>();
        for (Relationship relationship : entity.getAllInCanonicalRelationships()) {
            String relationshipName = this.dataFetcher.getMapper().getRelationship2edgeType().get(relationship).getName();
            try {
                RelationshipQueryResult queryResult = this.dbQueryEngine.performConnectionCountQueryGroupedByElement(relationship, "parentTable", filteringColumns, filteringRootNodeIds, datasource, relationshipName);
                countResults.add(queryResult);
            }
            catch (SQLException e) {
                this.log.error("unable to get IN relationship count for :: " + relationship, (Throwable)e);
            }
        }
        return countResults;
    }

    private Map<String, List<RelationshipQueryResult>> getRelationshipsCountAggregationCase(DataSourceInfo datasource, Entity entity) {
        return this.getRelationshipsCountAggregationCase(datasource, entity, null, null);
    }

    private Map<String, List<RelationshipQueryResult>> getRelationshipsCountAggregationCase(DataSourceInfo datasource, Entity entity, List<Attribute> filteringColumns, List<String> filteringRootNodeIds) {
        RelationshipQueryResult queryResult;
        AggregatorEdge aggregatorEdge;
        VertexType aggregatedVertexType;
        String direction;
        String relationshipName;
        LinkedList<RelationshipQueryResult> outCountResults = new LinkedList<RelationshipQueryResult>();
        LinkedList<RelationshipQueryResult> inCountResults = new LinkedList<RelationshipQueryResult>();
        for (Relationship relationship : entity.getAllOutCanonicalRelationships()) {
            relationshipName = null;
            direction = null;
            Entity currParentEntity = relationship.getParentEntity();
            if (currParentEntity.isAggregableJoinTable()) {
                VertexType outVertexType = this.dataFetcher.getMapper().getVertexTypeByEntity(relationship.getForeignEntity());
                aggregatedVertexType = this.dataFetcher.getMapper().getVertexTypeByEntity(currParentEntity);
                aggregatorEdge = this.dataFetcher.getMapper().getAggregatorEdgeByJoinVertexTypeName(aggregatedVertexType.getName());
                relationshipName = aggregatorEdge.getEdgeType().getName();
                direction = outVertexType.getName().equals(aggregatorEdge.getOutVertexClassName()) ? "out" : "in";
            } else {
                direction = "out";
                relationshipName = this.dataFetcher.getMapper().getRelationship2edgeType().get(relationship).getName();
            }
            try {
                queryResult = this.dbQueryEngine.performConnectionCountQueryGroupedByElement(relationship, "foreignTable", filteringColumns, filteringRootNodeIds, datasource, relationshipName);
                if (direction.equals("out")) {
                    outCountResults.add(queryResult);
                    continue;
                }
                inCountResults.add(queryResult);
            }
            catch (SQLException e) {
                this.log.error("unable to get OUT relationship count for :: " + relationship, (Throwable)e);
            }
        }
        for (Relationship relationship : entity.getAllInCanonicalRelationships()) {
            relationshipName = null;
            direction = null;
            Entity currForeignEntity = relationship.getForeignEntity();
            if (currForeignEntity.isAggregableJoinTable()) {
                VertexType inVertexType = this.dataFetcher.getMapper().getVertexTypeByEntity(relationship.getParentEntity());
                aggregatedVertexType = this.dataFetcher.getMapper().getVertexTypeByEntity(currForeignEntity);
                aggregatorEdge = this.dataFetcher.getMapper().getAggregatorEdgeByJoinVertexTypeName(aggregatedVertexType.getName());
                relationshipName = aggregatorEdge.getEdgeType().getName();
                direction = inVertexType.getName().equals(aggregatorEdge.getInVertexClassName()) ? "in" : "out";
            } else {
                direction = "in";
                relationshipName = this.dataFetcher.getMapper().getRelationship2edgeType().get(relationship).getName();
            }
            try {
                queryResult = this.dbQueryEngine.performConnectionCountQueryGroupedByElement(relationship, "parentTable", filteringColumns, filteringRootNodeIds, datasource, relationshipName);
                if (direction.equals("out")) {
                    outCountResults.add(queryResult);
                    continue;
                }
                inCountResults.add(queryResult);
            }
            catch (SQLException e) {
                this.log.error("unable to get IN relationship count for :: " + relationship, (Throwable)e);
            }
        }
        HashMap<String, List<RelationshipQueryResult>> direction2countQueryResults = new HashMap<String, List<RelationshipQueryResult>>();
        direction2countQueryResults.put("out", outCountResults);
        direction2countQueryResults.put("in", inCountResults);
        return direction2countQueryResults;
    }

    @NotNull
    public Set<String> supportedDataSourceTypes() {
        return Sets.newHashSet((Object[])new String[]{"RDBMS_POSTGRESQL", "RDBMS_MYSQL", "RDBMS_MSSQLSERVER", "RDBMS_HSQL", "RDBMS_ORACLE", "RDBMS_DATA_WORLD"});
    }

    @NotNull
    public GraphData edges(@NotNull DataSourceInfo dataSource, @NotNull String[] fromIds, @NotNull String[] edgesLabel, @NotNull String[] toIds) {
        return null;
    }
}

