/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.dbengine;

import com.arcadeanalytics.provider.rdbms.dbengine.CommonQueryBuilder;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Attribute;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Entity;
import java.util.List;

public class PostgreSQLQueryBuilder
extends CommonQueryBuilder {
    public String buildGeospatialQuery(Entity entity, List<String> geospatialTypes) {
        String query = "select ";
        for (Attribute currentAttribute : entity.getAllAttributes()) {
            if (this.isGeospatial(geospatialTypes, currentAttribute.getDataType())) {
                query = query + "ST_AsText(" + this.quote + currentAttribute.getName() + this.quote + ") as " + currentAttribute.getName() + ",";
                continue;
            }
            query = query + this.quote + currentAttribute.getName() + this.quote + ",";
        }
        query = query.substring(0, query.length() - 1);
        String entitySchema = entity.getSchemaName();
        query = entitySchema != null ? query + " from " + entitySchema + "." + this.quote + entity.getName() + this.quote : query + " from " + this.quote + entity.getName() + this.quote;
        return query;
    }

    public boolean isGeospatial(List<String> geospatialTypes, String type) {
        return geospatialTypes.contains(type);
    }
}

