/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.factory;

import com.arcadeanalytics.provider.rdbms.exception.RDBMSProviderIOException;
import com.arcadeanalytics.provider.rdbms.strategy.WorkflowStrategy;
import com.arcadeanalytics.provider.rdbms.strategy.rdbms.AbstractDBMSModelBuildingStrategy;
import com.arcadeanalytics.provider.rdbms.strategy.rdbms.DBMSModelBuildingAggregationStrategy;
import com.arcadeanalytics.provider.rdbms.strategy.rdbms.DBMSSimpleModelBuildingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrategyFactory {
    private final Logger log = LoggerFactory.getLogger(StrategyFactory.class);

    public WorkflowStrategy buildStrategy(String chosenStrategy) throws RDBMSProviderIOException {
        AbstractDBMSModelBuildingStrategy strategy = null;
        if (chosenStrategy == null) {
            strategy = new DBMSSimpleModelBuildingStrategy();
        } else {
            switch (chosenStrategy) {
                case "interactive": {
                    strategy = new DBMSSimpleModelBuildingStrategy();
                    break;
                }
                case "interactive-aggr": {
                    strategy = new DBMSModelBuildingAggregationStrategy();
                    break;
                }
                default: {
                    this.log.error("The typed strategy doesn't exist for migration from the chosen RDBMS.\n");
                }
            }
        }
        if (strategy == null) {
            throw new RDBMSProviderIOException("Strategy not available for the chosen source.");
        }
        return strategy;
    }
}

