/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.mapper.rdbms;

import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.rdbms.context.Statistics;
import com.arcadeanalytics.provider.rdbms.dbengine.DBQueryEngine;
import com.arcadeanalytics.provider.rdbms.exception.RDBMSProviderRuntimeException;
import com.arcadeanalytics.provider.rdbms.mapper.rdbms.ER2GraphMapper;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Attribute;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Entity;
import com.arcadeanalytics.provider.rdbms.model.dbschema.HierarchicalBag;
import com.arcadeanalytics.provider.rdbms.nameresolver.NameResolver;
import com.arcadeanalytics.provider.rdbms.persistence.handler.DBMSDataTypeHandler;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Hibernate2GraphMapper
extends ER2GraphMapper {
    private static final Logger log = LoggerFactory.getLogger(Hibernate2GraphMapper.class);
    private final String xmlPath;

    public Hibernate2GraphMapper(DataSourceInfo dataSource, String xmlPath, List<String> includedTables, List<String> excludedTables, DBQueryEngine queryEngine, DBMSDataTypeHandler dataTypeHandler, String executionStrategy, NameResolver nameResolver, Statistics statistics) {
        super(dataSource, includedTables, excludedTables, queryEngine, dataTypeHandler, executionStrategy, nameResolver, statistics);
        this.xmlPath = xmlPath;
    }

    @Override
    public void buildSourceDatabaseSchema() {
        try {
            super.buildSourceDatabaseSchema();
            File xmlFile = new File(this.xmlPath);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document dom = dBuilder.parse(xmlFile);
            NodeList entities = dom.getElementsByTagName("class");
            Entity currentEntity = null;
            for (int i = 0; i < entities.getLength(); ++i) {
                Element currentEntityElement = (Element)entities.item(i);
                if (!currentEntityElement.hasAttribute("table")) {
                    log.error("XML Format error: problem in class definition, table attribute missing in the class node.\n");
                    throw new RDBMSProviderRuntimeException();
                }
                currentEntity = this.dataBaseSchema.getEntityByNameIgnoreCase(currentEntityElement.getAttribute("table"));
                if (currentEntity == null) continue;
                this.detectInheritanceAndUpdateSchema(currentEntity, currentEntityElement);
            }
            Collections.sort(this.dataBaseSchema.getEntities());
        }
        catch (Exception e) {
            throw new RDBMSProviderRuntimeException(e);
        }
    }

    private void detectInheritanceAndUpdateSchema(Entity parentEntity, Element parentEntityElement) {
        LinkedHashSet<Entity> tmp;
        NodeList subclassElements = parentEntityElement.getElementsByTagName("subclass");
        NodeList joinedSubclassElements = parentEntityElement.getElementsByTagName("joined-subclass");
        NodeList unionSubclassElements = parentEntityElement.getElementsByTagName("union-subclass");
        Element discriminatorElement = (Element)parentEntityElement.getElementsByTagName("discriminator").item(0);
        HierarchicalBag hierarchicalBag = new HierarchicalBag();
        String rootDiscriminatorValue = null;
        if (subclassElements.getLength() > 0) {
            if (parentEntityElement.hasAttribute("discriminator-value")) {
                rootDiscriminatorValue = parentEntityElement.getAttribute("discriminator-value");
            }
            this.performSubclassTagInheritance(hierarchicalBag, parentEntity, subclassElements, discriminatorElement, rootDiscriminatorValue);
        }
        if (joinedSubclassElements.getLength() > 0) {
            hierarchicalBag.setInheritancePattern("table-per-type");
            this.dataBaseSchema.getHierarchicalBags().add(hierarchicalBag);
            if (hierarchicalBag.getDepth2entities().get(parentEntity.getInheritanceLevel()) == null) {
                tmp = new LinkedHashSet<Entity>();
                tmp.add(parentEntity);
                hierarchicalBag.getDepth2entities().put(parentEntity.getInheritanceLevel(), tmp);
                parentEntity.setHierarchicalBag(hierarchicalBag);
            }
            if (discriminatorElement != null) {
                hierarchicalBag.setDiscriminatorColumn(discriminatorElement.getAttribute("column"));
            }
            this.performJoinedSubclassTagInheritance(hierarchicalBag, parentEntity, joinedSubclassElements);
        }
        if (unionSubclassElements.getLength() > 0) {
            hierarchicalBag.setInheritancePattern("table-per-concrete-type");
            this.dataBaseSchema.getHierarchicalBags().add(hierarchicalBag);
            if (hierarchicalBag.getDepth2entities().get(parentEntity.getInheritanceLevel()) == null) {
                tmp = new LinkedHashSet();
                tmp.add(parentEntity);
                hierarchicalBag.getDepth2entities().put(parentEntity.getInheritanceLevel(), tmp);
                parentEntity.setHierarchicalBag(hierarchicalBag);
            }
            if (discriminatorElement != null) {
                hierarchicalBag.setDiscriminatorColumn(discriminatorElement.getAttribute("column"));
            }
            this.performUnionSubclassTagInheritance(hierarchicalBag, parentEntity, unionSubclassElements);
        }
    }

    private void performSubclassTagInheritance(HierarchicalBag hierarchicalBag, Entity parentEntity, NodeList subclassElements, Element discriminatorElement, String rootDiscriminatorValue) {
        String currentEntityElementName = null;
        Element currentEntityElement = (Element)subclassElements.item(0);
        NodeList joinElements = currentEntityElement.getElementsByTagName("join");
        if (joinElements.getLength() > 0) {
            hierarchicalBag.setInheritancePattern("table-per-type");
            this.dataBaseSchema.getHierarchicalBags().add(hierarchicalBag);
            if (hierarchicalBag.getDepth2entities().get(parentEntity.getInheritanceLevel()) == null) {
                LinkedHashSet<Entity> tmp = new LinkedHashSet<Entity>();
                tmp.add(parentEntity);
                hierarchicalBag.getDepth2entities().put(parentEntity.getInheritanceLevel(), tmp);
                parentEntity.setHierarchicalBag(hierarchicalBag);
            }
            if (discriminatorElement != null) {
                hierarchicalBag.setDiscriminatorColumn(discriminatorElement.getAttribute("column"));
            }
            for (int j = 0; j < subclassElements.getLength(); ++j) {
                currentEntityElement = (Element)subclassElements.item(j);
                joinElements = currentEntityElement.getElementsByTagName("join");
                this.performJoinedSubclassTagInheritance(hierarchicalBag, parentEntity, joinElements);
            }
        } else {
            hierarchicalBag.setInheritancePattern("table-per-hierarchy");
            this.dataBaseSchema.getHierarchicalBags().add(hierarchicalBag);
            if (hierarchicalBag.getDepth2entities().get(parentEntity.getInheritanceLevel()) == null) {
                LinkedHashSet<Entity> tmp = new LinkedHashSet<Entity>();
                tmp.add(parentEntity);
                hierarchicalBag.getDepth2entities().put(parentEntity.getInheritanceLevel(), tmp);
                parentEntity.setHierarchicalBag(hierarchicalBag);
            }
            if (discriminatorElement != null) {
                hierarchicalBag.setDiscriminatorColumn(discriminatorElement.getAttribute("column"));
            }
            hierarchicalBag.getEntityName2discriminatorValue().put(parentEntity.getName(), rootDiscriminatorValue);
            for (int i = 0; i < subclassElements.getLength(); ++i) {
                Set<Object> tmp;
                currentEntityElement = (Element)subclassElements.item(i);
                if (!currentEntityElement.hasAttribute("name")) {
                    log.error("XML Format error: problem in subclass definition, table attribute missing in the joined-subclass nodes.\n");
                    throw new RDBMSProviderRuntimeException();
                }
                currentEntityElementName = currentEntityElement.getAttribute("name");
                Entity currentChildEntity = new Entity(currentEntityElementName, null, this.dataSource);
                String discriminatorColumnName = discriminatorElement.getAttribute("column");
                parentEntity.removeAttributeByNameIgnoreCase(discriminatorColumnName);
                parentEntity.renumberAttributesOrdinalPositions();
                currentChildEntity.setPrimaryKey(parentEntity.getPrimaryKey());
                NodeList propertiesElements = currentEntityElement.getElementsByTagName("property");
                for (int j = 0; j < propertiesElements.getLength(); ++j) {
                    Element currentPropertyElement = (Element)propertiesElements.item(j);
                    Attribute currentParentCorrespondingAttribute = parentEntity.getAttributeByNameIgnoreCase(currentPropertyElement.getAttribute("column"));
                    Attribute currentChildAttribute = new Attribute(currentParentCorrespondingAttribute.getName(), j + 1, currentParentCorrespondingAttribute.getDataType(), currentChildEntity);
                    currentChildEntity.addAttribute(currentChildAttribute);
                    parentEntity.getAttributes().remove(currentParentCorrespondingAttribute);
                }
                parentEntity.renumberAttributesOrdinalPositions();
                this.dataBaseSchema.getEntities().add(currentChildEntity);
                currentChildEntity.setParentEntity(parentEntity);
                currentChildEntity.setInheritanceLevel(parentEntity.getInheritanceLevel() + 1);
                if (hierarchicalBag.getDepth2entities().get(currentChildEntity.getInheritanceLevel()) == null) {
                    tmp = new LinkedHashSet<Entity>();
                    tmp.add(currentChildEntity);
                    hierarchicalBag.getDepth2entities().put(currentChildEntity.getInheritanceLevel(), tmp);
                } else {
                    tmp = hierarchicalBag.getDepth2entities().get(currentChildEntity.getInheritanceLevel());
                    tmp.add(currentChildEntity);
                    hierarchicalBag.getDepth2entities().put(currentChildEntity.getInheritanceLevel(), tmp);
                }
                currentChildEntity.setHierarchicalBag(hierarchicalBag);
                hierarchicalBag.getEntityName2discriminatorValue().put(currentChildEntity.getName(), currentEntityElement.getAttribute("discriminator-value"));
            }
        }
    }

    private void performJoinedSubclassTagInheritance(HierarchicalBag hierarchicalBag, Entity parentEntity, NodeList joinedSubclassElements) {
        String currentChildEntityName = null;
        for (int i = 0; i < joinedSubclassElements.getLength(); ++i) {
            Set<Object> tmp;
            Element currentChildElement = (Element)joinedSubclassElements.item(i);
            if (!currentChildElement.hasAttribute("table")) {
                log.error("XML Format error: problem in subclass definition, table attribute missing in the joined-subclass nodes.\n");
                throw new RDBMSProviderRuntimeException();
            }
            currentChildEntityName = currentChildElement.getAttribute("table");
            Entity currentChildEntity = this.dataBaseSchema.getEntityByNameIgnoreCase(currentChildEntityName);
            currentChildEntity.setParentEntity(parentEntity);
            currentChildEntity.setInheritanceLevel(parentEntity.getInheritanceLevel() + 1);
            Iterator<Attribute> it = currentChildEntity.getAttributes().iterator();
            while (it.hasNext()) {
                Attribute currentAttribute = it.next();
                if (!currentChildEntity.getPrimaryKey().getInvolvedAttributes().contains(currentAttribute)) continue;
                it.remove();
            }
            currentChildEntity.renumberAttributesOrdinalPositions();
            if (hierarchicalBag.getDepth2entities().get(currentChildEntity.getInheritanceLevel()) == null) {
                tmp = new LinkedHashSet<Entity>();
                tmp.add(currentChildEntity);
                hierarchicalBag.getDepth2entities().put(currentChildEntity.getInheritanceLevel(), tmp);
            } else {
                tmp = hierarchicalBag.getDepth2entities().get(currentChildEntity.getInheritanceLevel());
                tmp.add(currentChildEntity);
                hierarchicalBag.getDepth2entities().put(currentChildEntity.getInheritanceLevel(), tmp);
            }
            currentChildEntity.setHierarchicalBag(hierarchicalBag);
            this.detectInheritanceAndUpdateSchema(currentChildEntity, currentChildElement);
        }
    }

    void performUnionSubclassTagInheritance(HierarchicalBag hierarchicalBag, Entity parentEntity, NodeList unionSubclassElements) {
        String currentChildEntityName = null;
        for (int i = 0; i < unionSubclassElements.getLength(); ++i) {
            Set<Object> tmp;
            Attribute currentAttribute;
            Element currentChildElement = (Element)unionSubclassElements.item(i);
            if (!currentChildElement.hasAttribute("table")) {
                log.error("XML Format error: problem in subclass definition, table attribute missing in the joined-subclass nodes.\n");
                throw new RDBMSProviderRuntimeException();
            }
            currentChildEntityName = currentChildElement.getAttribute("table");
            Entity currentChildEntity = this.dataBaseSchema.getEntityByNameIgnoreCase(currentChildEntityName);
            currentChildEntity.setParentEntity(parentEntity);
            currentChildEntity.setInheritanceLevel(parentEntity.getInheritanceLevel() + 1);
            Iterator<Attribute> it = currentChildEntity.getAttributes().iterator();
            while (it.hasNext()) {
                currentAttribute = it.next();
                if (!currentChildEntity.getPrimaryKey().getInvolvedAttributes().contains(currentAttribute)) continue;
                it.remove();
            }
            currentChildEntity.renumberAttributesOrdinalPositions();
            if (hierarchicalBag.getDepth2entities().get(currentChildEntity.getInheritanceLevel()) == null) {
                tmp = new LinkedHashSet<Entity>();
                tmp.add(currentChildEntity);
                hierarchicalBag.getDepth2entities().put(currentChildEntity.getInheritanceLevel(), tmp);
            } else {
                tmp = hierarchicalBag.getDepth2entities().get(currentChildEntity.getInheritanceLevel());
                tmp.add(currentChildEntity);
                hierarchicalBag.getDepth2entities().put(currentChildEntity.getInheritanceLevel(), tmp);
            }
            currentChildEntity.setHierarchicalBag(hierarchicalBag);
            this.detectInheritanceAndUpdateSchema(currentChildEntity, currentChildElement);
            it = currentChildEntity.getAttributes().iterator();
            while (it.hasNext()) {
                currentAttribute = it.next();
                if (!parentEntity.getAttributes().contains(currentAttribute)) continue;
                it.remove();
                currentChildEntity.getInheritedAttributes().add(currentAttribute);
            }
            currentChildEntity.renumberAttributesOrdinalPositions();
        }
    }
}

