/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.model.dbschema;

import com.arcadeanalytics.provider.rdbms.model.DataSourceSchemaInfo;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Attribute;
import com.arcadeanalytics.provider.rdbms.model.dbschema.CanonicalRelationship;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Entity;
import com.arcadeanalytics.provider.rdbms.model.dbschema.HierarchicalBag;
import com.arcadeanalytics.provider.rdbms.model.dbschema.LogicalRelationship;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Relationship;
import java.util.ArrayList;
import java.util.List;

public class DataBaseSchema
implements DataSourceSchemaInfo {
    private int majorVersion;
    private int minorVersion;
    private int driverMajorVersion;
    private int driverMinorVersion;
    private String productName;
    private String productVersion;
    private List<Entity> entities;
    private List<CanonicalRelationship> canonicalRelationships;
    private List<LogicalRelationship> logicalRelationships;
    private List<HierarchicalBag> hierarchicalBags;

    public DataBaseSchema(int majorVersion, int minorVersion, int driverMajorVersion, int driverMinorVersion, String productName, String productVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.driverMajorVersion = driverMajorVersion;
        this.driverMinorVersion = driverMinorVersion;
        this.productName = productName;
        this.productVersion = productVersion;
        this.entities = new ArrayList<Entity>();
        this.canonicalRelationships = new ArrayList<CanonicalRelationship>();
        this.logicalRelationships = new ArrayList<LogicalRelationship>();
        this.hierarchicalBags = new ArrayList<HierarchicalBag>();
    }

    public DataBaseSchema() {
        this.entities = new ArrayList<Entity>();
        this.canonicalRelationships = new ArrayList<CanonicalRelationship>();
        this.logicalRelationships = new ArrayList<LogicalRelationship>();
        this.hierarchicalBags = new ArrayList<HierarchicalBag>();
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    public void setDriverMajorVersion(int driverMajorVersion) {
        this.driverMajorVersion = driverMajorVersion;
    }

    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    public void setDriverMinorVersion(int driverMinorVersion) {
        this.driverMinorVersion = driverMinorVersion;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(List<Entity> entitiess) {
        this.entities = entitiess;
    }

    public List<CanonicalRelationship> getCanonicalRelationships() {
        return this.canonicalRelationships;
    }

    public void setCanonicalRelationships(List<CanonicalRelationship> canonicalRelationships) {
        this.canonicalRelationships = canonicalRelationships;
    }

    public List<LogicalRelationship> getLogicalRelationships() {
        return this.logicalRelationships;
    }

    public void setLogicalRelationships(List<LogicalRelationship> logicalRelationships) {
        this.logicalRelationships = logicalRelationships;
    }

    public List<HierarchicalBag> getHierarchicalBags() {
        return this.hierarchicalBags;
    }

    public void setHierarchicalBags(List<HierarchicalBag> hierarchicalBags) {
        this.hierarchicalBags = hierarchicalBags;
    }

    public Entity getEntityByName(String entityName) {
        for (Entity currentEntity : this.entities) {
            if (!currentEntity.getName().equals(entityName)) continue;
            return currentEntity;
        }
        return null;
    }

    public Entity getEntityByNameIgnoreCase(String entityName) {
        for (Entity currentEntity : this.entities) {
            if (!currentEntity.getName().equalsIgnoreCase(entityName)) continue;
            return currentEntity;
        }
        return null;
    }

    public Entity getEntityByPosition(int position) {
        for (Entity currentEntity : this.entities) {
            if (currentEntity.getSchemaPosition() != position) continue;
            return currentEntity;
        }
        return null;
    }

    public Relationship getRelationshipByInvolvedEntitiesAndAttributes(Entity currentForeignEntity, Entity currentParentEntity, List<String> fromColumns, List<String> toColumns) {
        for (Relationship relationship : this.canonicalRelationships) {
            if (!relationship.getForeignEntity().getName().equals(currentForeignEntity.getName()) || !relationship.getParentEntity().getName().equals(currentParentEntity.getName()) || !this.sameAttributesInvolved(relationship.getFromColumns(), fromColumns) || !this.sameAttributesInvolved(relationship.getToColumns(), toColumns)) continue;
            return relationship;
        }
        return null;
    }

    private boolean sameAttributesInvolved(List<Attribute> columns, List<String> columnsName) {
        if (columns.size() != columnsName.size()) {
            return false;
        }
        for (String column : columnsName) {
            boolean present = false;
            for (Attribute attribute : columns) {
                if (!attribute.getName().equals(column)) continue;
                present = true;
                break;
            }
            if (present) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String s = "\n\n\n------------------------------ DB SCHEMA DESCRIPTION ------------------------------\n\n\nProduct name: " + this.productName + "\tProduct version: " + this.productVersion + "\nMajor version: " + this.majorVersion + "\tMinor Version: " + this.minorVersion + "\nDriver major version: " + this.driverMajorVersion + "\tDriver minor version: " + this.driverMinorVersion + "\n\n\n";
        s = s + "Number of Entities: " + this.entities.size() + ".\nNumber of Relationship: " + this.canonicalRelationships.size() + ".\n\n\n";
        for (Entity e : this.entities) {
            s = s + e.toString();
        }
        return s;
    }
}

