/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.model.dbschema;

import com.arcadeanalytics.provider.rdbms.model.dbschema.Attribute;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Entity;
import java.util.List;

public class Key {
    protected final Entity belongingEntity;
    protected final List<Attribute> involvedAttributes;

    public Key(Entity belongingEntity, List<Attribute> involvedAttributes) {
        this.belongingEntity = belongingEntity;
        this.involvedAttributes = involvedAttributes;
    }

    public Entity getBelongingEntity() {
        return this.belongingEntity;
    }

    public List<Attribute> getInvolvedAttributes() {
        return this.involvedAttributes;
    }

    public void addAttribute(Attribute attribute) {
        this.involvedAttributes.add(attribute);
    }

    public boolean removeAttribute(Attribute toRemove) {
        return this.involvedAttributes.remove(toRemove);
    }

    public Attribute getAttributeByName(String name) {
        Attribute toReturn = null;
        for (Attribute a : this.involvedAttributes) {
            if (!a.getName().equals(name)) continue;
            toReturn = a;
            break;
        }
        return toReturn;
    }

    public Attribute getAttributeByNameIgnoreCase(String name) {
        Attribute toReturn = null;
        for (Attribute a : this.involvedAttributes) {
            if (!a.getName().equalsIgnoreCase(name)) continue;
            toReturn = a;
            break;
        }
        return toReturn;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.belongingEntity == null ? 0 : this.belongingEntity.getName().hashCode());
        result = 31 * result + (this.involvedAttributes == null ? 0 : this.involvedAttributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        Key that = (Key)obj;
        return this.belongingEntity.getName().equals(that.belongingEntity.getName()) && this.involvedAttributes.equals(that.getInvolvedAttributes());
    }

    public String toString() {
        String s = "[";
        for (Attribute attribute : this.involvedAttributes) {
            s = s + attribute.getName() + ",";
        }
        s = s.substring(0, s.length() - 1);
        s = s + "]";
        return s;
    }
}

