/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.model.dbschema;

import com.arcadeanalytics.provider.rdbms.model.dbschema.Attribute;
import com.arcadeanalytics.provider.rdbms.model.dbschema.CanonicalRelationship;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Entity;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Relationship;
import java.util.List;

public class LogicalRelationship
extends Relationship {
    private List<Attribute> fromColumns;
    private List<Attribute> toColumns;

    public LogicalRelationship(Entity foreignEntity, Entity parentEntity) {
        this.foreignEntity = foreignEntity;
        this.parentEntity = parentEntity;
        this.direction = "direct";
    }

    public LogicalRelationship(Entity foreignEntity, Entity parentEntity, List<Attribute> fromColumns, List<Attribute> toColumns) {
        this.foreignEntity = foreignEntity;
        this.parentEntity = parentEntity;
        this.fromColumns = fromColumns;
        this.toColumns = toColumns;
        this.direction = "direct";
    }

    @Override
    public List<Attribute> getFromColumns() {
        return this.fromColumns;
    }

    public void setFromColumns(List<Attribute> columns) {
        this.fromColumns = columns;
    }

    @Override
    public List<Attribute> getToColumns() {
        return this.toColumns;
    }

    public void setToColumns(List<Attribute> columns) {
        this.toColumns = columns;
    }

    public boolean equals(Object obj) {
        CanonicalRelationship that = (CanonicalRelationship)obj;
        return this.foreignEntity.equals(that.getForeignEntity()) && this.parentEntity.equals(that.getParentEntity()) && this.fromColumns.equals(that.getFromColumns()) && this.toColumns.equals(that.getToColumns());
    }

    public String toString() {
        String fromColumns = "[";
        for (Attribute attribute : this.fromColumns) {
            fromColumns = fromColumns + attribute.getName() + ",";
        }
        fromColumns = fromColumns.substring(0, fromColumns.length() - 1);
        fromColumns = fromColumns + "]";
        String toColumns = "[";
        for (Attribute attribute : this.toColumns) {
            toColumns = toColumns + attribute.getName() + ",";
        }
        toColumns = toColumns.substring(0, toColumns.length() - 1);
        toColumns = toColumns + "]";
        return "LogicalRelationship [foreignEntity=" + this.foreignEntity.getName() + ", parentEntity=" + this.parentEntity.getName() + ", From Columns=" + fromColumns + ", To Columns=" + toColumns + " ]";
    }
}

