/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.model.graphmodel;

import com.arcadeanalytics.provider.rdbms.model.graphmodel.ModelProperty;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ElementType
implements Comparable<ElementType> {
    protected String name;
    protected List<ModelProperty> properties;
    protected List<ModelProperty> inheritedProperties;
    protected Set<ModelProperty> allProperties;
    protected ElementType parentType;
    protected int inheritanceLevel;

    public ElementType(String type) {
        this.name = type;
        this.properties = new LinkedList<ModelProperty>();
        this.inheritedProperties = new LinkedList<ModelProperty>();
        this.allProperties = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String type) {
        this.name = type;
    }

    public List<ModelProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<ModelProperty> properties) {
        this.properties = properties;
    }

    public List<ModelProperty> getInheritedProperties() {
        return this.inheritedProperties;
    }

    public void setInheritedProperties(List<ModelProperty> inheritedProperties) {
        this.inheritedProperties = inheritedProperties;
    }

    public ElementType getParentType() {
        return this.parentType;
    }

    public void setParentType(ElementType parentType) {
        this.parentType = parentType;
    }

    public int getInheritanceLevel() {
        return this.inheritanceLevel;
    }

    public void setInheritanceLevel(int inheritanceLevel) {
        this.inheritanceLevel = inheritanceLevel;
    }

    public ModelProperty getPropertyByOrdinalPosition(int position) {
        for (ModelProperty property : this.properties) {
            if (property.getOrdinalPosition() != position) continue;
            return property;
        }
        return null;
    }

    public void removePropertyByName(String toRemove) {
        Iterator<ModelProperty> it = this.properties.iterator();
        ModelProperty currentProperty = null;
        while (it.hasNext()) {
            currentProperty = it.next();
            if (!currentProperty.getName().equals(toRemove)) continue;
            it.remove();
        }
    }

    public ModelProperty getPropertyByName(String name) {
        for (ModelProperty property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public ModelProperty getInheritedPropertyByName(String name) {
        for (ModelProperty property : this.inheritedProperties) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public ModelProperty getPropertyByNameAmongAll(String name) {
        for (ModelProperty property : this.getAllProperties()) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public Set<ModelProperty> getAllProperties() {
        if (this.allProperties == null) {
            this.allProperties = new LinkedHashSet<ModelProperty>();
            this.allProperties.addAll(this.inheritedProperties);
            this.allProperties.addAll(this.properties);
        }
        return this.allProperties;
    }

    @Override
    public int compareTo(ElementType toCompare) {
        if (this.inheritanceLevel > toCompare.getInheritanceLevel()) {
            return 1;
        }
        if (this.inheritanceLevel < toCompare.getInheritanceLevel()) {
            return -1;
        }
        return this.name.compareTo(toCompare.getName());
    }
}

