/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.model.graphmodel;

import com.arcadeanalytics.provider.rdbms.model.graphmodel.EdgeType;
import com.arcadeanalytics.provider.rdbms.model.graphmodel.ElementType;
import com.arcadeanalytics.provider.rdbms.model.graphmodel.ModelProperty;
import com.tinkerpop.blueprints.Direction;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class VertexType
extends ElementType {
    private List<EdgeType> inEdgesType = new ArrayList<EdgeType>();
    private List<EdgeType> outEdgesType = new ArrayList<EdgeType>();
    private boolean isFromJoinTable;
    private Set<String> externalKey = new LinkedHashSet<String>();
    private boolean analyzedInLastMigration = false;

    public VertexType(String vertexType) {
        super(vertexType);
    }

    public List<EdgeType> getInEdgesType() {
        return this.inEdgesType;
    }

    public void setInEdgesType(List<EdgeType> inEdgesType) {
        this.inEdgesType = inEdgesType;
    }

    public List<EdgeType> getOutEdgesType() {
        return this.outEdgesType;
    }

    public void setOutEdgesType(List<EdgeType> outEdgesType) {
        this.outEdgesType = outEdgesType;
    }

    public Set<String> getExternalKey() {
        return this.externalKey;
    }

    public void setExternalKey(Set<String> externalKey) {
        this.externalKey = externalKey;
    }

    public boolean isAnalyzedInLastMigration() {
        return this.analyzedInLastMigration;
    }

    public void setAnalyzedInLastMigration(boolean analyzedInLastMigration) {
        this.analyzedInLastMigration = analyzedInLastMigration;
    }

    public EdgeType getEdgeByName(String edgeName) {
        for (EdgeType currentEdgeType : this.inEdgesType) {
            if (!currentEdgeType.getName().equals(edgeName)) continue;
            return currentEdgeType;
        }
        for (EdgeType currentEdgeType : this.outEdgesType) {
            if (!currentEdgeType.getName().equals(edgeName)) continue;
            return currentEdgeType;
        }
        return null;
    }

    public EdgeType getEdgeByName(String name, Direction direction) {
        if (direction.equals((Object)Direction.IN)) {
            for (EdgeType currentEdgeType : this.inEdgesType) {
                if (!currentEdgeType.getName().equals(name)) continue;
                return currentEdgeType;
            }
        } else if (direction.equals((Object)Direction.OUT)) {
            for (EdgeType currentEdgeType : this.outEdgesType) {
                if (!currentEdgeType.getName().equals(name)) continue;
                return currentEdgeType;
            }
        } else if (direction.equals((Object)Direction.BOTH)) {
            return this.getEdgeByName(name);
        }
        return null;
    }

    public boolean isFromJoinTable() {
        return this.isFromJoinTable;
    }

    public void setFromJoinTable(boolean fromJoinTable) {
        this.isFromJoinTable = fromJoinTable;
    }

    public void setIsFromJoinTable(boolean isFromJoinTable) {
        this.isFromJoinTable = isFromJoinTable;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        VertexType that = (VertexType)obj;
        if (!this.name.equals(that.getName()) || this.isFromJoinTable != that.isFromJoinTable()) {
            return false;
        }
        if (!this.properties.equals(that.getProperties())) {
            return false;
        }
        return this.inEdgesType.equals(that.getInEdgesType()) && this.outEdgesType.equals(that.getOutEdgesType());
    }

    public String toString() {
        String s = "Vertex-type [type = " + this.name + ", # attributes = " + this.properties.size() + ", # inEdges: " + this.inEdgesType.size() + ", # outEdges: " + this.outEdgesType.size() + "]\nAttributes:\n";
        for (ModelProperty currentProperty : this.properties) {
            s = s + currentProperty.getOrdinalPosition() + ": " + currentProperty.getName() + " --> " + currentProperty.toString();
            if (currentProperty.isFromPrimaryKey()) {
                s = s + "(from PK)";
            }
            s = s + "\t";
        }
        return s;
    }
}

