/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.persistence.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResult {
    private final Logger log = LoggerFactory.getLogger(QueryResult.class);
    private final Connection dbConnection;
    private final Statement statement;
    private final ResultSet result;
    private final String originalQuery;

    public QueryResult(Connection connection, Statement statement, ResultSet result, String originalQuery) {
        this.dbConnection = connection;
        this.statement = statement;
        this.result = result;
        this.originalQuery = originalQuery;
    }

    public Connection getDbConnection() {
        return this.dbConnection;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public ResultSet getResult() {
        return this.result;
    }

    public String getOriginalQuery() {
        return this.originalQuery;
    }

    public void close() {
        try {
            this.statement.close();
            this.result.close();
        }
        catch (SQLException e) {
            this.log.error("", (Throwable)e);
        }
    }

    public boolean isConnectionClosed() {
        try {
            return this.dbConnection.isClosed();
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            return false;
        }
    }

    public boolean isStatementClosed() {
        try {
            return this.statement.isClosed();
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            return false;
        }
    }

    public boolean isResultSetClosed() {
        try {
            return this.result.isClosed();
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            return false;
        }
    }

    public boolean isAllClosed() {
        return this.isConnectionClosed() && this.isStatementClosed() && this.isResultSetClosed();
    }
}

