/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.strategy.rdbms;

import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.rdbms.context.Statistics;
import com.arcadeanalytics.provider.rdbms.dbengine.DBQueryEngine;
import com.arcadeanalytics.provider.rdbms.factory.DataTypeHandlerFactory;
import com.arcadeanalytics.provider.rdbms.factory.NameResolverFactory;
import com.arcadeanalytics.provider.rdbms.mapper.rdbms.ER2GraphMapper;
import com.arcadeanalytics.provider.rdbms.nameresolver.NameResolver;
import com.arcadeanalytics.provider.rdbms.persistence.handler.DBMSDataTypeHandler;
import com.arcadeanalytics.provider.rdbms.strategy.WorkflowStrategy;
import com.arcadeanalytics.provider.rdbms.util.FunctionsHandler;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDBMSModelBuildingStrategy
implements WorkflowStrategy {
    private final Logger log = LoggerFactory.getLogger(AbstractDBMSModelBuildingStrategy.class);
    protected ER2GraphMapper mapper;

    @Override
    public void executeStrategy(DataSourceInfo dataSource, String outOrientGraphUri, String chosenMapper, String xmlPath, String nameResolverConvention, List<String> includedTables, List<String> excludedTables, ODocument migrationConfigDoc, String executionStrategy, DBQueryEngine queryEngine, Statistics statistics) {
        Date globalStart = new Date();
        DataTypeHandlerFactory dataTypeHandlerFactory = new DataTypeHandlerFactory();
        DBMSDataTypeHandler handler = dataTypeHandlerFactory.buildDataTypeHandler(dataSource.getType());
        NameResolverFactory nameResolverFactory = new NameResolverFactory();
        NameResolver nameResolver = nameResolverFactory.buildNameResolver(nameResolverConvention);
        this.mapper = this.createSchemaMapper(dataSource, outOrientGraphUri, chosenMapper, xmlPath, nameResolver, handler, includedTables, excludedTables, executionStrategy, queryEngine, statistics);
        Date globalEnd = new Date();
        this.log.info("Graph model building complete in {}", (Object)FunctionsHandler.getHMSFormat(globalStart, globalEnd));
    }

    public abstract ER2GraphMapper createSchemaMapper(DataSourceInfo var1, String var2, String var3, String var4, NameResolver var5, DBMSDataTypeHandler var6, List<String> var7, List<String> var8, String var9, DBQueryEngine var10, Statistics var11);
}

