/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.executors;

import com.orientechnologies.common.concur.executors.SubExecutorService;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SubScheduledExecutorService
extends SubExecutorService
implements ScheduledExecutorService {
    public SubScheduledExecutorService(ScheduledThreadPoolExecutor executorService) {
        super(executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        this.acquireAlive();
        try {
            if (this.isAlive()) {
                ScheduledRunnableTask wrapped = new ScheduledRunnableTask(command, false);
                wrapped.acquireExecution();
                try {
                    wrapped.setFuture(this.getExecutorService().schedule(wrapped, delay, unit));
                    ScheduledFuture scheduledFuture = this.register(wrapped);
                    return scheduledFuture;
                }
                finally {
                    wrapped.releaseExecution();
                }
            }
            ScheduledFuture scheduledFuture = (ScheduledFuture)this.throwRejected(command);
            return scheduledFuture;
        }
        finally {
            this.releaseAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        this.acquireAlive();
        try {
            if (this.isAlive()) {
                ScheduledCallableTask<V> wrapped = new ScheduledCallableTask<V>(callable, false);
                wrapped.acquireExecution();
                try {
                    wrapped.setFuture(this.getExecutorService().schedule(wrapped, delay, unit));
                    ScheduledFuture scheduledFuture = this.register(wrapped);
                    return scheduledFuture;
                }
                finally {
                    wrapped.releaseExecution();
                }
            }
            ScheduledFuture scheduledFuture = (ScheduledFuture)this.throwRejected(callable);
            return scheduledFuture;
        }
        finally {
            this.releaseAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        this.acquireAlive();
        try {
            if (this.isAlive()) {
                ScheduledRunnableTask wrapped = new ScheduledRunnableTask(command, true);
                wrapped.acquireExecution();
                try {
                    wrapped.setFuture(this.getExecutorService().scheduleAtFixedRate(wrapped, initialDelay, period, unit));
                    ScheduledFuture scheduledFuture = this.register(wrapped);
                    return scheduledFuture;
                }
                finally {
                    wrapped.releaseExecution();
                }
            }
            ScheduledFuture scheduledFuture = (ScheduledFuture)this.throwRejected(command);
            return scheduledFuture;
        }
        finally {
            this.releaseAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        this.acquireAlive();
        try {
            if (this.isAlive()) {
                ScheduledRunnableTask wrapped = new ScheduledRunnableTask(command, true);
                wrapped.acquireExecution();
                try {
                    wrapped.setFuture(this.getExecutorService().scheduleWithFixedDelay(wrapped, initialDelay, delay, unit));
                    ScheduledFuture scheduledFuture = this.register(wrapped);
                    return scheduledFuture;
                }
                finally {
                    wrapped.releaseExecution();
                }
            }
            ScheduledFuture scheduledFuture = (ScheduledFuture)this.throwRejected(command);
            return scheduledFuture;
        }
        finally {
            this.releaseAlive();
        }
    }

    @Override
    protected ScheduledThreadPoolExecutor getExecutorService() {
        return (ScheduledThreadPoolExecutor)super.getExecutorService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shutdownTasks(Set<SubExecutorService.Task> tasks) {
        ScheduledThreadPoolExecutor executorService = this.getExecutorService();
        BlockingQueue<Runnable> queue = executorService.getQueue();
        boolean abortPeriodic = !executorService.getContinueExistingPeriodicTasksAfterShutdownPolicy();
        boolean abortDelayed = !executorService.getExecuteExistingDelayedTasksAfterShutdownPolicy();
        for (SubExecutorService.Task task : new ArrayList<SubExecutorService.Task>(tasks)) {
            if (!(task instanceof ScheduledTask)) continue;
            ScheduledTask scheduledTask = (ScheduledTask)task;
            boolean cancelled = task.isCancelled();
            if (scheduledTask.isPeriodic()) {
                if (!abortPeriodic && !cancelled) continue;
                task.acquireExecution();
                try {
                    if (queue.remove(task.getFuture())) {
                        try {
                            if (cancelled) continue;
                            task.cancel(false);
                            continue;
                        }
                        finally {
                            this.unregister(task);
                            continue;
                        }
                    }
                    if (!cancelled) {
                        task.cancel(false);
                    }
                    this.unregister(task);
                    continue;
                }
                finally {
                    task.releaseExecution();
                    continue;
                }
            }
            if (!abortDelayed && !cancelled || !queue.remove(task.getFuture())) continue;
            try {
                if (cancelled) continue;
                task.cancel(false);
            }
            finally {
                this.unregister(task);
            }
        }
        super.shutdownTasks(tasks);
    }

    protected class ScheduledCallableTask<V>
    extends SubExecutorService.CallableTask<V>
    implements ScheduledTask<V> {
        private final boolean periodic;

        public ScheduledCallableTask(Callable<V> callable, boolean periodic) {
            super(callable, !periodic);
            this.periodic = periodic;
        }

        @Override
        public ScheduledFuture<V> getFuture() {
            return (ScheduledFuture)super.getFuture();
        }

        @Override
        public void setFuture(ScheduledFuture<V> future) {
            super.setFuture(future);
        }

        @Override
        public boolean isPeriodic() {
            return this.periodic;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.getFuture().getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.getFuture().compareTo(o);
        }
    }

    protected class ScheduledRunnableTask<V>
    extends SubExecutorService.RunnableTask<V>
    implements ScheduledTask<V> {
        private final boolean periodic;

        public ScheduledRunnableTask(Runnable runnable, boolean periodic) {
            super(runnable, !periodic);
            this.periodic = periodic;
        }

        @Override
        public ScheduledFuture<V> getFuture() {
            return (ScheduledFuture)super.getFuture();
        }

        @Override
        public void setFuture(ScheduledFuture<V> future) {
            super.setFuture(future);
        }

        @Override
        public boolean isPeriodic() {
            return this.periodic;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.getFuture().getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.getFuture().compareTo(o);
        }
    }

    protected static interface ScheduledTask<V>
    extends SubExecutorService.Task<V>,
    ScheduledFuture<V> {
        @Override
        public ScheduledFuture<V> getFuture();

        @Override
        public void setFuture(ScheduledFuture<V> var1);

        public boolean isPeriodic();
    }
}

