/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization;

import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OSafeBinaryConverter;
import com.orientechnologies.common.serialization.OUnsafeBinaryConverter;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;

public class OBinaryConverterFactory {
    private static final boolean unsafeWasDetected;

    public static OBinaryConverter getConverter() {
        boolean useUnsafe = OGlobalConfiguration.MEMORY_USE_UNSAFE.getValueAsBoolean();
        if (useUnsafe && unsafeWasDetected) {
            return OUnsafeBinaryConverter.INSTANCE;
        }
        return OSafeBinaryConverter.INSTANCE;
    }

    static {
        boolean unsafeDetected = false;
        try {
            Class<?> sunClass = Class.forName("sun.misc.Unsafe");
            unsafeDetected = sunClass != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        unsafeWasDetected = unsafeDetected;
    }
}

