/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OBeginTransactionResponse;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.client.remote.message.tx.IndexChange;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OBeginTransactionRequest
implements OBinaryRequest<OBeginTransactionResponse> {
    private int txId;
    private boolean usingLog;
    private boolean hasContent;
    private List<ORecordOperationRequest> operations;
    private List<IndexChange> indexChanges;

    public OBeginTransactionRequest(int txId, boolean hasContent, boolean usingLog, Iterable<ORecordOperation> operations, Map<String, OTransactionIndexChanges> indexChanges) {
        this.txId = txId;
        this.hasContent = hasContent;
        this.usingLog = usingLog;
        this.indexChanges = new ArrayList<IndexChange>();
        this.operations = new ArrayList<ORecordOperationRequest>();
        if (hasContent) {
            for (ORecordOperation oRecordOperation : operations) {
                if (oRecordOperation.type == 0) continue;
                ORecordOperationRequest request = new ORecordOperationRequest();
                request.setType(oRecordOperation.type);
                request.setVersion(oRecordOperation.getRecord().getVersion());
                request.setId(oRecordOperation.getRecord().getIdentity());
                request.setRecordType(ORecordInternal.getRecordType(oRecordOperation.getRecord()));
                switch (oRecordOperation.type) {
                    case 1: 
                    case 3: {
                        request.setRecord(ORecordSerializerNetworkV37.INSTANCE.toStream(oRecordOperation.getRecord(), false));
                        request.setContentChanged(ORecordInternal.isContentChanged(oRecordOperation.getRecord()));
                    }
                }
                this.operations.add(request);
            }
            for (Map.Entry entry : indexChanges.entrySet()) {
                this.indexChanges.add(new IndexChange((String)entry.getKey(), (OTransactionIndexChanges)entry.getValue()));
            }
        }
    }

    public OBeginTransactionRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        ORecordSerializerNetworkV37 serializer = ORecordSerializerNetworkV37.INSTANCE;
        network.writeInt(this.txId);
        network.writeBoolean(this.hasContent);
        network.writeBoolean(this.usingLog);
        if (this.hasContent) {
            for (ORecordOperationRequest txEntry : this.operations) {
                OMessageHelper.writeTransactionEntry(network, txEntry, serializer);
            }
            network.writeByte((byte)0);
            OMessageHelper.writeTransactionIndexChanges(network, serializer, this.indexChanges);
        }
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.txId = channel.readInt();
        this.hasContent = channel.readBoolean();
        this.usingLog = channel.readBoolean();
        this.operations = new ArrayList<ORecordOperationRequest>();
        if (this.hasContent) {
            byte hasEntry;
            do {
                if ((hasEntry = channel.readByte()) != 1) continue;
                ORecordOperationRequest entry = OMessageHelper.readTransactionEntry(channel, serializer);
                this.operations.add(entry);
            } while (hasEntry == 1);
            this.indexChanges = OMessageHelper.readTransactionIndexChanges(channel, (ORecordSerializerNetworkV37)serializer);
        } else {
            this.indexChanges = new ArrayList<IndexChange>();
        }
    }

    @Override
    public byte getCommand() {
        return 61;
    }

    @Override
    public OBeginTransactionResponse createResponse() {
        return new OBeginTransactionResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeBeginTransaction(this);
    }

    @Override
    public String getDescription() {
        return "Begin Transaction";
    }

    public List<ORecordOperationRequest> getOperations() {
        return this.operations;
    }

    public List<IndexChange> getIndexChanges() {
        return this.indexChanges;
    }

    public int getTxId() {
        return this.txId;
    }

    public boolean isUsingLog() {
        return this.usingLog;
    }

    public boolean isHasContent() {
        return this.hasContent;
    }
}

