/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.common.log.OLogManager;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OSoftRefsHashMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private final Map<K, SoftReference<V>> hashCodes = new ConcurrentHashMap<K, SoftReference<V>>();
    private final Map<SoftReference<V>, K> reverseLookup = new ConcurrentHashMap<SoftReference<V>, K>();
    private final ReferenceQueue<V> refQueue = new ReferenceQueue();

    @Override
    public V get(Object key) {
        this.evictStaleEntries();
        V result = null;
        SoftReference<V> soft_ref = this.hashCodes.get(key);
        if (soft_ref != null && (result = (V)soft_ref.get()) == null) {
            this.hashCodes.remove(key);
            this.reverseLookup.remove(soft_ref);
        }
        return result;
    }

    private void evictStaleEntries() {
        Reference<V> sv;
        int evicted = 0;
        while ((sv = this.refQueue.poll()) != null) {
            K key = this.reverseLookup.remove(sv);
            if (key == null) continue;
            this.hashCodes.remove(key);
            ++evicted;
        }
        if (evicted > 0) {
            OLogManager.instance().debug((Object)this, "Evicted %d items", evicted);
        }
    }

    @Override
    public V put(K key, V value) {
        this.evictStaleEntries();
        SoftReference<V> soft_ref = new SoftReference<V>(value, this.refQueue);
        this.reverseLookup.put((SoftReference<K>)soft_ref, (SoftReference<V>)key);
        SoftReference<V> result = this.hashCodes.put(key, soft_ref);
        if (result == null) {
            return null;
        }
        this.reverseLookup.remove(result);
        return result.get();
    }

    @Override
    public V remove(Object key) {
        this.evictStaleEntries();
        SoftReference<V> result = this.hashCodes.remove(key);
        if (result == null) {
            return null;
        }
        return result.get();
    }

    @Override
    public void clear() {
        this.hashCodes.clear();
        this.reverseLookup.clear();
    }

    @Override
    public int size() {
        this.evictStaleEntries();
        return this.hashCodes.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.evictStaleEntries();
        LinkedHashSet<Map.Entry<K, V>> result = new LinkedHashSet<Map.Entry<K, V>>();
        for (final Map.Entry<K, SoftReference<V>> entry : this.hashCodes.entrySet()) {
            final V value = entry.getValue().get();
            if (value == null) continue;
            result.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return entry.getKey();
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(V v) {
                    entry.setValue(new SoftReference(v, OSoftRefsHashMap.this.refQueue));
                    return value;
                }
            });
        }
        return result;
    }
}

