/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabasePoolImpl;
import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.ODefaultEmbeddedDatabaseInstanceFactory;
import com.orientechnologies.orient.core.db.OEmbeddedDatabaseInstanceFactory;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentEmbedded;
import com.orientechnologies.orient.core.engine.OEngine;
import com.orientechnologies.orient.core.engine.OMemoryAndLocalPaginatedEnginesInitializer;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.disk.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class OrientDBEmbedded
implements OrientDBInternal {
    private static final AtomicInteger nextStorageId = new AtomicInteger();
    protected final Map<String, OAbstractPaginatedStorage> storages = new HashMap<String, OAbstractPaginatedStorage>();
    protected final Set<ODatabasePoolInternal> pools = new HashSet<ODatabasePoolInternal>();
    protected final OrientDBConfig configurations;
    protected final String basePath;
    protected final OEngine memory;
    protected final OEngine disk;
    protected final Orient orient;
    private volatile boolean open = true;
    private volatile OEmbeddedDatabaseInstanceFactory factory = new ODefaultEmbeddedDatabaseInstanceFactory();
    private TimerTask autoCloseTimer = null;
    protected final long maxWALSegmentSize;

    public OrientDBEmbedded(String directoryPath, OrientDBConfig configurations, Orient orient) {
        this.orient = orient;
        orient.onEmbeddedFactoryInit(this);
        this.memory = orient.getEngine("memory");
        this.disk = orient.getEngine("plocal");
        directoryPath = directoryPath.trim();
        if (directoryPath.length() != 0) {
            File dirFile = new File(directoryPath);
            if (!dirFile.exists()) {
                OLogManager.instance().infoNoDb(this, "Directory " + dirFile + " does not exist, try to create it.", new Object[0]);
                if (!dirFile.mkdirs()) {
                    OLogManager.instance().errorNoDb(this, "Can not create directory " + dirFile, null, new Object[0]);
                }
            }
            this.basePath = dirFile.getAbsolutePath();
        } else {
            this.basePath = null;
        }
        OrientDBConfig orientDBConfig = this.configurations = configurations != null ? configurations : OrientDBConfig.defaultConfig();
        if (this.basePath == null) {
            this.maxWALSegmentSize = -1L;
        } else {
            try {
                this.maxWALSegmentSize = this.calculateInitialMaxWALSegSize(configurations);
                if (this.maxWALSegmentSize <= 0L) {
                    throw new ODatabaseException("Invalid configuration settings. Can not set maximum size of WAL segment");
                }
                OLogManager.instance().infoNoDb(this, "WAL maximum segment size is set to %,d MB", this.maxWALSegmentSize / 1024L / 1024L);
            }
            catch (IOException e) {
                throw OException.wrapException(new ODatabaseException("Cannot initialize OrientDB engine"), e);
            }
        }
        OMemoryAndLocalPaginatedEnginesInitializer.INSTANCE.initialize();
        orient.addOrientDB(this);
        boolean autoClose = this.configurations.getConfigurations().getValueAsBoolean(OGlobalConfiguration.AUTO_CLOSE_AFTER_DELAY);
        if (autoClose) {
            int autoCloseDelay = this.configurations.getConfigurations().getValueAsInteger(OGlobalConfiguration.AUTO_CLOSE_DELAY);
            long delay = autoCloseDelay * 60 * 1000;
            this.initAutoClose(delay);
        }
    }

    public void initAutoClose(long delay) {
        long scheduleTime = delay / 3L;
        this.autoCloseTimer = this.orient.scheduleTask(() -> this.orient.submit(() -> this.checkAndCloseStorages(delay)), scheduleTime, scheduleTime);
    }

    private synchronized void checkAndCloseStorages(long delay) {
        HashSet<String> toClose = new HashSet<String>();
        for (OAbstractPaginatedStorage oAbstractPaginatedStorage : this.storages.values()) {
            long currentTime;
            if (!oAbstractPaginatedStorage.getType().equalsIgnoreCase(ODatabaseType.PLOCAL.name()) || oAbstractPaginatedStorage.getSessionCount() != 0 || (currentTime = System.currentTimeMillis()) <= oAbstractPaginatedStorage.getLastCloseTime() + delay) continue;
            toClose.add(oAbstractPaginatedStorage.getName());
        }
        for (String string : toClose) {
            this.forceDatabaseClose(string);
        }
    }

    private long calculateInitialMaxWALSegSize(OrientDBConfig configurations) throws IOException {
        OContextConfiguration config;
        OContextConfiguration config2;
        OContextConfiguration config3;
        String walPath = configurations != null ? ((config3 = configurations.getConfigurations()) != null ? config3.getValueAsString(OGlobalConfiguration.WAL_LOCATION) : OGlobalConfiguration.WAL_LOCATION.getValueAsString()) : OGlobalConfiguration.WAL_LOCATION.getValueAsString();
        if (walPath == null) {
            walPath = this.basePath;
        }
        FileStore fileStore = Files.getFileStore(Paths.get(walPath, new String[0]));
        long freeSpace = fileStore.getUsableSpace();
        long filesSize = Files.walk(Paths.get(walPath, new String[0]), new FileVisitOption[0]).mapToLong(p -> p.toFile().isFile() ? p.toFile().length() : 0L).sum();
        long maxSegSize = configurations != null ? ((config2 = configurations.getConfigurations()) != null ? config2.getValueAsLong(OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE) * 1024L * 1024L : OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE.getValueAsLong() * 1024L * 1024L) : OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE.getValueAsLong() * 1024L * 1024L;
        if (maxSegSize <= 0L) {
            OContextConfiguration config4;
            int sizePercent = configurations != null ? ((config4 = configurations.getConfigurations()) != null ? config4.getValueAsInteger(OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE_PERCENT) : OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE_PERCENT.getValueAsInteger()) : OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE_PERCENT.getValueAsInteger();
            if (sizePercent <= 0) {
                throw new ODatabaseException("Invalid configuration settings. Can not set maximum size of WAL segment");
            }
            maxSegSize = (freeSpace + filesSize) / 100L * (long)sizePercent;
        }
        long minSegSizeLimit = (long)((double)freeSpace * 0.25);
        long minSegSize = 0L;
        if (configurations != null && (config = configurations.getConfigurations()) != null) {
            minSegSize = config.getValueAsLong(OGlobalConfiguration.WAL_MIN_SEG_SIZE) * 1024L * 1024L;
        }
        if (minSegSize <= 0L) {
            minSegSize = OGlobalConfiguration.WAL_MIN_SEG_SIZE.getValueAsLong() * 1024L * 1024L;
        }
        if (minSegSize > minSegSizeLimit) {
            minSegSize = minSegSizeLimit;
        }
        if (minSegSize > 0L && maxSegSize < minSegSize) {
            maxSegSize = minSegSize;
        }
        return maxSegSize;
    }

    @Override
    public ODatabaseDocumentInternal open(String name, String user, String password) {
        return this.open(name, user, password, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabaseDocumentEmbedded openNoAuthenticate(String name, String user) {
        try {
            ODatabaseDocumentEmbedded embedded;
            OrientDBConfig config = this.solveConfig(null);
            OrientDBEmbedded orientDBEmbedded = this;
            synchronized (orientDBEmbedded) {
                OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
                storage.open(config.getConfigurations());
                storage.incOnOpen();
                embedded = this.factory.newInstance(storage);
                embedded.init(config);
            }
            embedded.rebuildIndexes();
            embedded.internalOpen(user, "nopwd", false);
            embedded.callOnOpenListeners();
            return embedded;
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Cannot open database '" + name + "'"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabaseDocumentEmbedded openNoAuthorization(String name) {
        try {
            ODatabaseDocumentEmbedded embedded;
            OrientDBConfig config = this.solveConfig(null);
            OrientDBEmbedded orientDBEmbedded = this;
            synchronized (orientDBEmbedded) {
                OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
                storage.open(config.getConfigurations());
                storage.incOnOpen();
                embedded = this.factory.newInstance(storage);
                embedded.init(config);
            }
            embedded.rebuildIndexes();
            embedded.callOnOpenListeners();
            return embedded;
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Cannot open database '" + name + "'"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabaseDocumentInternal open(String name, String user, String password, OrientDBConfig config) {
        try {
            ODatabaseDocumentEmbedded embedded;
            OrientDBEmbedded orientDBEmbedded = this;
            synchronized (orientDBEmbedded) {
                this.checkOpen();
                config = this.solveConfig(config);
                OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
                try {
                    storage.open(config.getConfigurations());
                }
                catch (RuntimeException e) {
                    if (storage != null) {
                        this.storages.remove(storage.getName());
                    } else {
                        this.storages.remove(name);
                    }
                    throw e;
                }
                storage.incOnOpen();
                embedded = this.factory.newInstance(storage);
                embedded.init(config);
            }
            embedded.rebuildIndexes();
            embedded.internalOpen(user, password);
            embedded.callOnOpenListeners();
            return embedded;
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Cannot open database '" + name + "'"), e);
        }
    }

    protected OrientDBConfig solveConfig(OrientDBConfig config) {
        if (config != null) {
            config.setParent(this.configurations);
            return config;
        }
        OrientDBConfig cfg = OrientDBConfig.defaultConfig();
        cfg.setParent(this.configurations);
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabaseDocumentInternal poolOpen(String name, String user, String password, ODatabasePoolInternal pool) {
        ODatabaseDocumentEmbedded embedded;
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            this.checkOpen();
            OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
            storage.open(pool.getConfig().getConfigurations());
            storage.incOnOpen();
            embedded = this.factory.newPoolInstance(pool, storage);
            embedded.init(pool.getConfig());
        }
        embedded.rebuildIndexes();
        embedded.internalOpen(user, password);
        embedded.callOnOpenListeners();
        return embedded;
    }

    protected OAbstractPaginatedStorage getOrInitStorage(String name) {
        OAbstractPaginatedStorage storage = this.storages.get(name);
        if (storage == null) {
            Path storagePath = Paths.get(this.buildName(name), new String[0]);
            if (OLocalPaginatedStorage.exists(storagePath)) {
                name = storagePath.getFileName().toString();
            }
            if ((storage = this.storages.get(name)) == null && (storage = (OAbstractPaginatedStorage)this.disk.createStorage(this.buildName(name), new HashMap<String, String>(), this.maxWALSegmentSize, this.generateStorageId())).exists()) {
                this.storages.put(name, storage);
            }
        }
        return storage;
    }

    protected final int generateStorageId() {
        return Math.abs(nextStorageId.getAndIncrement());
    }

    public synchronized OAbstractPaginatedStorage getStorage(String name) {
        return this.storages.get(name);
    }

    protected String buildName(String name) {
        if (this.basePath == null) {
            throw new ODatabaseException("OrientDB instanced created without physical path, only memory databases are allowed");
        }
        return this.basePath + "/" + name;
    }

    @Override
    public void create(String name, String user, String password, ODatabaseType type) {
        this.create(name, user, password, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(String name, String user, String password, ODatabaseType type, OrientDBConfig config) {
        ODatabaseDocumentEmbedded embedded;
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            if (!this.exists(name, user, password)) {
                try {
                    config = this.solveConfig(config);
                    int storageId = this.generateStorageId();
                    OAbstractPaginatedStorage storage = type == ODatabaseType.MEMORY ? (OAbstractPaginatedStorage)this.memory.createStorage(name, new HashMap<String, String>(), this.maxWALSegmentSize, storageId) : (OAbstractPaginatedStorage)this.disk.createStorage(this.buildName(name), new HashMap<String, String>(), this.maxWALSegmentSize, storageId);
                    this.storages.put(name, storage);
                    embedded = this.internalCreate(config, storage);
                }
                catch (Exception e) {
                    throw OException.wrapException(new ODatabaseException("Cannot create database '" + name + "'"), e);
                }
            } else {
                throw new ODatabaseException("Cannot create new database '" + name + "' because it already exists");
            }
        }
        embedded.callOnCreateListeners();
        ODatabaseRecordThreadLocal.instance().remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(String name, String user, String password, ODatabaseType type, String path, OrientDBConfig config) {
        ODatabaseDocumentEmbedded embedded;
        OAbstractPaginatedStorage storage;
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            if (!this.exists(name, null, null)) {
                try {
                    storage = (OAbstractPaginatedStorage)this.disk.createStorage(this.buildName(name), new HashMap<String, String>(), this.maxWALSegmentSize, this.generateStorageId());
                    embedded = this.internalCreate(config, storage);
                    this.storages.put(name, storage);
                }
                catch (Exception e) {
                    throw OException.wrapException(new ODatabaseException("Cannot restore database '" + name + "'"), e);
                }
            } else {
                throw new ODatabaseException("Cannot create new storage '" + name + "' because it already exists");
            }
        }
        storage.restoreFromIncrementalBackup(path);
        embedded.callOnCreateListeners();
        ODatabaseRecordThreadLocal.instance().remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(String name, InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) {
        try {
            OAbstractPaginatedStorage storage;
            OrientDBEmbedded orientDBEmbedded = this;
            synchronized (orientDBEmbedded) {
                storage = this.getOrInitStorage(name);
                this.storages.put(name, storage);
            }
            storage.restore(in, options, callable, iListener);
        }
        catch (Exception e) {
            OContextConfiguration configs = this.getConfigurations().getConfigurations();
            OLocalPaginatedStorage.deleteFilesFromDisc(name, configs.getValueAsInteger(OGlobalConfiguration.FILE_DELETE_RETRY), configs.getValueAsInteger(OGlobalConfiguration.FILE_DELETE_DELAY), this.buildName(name));
            throw OException.wrapException(new ODatabaseException("Cannot create database '" + name + "'"), e);
        }
    }

    protected ODatabaseDocumentEmbedded internalCreate(OrientDBConfig config, OAbstractPaginatedStorage storage) {
        storage.create(config.getConfigurations());
        ORecordSerializer serializer = ORecordSerializerFactory.instance().getDefaultRecordSerializer();
        if (serializer.toString().equals("ORecordDocument2csv")) {
            throw new ODatabaseException("Impossible to create the database with ORecordDocument2csv serializer");
        }
        storage.setRecordSerializer(serializer.toString(), serializer.getCurrentVersion());
        storage.setProperty("strictSql", "true");
        ODatabaseDocumentEmbedded embedded = this.factory.newInstance(storage);
        embedded.setSerializer(serializer);
        embedded.internalCreate(config);
        return embedded;
    }

    @Override
    public synchronized boolean exists(String name, String user, String password) {
        this.checkOpen();
        OStorage storage = this.storages.get(name);
        if (storage == null) {
            if (this.basePath != null) {
                return OLocalPaginatedStorage.exists(Paths.get(this.buildName(name), new String[0]));
            }
            return false;
        }
        return storage.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(String name, String user, String password) {
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            this.checkOpen();
        }
        ODatabaseDocumentEmbedded db = this.openNoAuthenticate(name, user);
        Iterator<ODatabaseLifecycleListener> it = this.orient.getDbLifecycleListeners();
        while (it.hasNext()) {
            it.next().onDrop(db);
        }
        db.close();
        OrientDBEmbedded orientDBEmbedded2 = this;
        synchronized (orientDBEmbedded2) {
            if (this.exists(name, user, password)) {
                OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
                ODatabaseDocumentEmbedded.deInit(storage);
                storage.delete();
                this.storages.remove(name);
            }
        }
    }

    @Override
    public synchronized Set<String> listDatabases(String user, String password) {
        this.checkOpen();
        HashSet<String> databases = new HashSet<String>();
        if (this.basePath != null) {
            OrientDBEmbedded.scanDatabaseDirectory(new File(this.basePath), databases::add);
        }
        databases.addAll(this.storages.keySet());
        return databases;
    }

    @Override
    public synchronized void loadAllDatabases() {
        if (this.basePath != null) {
            OrientDBEmbedded.scanDatabaseDirectory(new File(this.basePath), name -> {
                if (!this.storages.containsKey(name)) {
                    OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
                    storage.open(this.getConfigurations().getConfigurations());
                }
            });
        }
    }

    @Override
    public ODatabasePoolInternal openPool(String name, String user, String password) {
        return this.openPool(name, user, password, null);
    }

    @Override
    public ODatabasePoolInternal openPool(String name, String user, String password, OrientDBConfig config) {
        this.checkOpen();
        ODatabasePoolImpl pool = new ODatabasePoolImpl(this, name, user, password, this.solveConfig(config));
        this.pools.add(pool);
        return pool;
    }

    @Override
    public synchronized void close() {
        if (!this.open) {
            return;
        }
        this.removeShutdownHook();
        this.internalClose();
    }

    @Override
    public synchronized void internalClose() {
        if (!this.open) {
            return;
        }
        ArrayList<OAbstractPaginatedStorage> storagesCopy = new ArrayList<OAbstractPaginatedStorage>(this.storages.values());
        for (OAbstractPaginatedStorage stg : storagesCopy) {
            try {
                OLogManager.instance().info((Object)this, "- shutdown storage: " + stg.getName() + "...", new Object[0]);
                ODatabaseDocumentEmbedded.deInit(stg);
                stg.shutdown();
            }
            catch (Exception e) {
                OLogManager.instance().warn((Object)this, "-- error on shutdown storage", e, new Object[0]);
            }
            catch (Error e) {
                OLogManager.instance().warn((Object)this, "-- error on shutdown storage", e, new Object[0]);
                throw e;
            }
        }
        this.storages.clear();
        this.orient.onEmbeddedFactoryClose(this);
        if (this.autoCloseTimer != null) {
            this.autoCloseTimer.cancel();
        }
        this.open = false;
    }

    public OrientDBConfig getConfigurations() {
        return this.configurations;
    }

    @Override
    public void removePool(ODatabasePoolInternal pool) {
        this.pools.remove(pool);
    }

    private static void scanDatabaseDirectory(File directory, DatabaseFound found) {
        try {
            File[] files;
            if (directory.exists() && directory.isDirectory() && (files = directory.listFiles()) != null) {
                for (File db : files) {
                    if (!db.isDirectory()) continue;
                    Path dbPath = Paths.get(db.getAbsolutePath(), new String[0]);
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(dbPath);){
                        stream.forEach(p -> {
                            String fileName;
                            if (!Files.isDirectory(p, new LinkOption[0]) && ((fileName = p.getFileName().toString()).equals("database.ocf") || fileName.startsWith("config") && fileName.endsWith(".cd"))) {
                                int count = p.getNameCount();
                                found.found(OIOUtils.getDatabaseNameFromPath(p.subpath(count - 2, count - 1).toString()));
                            }
                        });
                    }
                }
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new ODatabaseException("Exception during scanning of database directory"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void initCustomStorage(String name, String path, String userName, String userPassword) {
        ODatabaseDocumentEmbedded embedded = null;
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            boolean exists = OLocalPaginatedStorage.exists(Paths.get(path, new String[0]));
            OAbstractPaginatedStorage storage = (OAbstractPaginatedStorage)this.disk.createStorage(path, new HashMap<String, String>(), this.maxWALSegmentSize, this.generateStorageId());
            if (!exists) {
                embedded = this.internalCreate(this.getConfigurations(), storage);
            }
            this.storages.put(name, storage);
        }
        if (embedded != null) {
            embedded.callOnCreateListeners();
            ODatabaseRecordThreadLocal.instance().remove();
        }
    }

    @Override
    public synchronized void removeShutdownHook() {
        this.orient.removeOrientDB(this);
    }

    @Override
    public synchronized Collection<OStorage> getStorages() {
        return this.storages.values().stream().map(x -> x).collect(Collectors.toSet());
    }

    @Override
    public synchronized void forceDatabaseClose(String iDatabaseName) {
        OAbstractPaginatedStorage storage = this.storages.remove(iDatabaseName);
        if (storage != null) {
            ODatabaseDocumentEmbedded.deInit(storage);
            storage.shutdown();
        }
    }

    public String getDatabasePath(String iDatabaseName) {
        OAbstractPaginatedStorage storage = this.storages.get(iDatabaseName);
        if (storage instanceof OLocalPaginatedStorage) {
            return ((OLocalPaginatedStorage)storage).getStoragePath().toString();
        }
        return null;
    }

    private void checkOpen() {
        if (!this.open) {
            throw new ODatabaseException("OrientDB Instance is closed");
        }
    }

    @Override
    public synchronized void replaceFactory(OEmbeddedDatabaseInstanceFactory factory) {
        this.factory = factory;
    }

    @Override
    public OEmbeddedDatabaseInstanceFactory getFactory() {
        return this.factory;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    public static interface InstanceFactory<T> {
        public T create(OAbstractPaginatedStorage var1);
    }

    protected static interface DatabaseFound {
        public void found(String var1);
    }
}

