/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.encryption.impl;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.exception.OInvalidStorageEncryptionKeyException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class OAESGCMEncryption
implements OEncryption {
    public static final String NAME = "aes/gcm";
    private static final String ALGORITHM_NAME = "AES";
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";
    private static final ThreadLocal<Cipher> CIPHER = ThreadLocal.withInitial(OAESGCMEncryption::getCipherInstance);
    private static final int GCM_NONCE_SIZE_IN_BYTES = 12;
    private static final int GCM_TAG_SIZE_IN_BYTES = 16;
    private static final int MIN_CIPHERTEXT_SIZE = 28;
    private static final String NO_SUCH_CIPHER = "AES/GCM/NoPadding not supported.";
    private static final String MISSING_KEY_ERROR = "AESGCMEncryption encryption has been selected, but no key was found. Please configure it by passing the key as property at database create/open. The property key is: '%s'";
    private static final String INVALID_KEY_ERROR = "Failed to initialize AESGCMEncryption. Assure the key is a 128, 192 or 256 bits long BASE64 value";
    private static final String ENCRYPTION_NOT_INITIALIZED_ERROR = "OAESGCMEncryption not properly initialized";
    private static final String AUTHENTICATION_ERROR = "Authentication of encrypted data failed. The encrypted data may have been altered or the used key is incorrect";
    private static final String INVALID_CIPHERTEXT_SIZE_ERROR = "Invalid ciphertext size: minimum: %d, actual: %d";
    private static final String INVALID_RANGE_ERROR = "Invalid range: array size: %d, offset: %d, length: %d";
    private static final String BLOCKING_SECURE_RANDOM_ERROR = "SecureRandom blocked while retrieving randomness. This maybe caused by a misconfigured or absent random source on your operating system.";
    private boolean initialized;
    private SecretKey key;
    private SecureRandom csprng;

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public OEncryption configure(String base64EncodedKey) {
        this.initialized = false;
        this.key = this.createKey(base64EncodedKey);
        this.csprng = this.createSecureRandom();
        OAESGCMEncryption.getCipherInstance();
        this.initialized = true;
        return this;
    }

    @Override
    public byte[] encrypt(byte[] input) {
        return this.encrypt(input, 0, input.length);
    }

    @Override
    public byte[] decrypt(byte[] input) {
        return this.decrypt(input, 0, input.length);
    }

    @Override
    public byte[] encrypt(byte[] input, int offset, int length) {
        this.assertInitialized();
        this.assertRangeIsValid(input.length, offset, length);
        byte[] nonce = this.randomNonce();
        Cipher cipher = this.getAndInitializeCipher(1, nonce);
        int outputLength = 12 + cipher.getOutputSize(length);
        byte[] output = Arrays.copyOf(nonce, outputLength);
        try {
            cipher.doFinal(input, offset, length, output, 12);
            return output;
        }
        catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            throw new IllegalStateException("Unexpected exception during GCM decryption.", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] input, int offset, int length) {
        this.assertInitialized();
        this.assertRangeIsValid(input.length, offset, length);
        this.assertCiphertextSizeIsValid(length);
        byte[] nonce = this.readNonce(input);
        Cipher cipher = this.getAndInitializeCipher(2, nonce);
        try {
            return cipher.doFinal(input, offset + 12, length - 12);
        }
        catch (AEADBadTagException e) {
            throw OException.wrapException(new OSecurityException(AUTHENTICATION_ERROR), e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException("Unexpected exception during GCM decryption.", e);
        }
    }

    private SecretKey createKey(String base64EncodedKey) {
        if (base64EncodedKey == null) {
            throw new OSecurityException(String.format(MISSING_KEY_ERROR, OGlobalConfiguration.STORAGE_ENCRYPTION_KEY.getKey()));
        }
        try {
            byte[] keyBytes = Base64.getDecoder().decode(base64EncodedKey.getBytes());
            this.validateKeySize(keyBytes.length);
            return new SecretKeySpec(keyBytes, ALGORITHM_NAME);
        }
        catch (IllegalArgumentException e) {
            throw OException.wrapException(new OInvalidStorageEncryptionKeyException(INVALID_KEY_ERROR), e);
        }
    }

    private SecureRandom createSecureRandom() {
        SecureRandom secureRandom = new SecureRandom();
        this.assertNonBlocking(secureRandom);
        return secureRandom;
    }

    private void validateKeySize(int numBytes) {
        if (numBytes != 16 && numBytes != 24 && numBytes != 32) {
            throw new OInvalidStorageEncryptionKeyException(INVALID_KEY_ERROR);
        }
    }

    private void assertInitialized() {
        if (!this.initialized) {
            throw new OSecurityException(ENCRYPTION_NOT_INITIALIZED_ERROR);
        }
    }

    private void assertRangeIsValid(int arraySize, int offset, int length) {
        if (offset >= arraySize || offset + length > arraySize) {
            throw new IllegalArgumentException(String.format(INVALID_RANGE_ERROR, arraySize, offset, length));
        }
    }

    private void assertCiphertextSizeIsValid(int size) {
        if (size < 28) {
            throw new OSecurityException(String.format(INVALID_CIPHERTEXT_SIZE_ERROR, 28, size));
        }
    }

    private byte[] randomNonce() {
        byte[] nonce = new byte[12];
        this.csprng.nextBytes(nonce);
        return nonce;
    }

    private byte[] readNonce(byte[] input) {
        return Arrays.copyOf(input, 12);
    }

    private Cipher getAndInitializeCipher(int mode, byte[] nonce) {
        try {
            Cipher cipher = CIPHER.get();
            cipher.init(mode, (Key)this.key, this.gcmParameterSpec(nonce));
            return cipher;
        }
        catch (InvalidKeyException e) {
            throw OException.wrapException(new OInvalidStorageEncryptionKeyException(e.getMessage()), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalArgumentException("Invalid or re-used nonce.", e);
        }
    }

    private void assertNonBlocking(SecureRandom secureRandom) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            executor.submit(() -> secureRandom.nextInt()).get(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (TimeoutException e) {
            throw new OSecurityException(BLOCKING_SECURE_RANDOM_ERROR);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private GCMParameterSpec gcmParameterSpec(byte[] nonce) {
        return new GCMParameterSpec(128, nonce);
    }

    private static Cipher getCipherInstance() {
        try {
            return Cipher.getInstance(TRANSFORMATION);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw OException.wrapException(new OSecurityException(NO_SUCH_CIPHER), e);
        }
    }
}

