/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexOneValue;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;

public class OIndexUnique
extends OIndexOneValue {
    private final OBaseIndexEngine.Validator<Object, ORID> UNIQUE_VALIDATOR = (key, oldValue, newValue) -> {
        if (oldValue != null) {
            if (!oldValue.equals(newValue)) {
                Boolean mergeSameKey;
                Boolean bl = mergeSameKey = this.metadata != null ? (Boolean)this.metadata.field("mergeKeys") : Boolean.FALSE;
                if (mergeSameKey == null || !mergeSameKey.booleanValue()) {
                    throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' previously assigned to the record %s", newValue.getIdentity(), key, this.getName(), oldValue.getIdentity()), this.getName(), oldValue.getIdentity(), key);
                }
            } else {
                return OBaseIndexEngine.Validator.IGNORE;
            }
        }
        if (!newValue.getIdentity().isPersistent()) {
            newValue = (ORID)newValue.getRecord();
        }
        return newValue.getIdentity();
    };

    public OIndexUnique(String name, String typeId, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata, int binaryFormatVersion) {
        super(name, typeId, algorithm, version, storage, valueContainerAlgorithm, metadata, binaryFormatVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexOneValue put(Object key, OIdentifiable iSingleValue) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        try {
            while (true) {
                try {
                    this.storage.validatedPutIndexValue(this.indexId, key, iSingleValue.getIdentity(), this.UNIQUE_VALIDATOR);
                }
                catch (OInvalidIndexEngineIdException ignore) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
            OIndexUnique oIndexUnique = this;
            return oIndexUnique;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return true;
    }

    @Override
    public boolean supportsOrderedIterations() {
        while (true) {
            try {
                return this.storage.hasIndexRangeQuerySupport(this.indexId);
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    @Override
    protected Iterable<OTransactionIndexChangesPerKey.OTransactionIndexEntry> interpretTxKeyChanges(OTransactionIndexChangesPerKey changes) {
        return changes.interpret(OTransactionIndexChangesPerKey.Interpretation.Unique);
    }
}

