/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClusters;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Arrays;

public class ORecordIteratorClass<REC extends ORecord>
extends ORecordIteratorClusters<REC> {
    protected final OClass targetClass;
    protected boolean polymorphic;

    public ORecordIteratorClass(ODatabaseDocumentInternal iDatabase, String iClassName, boolean iPolymorphic) {
        this(iDatabase, iClassName, iPolymorphic, true);
    }

    public ORecordIteratorClass(ODatabaseDocumentInternal iDatabase, String iClassName, boolean iPolymorphic, boolean begin) {
        this(iDatabase, iClassName, iPolymorphic, OStorage.LOCKING_STRATEGY.DEFAULT);
        if (begin) {
            this.begin();
        }
    }

    @Deprecated
    public ORecordIteratorClass(ODatabaseDocumentInternal iDatabase, String iClassName, boolean iPolymorphic, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        super(iDatabase, iLockingStrategy);
        this.targetClass = this.database.getMetadata().getImmutableSchemaSnapshot().getClass(iClassName);
        if (this.targetClass == null) {
            throw new IllegalArgumentException("Class '" + iClassName + "' was not found in database schema");
        }
        this.polymorphic = iPolymorphic;
        this.clusterIds = this.polymorphic ? this.targetClass.getPolymorphicClusterIds() : this.targetClass.getClusterIds();
        this.clusterIds = OClassImpl.readableClusters(iDatabase, this.clusterIds);
        this.checkForSystemClusters(iDatabase, this.clusterIds);
        Arrays.sort(this.clusterIds);
        this.config();
    }

    protected ORecordIteratorClass(ODatabaseDocumentInternal database, OClass targetClass, boolean polymorphic) {
        super(database, targetClass.getPolymorphicClusterIds());
        this.targetClass = targetClass;
        this.polymorphic = polymorphic;
    }

    @Override
    public REC next() {
        Object rec = super.next();
        if (rec == null) {
            return null;
        }
        return (REC)rec.getRecord();
    }

    @Override
    public REC previous() {
        OIdentifiable rec = super.previous();
        if (rec == null) {
            return null;
        }
        return (REC)rec.getRecord();
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    @Override
    public String toString() {
        return String.format("ORecordIteratorClass.targetClass(%s).polymorphic(%s)", this.targetClass, this.polymorphic);
    }

    @Override
    protected boolean include(ORecord record) {
        return record instanceof ODocument && this.targetClass.isSuperClassOf(ODocumentInternal.getImmutableSchemaClass((ODocument)record));
    }

    public OClass getTargetClass() {
        return this.targetClass;
    }

    @Override
    protected void config() {
        this.currentClusterIdx = 0;
        this.updateClusterRange();
        this.totalAvailableRecords = this.database.countClusterElements(this.clusterIds);
        this.txEntries = this.database.getTransaction().getNewRecordEntriesByClass(this.targetClass, this.polymorphic);
        if (this.txEntries != null) {
            for (ORecordOperation entry : this.txEntries) {
                if (!entry.getRecord().getIdentity().isPersistent() && entry.type != 2) {
                    ++this.totalAvailableRecords;
                    continue;
                }
                if (entry.type != 2) continue;
                --this.totalAvailableRecords;
            }
        }
    }
}

