/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import java.util.Map;

public class OCommandExecutorSQLAlterSequence
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_ALTER = "ALTER";
    public static final String KEYWORD_SEQUENCE = "SEQUENCE";
    public static final String KEYWORD_START = "START";
    public static final String KEYWORD_INCREMENT = "INCREMENT";
    public static final String KEYWORD_CACHE = "CACHE";
    private String sequenceName;
    private OSequence.CreateParams params;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLAlterSequence parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            String temp;
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            this.init((OCommandRequestText)iRequest);
            ODatabaseDocumentInternal database = OCommandExecutorSQLAlterSequence.getDatabase();
            StringBuilder word = new StringBuilder();
            this.parserRequiredKeyword(KEYWORD_ALTER);
            this.parserRequiredKeyword(KEYWORD_SEQUENCE);
            this.sequenceName = this.parserRequiredWord(false, "Expected <sequence name>");
            this.params = new OSequence.CreateParams();
            while ((temp = this.parseOptionalWord(true, new String[0])) != null) {
                if (this.parserIsEnded()) {
                    break;
                }
                if (temp.equals(KEYWORD_START)) {
                    String startAsString = this.parserRequiredWord(true, "Expected <start value>");
                    this.params.start = Long.parseLong(startAsString);
                    continue;
                }
                if (temp.equals(KEYWORD_INCREMENT)) {
                    String incrementAsString = this.parserRequiredWord(true, "Expected <increment value>");
                    this.params.increment = Integer.parseInt(incrementAsString);
                    continue;
                }
                if (!temp.equals(KEYWORD_CACHE)) continue;
                String cacheAsString = this.parserRequiredWord(true, "Expected <cache value>");
                this.params.cacheSize = Integer.parseInt(cacheAsString);
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.sequenceName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseDocumentInternal database = OCommandExecutorSQLAlterSequence.getDatabase();
        OSequence sequence = database.getMetadata().getSequenceLibrary().getSequence(this.sequenceName);
        boolean result = sequence.updateParams(this.params);
        sequence.reset();
        sequence.save(OCommandExecutorSQLAlterSequence.getDatabase());
        return result;
    }

    @Override
    public String getSyntax() {
        return "ALTER SEQUENCE <sequence> [START <value>] [INCREMENT <value>] [CACHE <value>]";
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }
}

